/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import com.google.protobuf.ExtensionRegistryLite;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.descriptors.serialization.ClassData;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBuf;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.NameTable;
import org.jetbrains.jet.descriptors.serialization.PackageData;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JavaProtoBufUtil {
    private JavaProtoBufUtil() {
    }

    @Nullable
    public static Method loadMethodSignature(@NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver) {
        if (!proto.hasExtension(JavaProtoBuf.methodSignature)) {
            return null;
        }
        JavaProtoBuf.JavaMethodSignature signature = proto.getExtension(JavaProtoBuf.methodSignature);
        return new Deserializer(nameResolver).methodSignature(signature);
    }

    @Nullable
    public static Method loadPropertyGetterSignature(@NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver) {
        if (!proto.hasExtension(JavaProtoBuf.propertySignature)) {
            return null;
        }
        JavaProtoBuf.JavaPropertySignature propertySignature = proto.getExtension(JavaProtoBuf.propertySignature);
        return new Deserializer(nameResolver).methodSignature(propertySignature.getGetter());
    }

    @Nullable
    public static Method loadPropertySetterSignature(@NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver) {
        if (!proto.hasExtension(JavaProtoBuf.propertySignature)) {
            return null;
        }
        JavaProtoBuf.JavaPropertySignature propertySignature = proto.getExtension(JavaProtoBuf.propertySignature);
        return new Deserializer(nameResolver).methodSignature(propertySignature.getSetter());
    }

    @Nullable
    public static PropertyData loadPropertyData(@NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver) {
        if (!proto.hasExtension(JavaProtoBuf.propertySignature)) {
            return null;
        }
        JavaProtoBuf.JavaPropertySignature propertySignature = proto.getExtension(JavaProtoBuf.propertySignature);
        if (propertySignature.hasField()) {
            JavaProtoBuf.JavaFieldSignature field = propertySignature.getField();
            Type type = new Deserializer(nameResolver).type(field.getType());
            Name name = nameResolver.getName(field.getName());
            return new PropertyData(type, name.asString(), null);
        }
        if (propertySignature.hasSyntheticMethodName()) {
            Name name = nameResolver.getName(propertySignature.getSyntheticMethodName());
            return new PropertyData(null, null, name.asString());
        }
        return null;
    }

    @Nullable
    public static Name loadSrcClassName(@NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver) {
        if (!proto.hasExtension(JavaProtoBuf.srcClassName)) {
            return null;
        }
        return nameResolver.getName(proto.getExtension(JavaProtoBuf.srcClassName));
    }

    public static boolean isStaticFieldInOuter(@NotNull ProtoBuf.Callable proto) {
        if (!proto.hasExtension(JavaProtoBuf.propertySignature)) {
            return false;
        }
        JavaProtoBuf.JavaPropertySignature propertySignature = proto.getExtension(JavaProtoBuf.propertySignature);
        return propertySignature.hasField() && propertySignature.getField().getIsStaticInOuter();
    }

    public static void saveMethodSignature(@NotNull ProtoBuf.Callable.Builder proto, @NotNull Method method, @NotNull NameTable nameTable) {
        proto.setExtension(JavaProtoBuf.methodSignature, new Serializer(nameTable).methodSignature(method));
    }

    public static void savePropertySignature(@NotNull ProtoBuf.Callable.Builder proto, @Nullable Type fieldType, @Nullable String fieldName, boolean isStaticInOuter, @Nullable String syntheticMethodName, @Nullable Method getter, @Nullable Method setter, @NotNull NameTable nameTable) {
        proto.setExtension(JavaProtoBuf.propertySignature, new Serializer(nameTable).propertySignature(fieldType, fieldName, isStaticInOuter, syntheticMethodName, getter, setter));
    }

    public static void saveSrcClassName(@NotNull ProtoBuf.Callable.Builder proto, @NotNull Name name, @NotNull NameTable nameTable) {
        proto.setExtension(JavaProtoBuf.srcClassName, nameTable.getSimpleNameIndex(name));
    }

    @NotNull
    public static ExtensionRegistryLite getExtensionRegistry() {
        ExtensionRegistryLite registry = ExtensionRegistryLite.newInstance();
        JavaProtoBuf.registerAllExtensions(registry);
        return registry;
    }

    @NotNull
    public static ClassData readClassDataFrom(@NotNull String[] data) {
        return ClassData.read(JavaProtoBufUtil.decodeBytes(data), JavaProtoBufUtil.getExtensionRegistry());
    }

    @NotNull
    public static PackageData readPackageDataFrom(@NotNull String[] data) {
        return PackageData.read(JavaProtoBufUtil.decodeBytes(data), JavaProtoBufUtil.getExtensionRegistry());
    }

    @NotNull
    public static String[] encodeBytes(@NotNull byte[] data) {
        byte[] bytes = JavaProtoBufUtil.encode8to7(data);
        JavaProtoBufUtil.addModuloByte(bytes, 1);
        return JavaProtoBufUtil.splitBytesToStringArray(bytes);
    }

    @NotNull
    private static byte[] encode8to7(@NotNull byte[] data) {
        int resultLength = (data.length * 8 + 6) / 7;
        byte[] result = new byte[resultLength];
        int byteIndex = 0;
        int bit = 0;
        for (int i = 0; i < resultLength - 1; ++i) {
            if (bit == 0) {
                result[i] = (byte)(data[byteIndex] & 0x7F);
                bit = 7;
                continue;
            }
            int firstPart = (data[byteIndex] & 0xFF) >>> bit;
            int newBit = bit + 7 & 7;
            int secondPart = (data[++byteIndex] & (1 << newBit) - 1) << 8 - bit;
            result[i] = (byte)(firstPart + secondPart);
            bit = newBit;
        }
        if (resultLength > 0) {
            assert (bit != 0) : "The last chunk cannot start from the input byte since otherwise at least one bit will remain unprocessed";
            assert (byteIndex == data.length - 1) : "The last 7-bit chunk should be encoded from the last input byte: " + byteIndex + " != " + (data.length - 1);
            result[resultLength - 1] = (byte)((data[byteIndex] & 0xFF) >>> bit);
        }
        return result;
    }

    private static void addModuloByte(@NotNull byte[] data, int increment) {
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            data[i] = (byte)(data[i] + increment & 0x7F);
        }
    }

    @NotNull
    private static String[] splitBytesToStringArray(@NotNull byte[] data) {
        ArrayList<String> result = new ArrayList<String>();
        int off = 0;
        int len = 0;
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            if (len >= 65534) {
                assert (len <= 65535) : "Produced strings cannot contain more than 65535 bytes: " + len;
                result.add(new String(data, off, i - off));
                off = i;
                len = 0;
            }
            if (data[i] == 0) {
                len += 2;
                continue;
            }
            ++len;
        }
        if (len >= 0) {
            result.add(new String(data, off, data.length - off));
        }
        return result.toArray(new String[result.size()]);
    }

    @NotNull
    public static byte[] decodeBytes(@NotNull String[] data) {
        byte[] bytes = JavaProtoBufUtil.combineStringArrayIntoBytes(data);
        JavaProtoBufUtil.addModuloByte(bytes, 127);
        return JavaProtoBufUtil.decode7to8(bytes);
    }

    @NotNull
    private static byte[] combineStringArrayIntoBytes(@NotNull String[] data) {
        int resultLength = 0;
        for (String s : data) {
            assert (s.length() <= 65535) : "Too long string: " + s.length();
            resultLength += s.length();
        }
        byte[] result = new byte[resultLength];
        int p = 0;
        for (String s : data) {
            int n = s.length();
            for (int i = 0; i < n; ++i) {
                result[p++] = (byte)s.charAt(i);
            }
        }
        return result;
    }

    @NotNull
    private static byte[] decode7to8(@NotNull byte[] data) {
        int resultLength = 7 * data.length / 8;
        byte[] result = new byte[resultLength];
        int byteIndex = 0;
        int bit = 0;
        for (int i = 0; i < resultLength; ++i) {
            int firstPart = (data[byteIndex] & 0xFF) >>> bit;
            int secondPart = (data[++byteIndex] & (1 << bit + 1) - 1) << 7 - bit;
            result[i] = (byte)(firstPart + secondPart);
            if (bit == 6) {
                ++byteIndex;
                bit = 0;
                continue;
            }
            ++bit;
        }
        return result;
    }

    private static class Deserializer {
        private static final Type[] PRIMITIVE_TYPES = new Type[]{Type.VOID_TYPE, Type.BOOLEAN_TYPE, Type.CHAR_TYPE, Type.BYTE_TYPE, Type.SHORT_TYPE, Type.INT_TYPE, Type.FLOAT_TYPE, Type.LONG_TYPE, Type.DOUBLE_TYPE};
        private final NameResolver nameResolver;

        public Deserializer(@NotNull NameResolver nameResolver) {
            this.nameResolver = nameResolver;
        }

        @NotNull
        public Method methodSignature(@NotNull JavaProtoBuf.JavaMethodSignature signature) {
            String name = this.nameResolver.getName(signature.getName()).asString();
            Type returnType = this.type(signature.getReturnType());
            int parameters = signature.getParameterTypeCount();
            Type[] parameterTypes = new Type[parameters];
            for (int i = 0; i < parameters; ++i) {
                parameterTypes[i] = this.type(signature.getParameterType(i));
            }
            return new Method(name, returnType, parameterTypes);
        }

        @NotNull
        private Type type(@NotNull JavaProtoBuf.JavaType type) {
            Type result = type.hasPrimitiveType() ? PRIMITIVE_TYPES[type.getPrimitiveType().ordinal()] : Type.getObjectType(Deserializer.fqNameToInternalName(this.nameResolver.getFqName(type.getClassFqName())));
            StringBuilder brackets = new StringBuilder(type.getArrayDimension());
            for (int i = 0; i < type.getArrayDimension(); ++i) {
                brackets.append('[');
            }
            return Type.getType(brackets + result.getDescriptor());
        }

        @NotNull
        private static String fqNameToInternalName(@NotNull FqName fqName) {
            return fqName.asString().replace('.', '/');
        }
    }

    private static class Serializer {
        private final NameTable nameTable;

        public Serializer(@NotNull NameTable nameTable) {
            this.nameTable = nameTable;
        }

        @NotNull
        public JavaProtoBuf.JavaMethodSignature methodSignature(@NotNull Method method) {
            JavaProtoBuf.JavaMethodSignature.Builder signature = JavaProtoBuf.JavaMethodSignature.newBuilder();
            signature.setName(this.nameTable.getSimpleNameIndex(Name.guess(method.getName())));
            signature.setReturnType(this.type(method.getReturnType()));
            for (Type type : method.getArgumentTypes()) {
                signature.addParameterType(this.type(type));
            }
            return signature.build();
        }

        @NotNull
        public JavaProtoBuf.JavaPropertySignature propertySignature(@Nullable Type fieldType, @Nullable String fieldName, boolean isStaticInOuter, @Nullable String syntheticMethodName, @Nullable Method getter, @Nullable Method setter) {
            JavaProtoBuf.JavaPropertySignature.Builder signature = JavaProtoBuf.JavaPropertySignature.newBuilder();
            if (fieldType != null) {
                assert (fieldName != null) : "Field name shouldn't be null when there's a field type: " + fieldType;
                signature.setField(this.fieldSignature(fieldType, fieldName, isStaticInOuter));
            }
            if (syntheticMethodName != null) {
                signature.setSyntheticMethodName(this.nameTable.getSimpleNameIndex(Name.guess(syntheticMethodName)));
            }
            if (getter != null) {
                signature.setGetter(this.methodSignature(getter));
            }
            if (setter != null) {
                signature.setSetter(this.methodSignature(setter));
            }
            return signature.build();
        }

        @NotNull
        public JavaProtoBuf.JavaFieldSignature fieldSignature(@NotNull Type type, @NotNull String name, boolean isStaticInOuter) {
            JavaProtoBuf.JavaFieldSignature.Builder signature = JavaProtoBuf.JavaFieldSignature.newBuilder();
            signature.setName(this.nameTable.getSimpleNameIndex(Name.guess(name)));
            signature.setType(this.type(type));
            if (isStaticInOuter) {
                signature.setIsStaticInOuter(true);
            }
            return signature.build();
        }

        @NotNull
        public JavaProtoBuf.JavaType type(@NotNull Type givenType) {
            JavaProtoBuf.JavaType.Builder builder = JavaProtoBuf.JavaType.newBuilder();
            int arrayDimension = 0;
            Type type = givenType;
            while (type.getSort() == 9) {
                ++arrayDimension;
                type = type.getElementType();
            }
            if (arrayDimension != 0) {
                builder.setArrayDimension(arrayDimension);
            }
            if (type.getSort() == 10) {
                FqName fqName = Serializer.internalNameToFqName(type.getInternalName());
                builder.setClassFqName(this.nameTable.getFqNameIndex(fqName));
            } else {
                builder.setPrimitiveType(JavaProtoBuf.JavaType.PrimitiveType.valueOf(type.getSort()));
            }
            return builder.build();
        }

        @NotNull
        private static FqName internalNameToFqName(@NotNull String internalName) {
            return FqName.fromSegments(Arrays.asList(internalName.split("/")));
        }
    }

    public static class PropertyData {
        private final Type fieldType;
        private final String fieldName;
        private final String syntheticMethodName;

        public PropertyData(@Nullable Type fieldType, @Nullable String fieldName, @Nullable String syntheticMethodName) {
            this.fieldType = fieldType;
            this.fieldName = fieldName;
            this.syntheticMethodName = syntheticMethodName;
        }

        @Nullable
        public Type getFieldType() {
            return this.fieldType;
        }

        @Nullable
        public String getFieldName() {
            return this.fieldName;
        }

        @Nullable
        public String getSyntheticMethodName() {
            return this.syntheticMethodName;
        }

        public String toString() {
            return this.fieldName != null ? "Field " + this.fieldName + " " + this.fieldType : "Synthetic method " + this.syntheticMethodName;
        }
    }
}

