/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization.descriptors;

import com.intellij.openapi.util.Computable;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.DescriptorDeserializer;
import org.jetbrains.jet.descriptors.serialization.Flags;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public abstract class DeserializedMemberScope
implements JetScope {
    private static final Filter<ProtoBuf.Callable.CallableKind> FUNCTION = new Filter<ProtoBuf.Callable.CallableKind>(){

        @Override
        public boolean accept(ProtoBuf.Callable.CallableKind value) {
            return value == ProtoBuf.Callable.CallableKind.FUN;
        }
    };
    private static final Filter<ProtoBuf.Callable.CallableKind> PROPERTY = new Filter<ProtoBuf.Callable.CallableKind>(){

        @Override
        public boolean accept(ProtoBuf.Callable.CallableKind value) {
            return value == ProtoBuf.Callable.CallableKind.VAL || value == ProtoBuf.Callable.CallableKind.VAR || value == ProtoBuf.Callable.CallableKind.OBJECT_PROPERTY;
        }
    };
    private final DeclarationDescriptor containingDeclaration;
    private final DescriptorDeserializer deserializer;
    private final Map<Name, List<ProtoBuf.Callable>> membersProtos;
    private final MemoizedFunctionToNotNull<Name, Collection<FunctionDescriptor>> functions;
    private final MemoizedFunctionToNotNull<Name, Collection<VariableDescriptor>> properties;
    private final NotNullLazyValue<Collection<DeclarationDescriptor>> allDescriptors;
    private final NotNullLazyValue<Collection<ClassDescriptor>> objectDescriptors;

    public DeserializedMemberScope(@NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull DescriptorDeserializer deserializer, @NotNull List<ProtoBuf.Callable> membersList) {
        this.containingDeclaration = containingDeclaration;
        this.deserializer = deserializer;
        this.membersProtos = this.groupByName(membersList);
        this.functions = storageManager.createMemoizedFunction(new Function<Name, Collection<FunctionDescriptor>>(){

            @Override
            public Collection<FunctionDescriptor> fun(Name name) {
                return DeserializedMemberScope.this.computeFunctions(name);
            }
        }, StorageManager.ReferenceKind.STRONG);
        this.properties = storageManager.createMemoizedFunction(new Function<Name, Collection<VariableDescriptor>>(){

            @Override
            public Collection<VariableDescriptor> fun(Name name) {
                return DeserializedMemberScope.this.computeProperties(name);
            }
        }, StorageManager.ReferenceKind.STRONG);
        this.allDescriptors = storageManager.createLazyValue(new Computable<Collection<DeclarationDescriptor>>(){

            @Override
            public Collection<DeclarationDescriptor> compute() {
                return DeserializedMemberScope.this.computeAllDescriptors();
            }
        });
        this.objectDescriptors = storageManager.createLazyValue(new Computable<Collection<ClassDescriptor>>(){

            @Override
            public Collection<ClassDescriptor> compute() {
                return DeserializedMemberScope.this.computeAllObjectDescriptors();
            }
        });
    }

    @NotNull
    private Map<Name, List<ProtoBuf.Callable>> groupByName(@NotNull Collection<ProtoBuf.Callable> membersList) {
        HashMap<Name, List<ProtoBuf.Callable>> map = new HashMap<Name, List<ProtoBuf.Callable>>();
        for (ProtoBuf.Callable memberProto : membersList) {
            Name name = this.deserializer.getNameResolver().getName(memberProto.getName());
            ArrayList<ProtoBuf.Callable> protos = (ArrayList<ProtoBuf.Callable>)map.get(name);
            if (protos == null) {
                protos = new ArrayList<ProtoBuf.Callable>(1);
                map.put(name, protos);
            }
            protos.add(memberProto);
        }
        return map;
    }

    @NotNull
    private <D extends CallableMemberDescriptor> Collection<D> computeMembersByName(Name name, Filter<ProtoBuf.Callable.CallableKind> callableKind) {
        List<ProtoBuf.Callable> memberProtos = this.membersProtos.get(name);
        LinkedHashSet<CallableMemberDescriptor> descriptors = new LinkedHashSet<CallableMemberDescriptor>(memberProtos != null ? memberProtos.size() : 0);
        if (memberProtos != null) {
            for (ProtoBuf.Callable memberProto : memberProtos) {
                if (!callableKind.accept(Flags.CALLABLE_KIND.get(memberProto.getFlags()))) continue;
                descriptors.add(this.deserializer.loadCallable(memberProto));
            }
        }
        return descriptors;
    }

    @NotNull
    private Collection<FunctionDescriptor> computeFunctions(@NotNull Name name) {
        Collection<FunctionDescriptor> descriptors = this.computeMembersByName(name, FUNCTION);
        this.computeNonDeclaredFunctions(name, descriptors);
        return descriptors;
    }

    protected void computeNonDeclaredFunctions(@NotNull Name name, @NotNull Collection<FunctionDescriptor> functions) {
    }

    @Override
    @NotNull
    public final Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
        return this.functions.fun(name);
    }

    @NotNull
    private Collection<VariableDescriptor> computeProperties(@NotNull Name name) {
        Collection<VariableDescriptor> descriptors = this.computeMembersByName(name, PROPERTY);
        this.computeNonDeclaredProperties(name, descriptors);
        return descriptors;
    }

    protected void computeNonDeclaredProperties(@NotNull Name name, @NotNull Collection<PropertyDescriptor> descriptors) {
    }

    @Override
    @NotNull
    public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
        return this.properties.fun(name);
    }

    @Override
    @Nullable
    public final ClassifierDescriptor getClassifier(@NotNull Name name) {
        return this.getClassDescriptor(name);
    }

    @Nullable
    protected abstract ClassifierDescriptor getClassDescriptor(@NotNull Name var1);

    protected abstract void addAllClassDescriptors(@NotNull Collection<DeclarationDescriptor> var1);

    @Override
    @Nullable
    public abstract ClassDescriptor getObjectDescriptor(@NotNull Name var1);

    @NotNull
    protected abstract Collection<ClassDescriptor> computeAllObjectDescriptors();

    @Override
    @NotNull
    public Collection<ClassDescriptor> getObjectDescriptors() {
        return this.objectDescriptors.compute();
    }

    @Override
    @Nullable
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        return null;
    }

    @Override
    @Nullable
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        return null;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.containingDeclaration;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    @Nullable
    public PropertyDescriptor getPropertyByFieldReference(@NotNull Name fieldName) {
        throw new UnsupportedOperationException("Should not be called");
    }

    private Collection<DeclarationDescriptor> computeAllDescriptors() {
        LinkedHashSet<DeclarationDescriptor> result = new LinkedHashSet<DeclarationDescriptor>(0);
        for (Name name : this.membersProtos.keySet()) {
            result.addAll(this.getFunctions(name));
            result.addAll(this.getProperties(name));
        }
        this.addNonDeclaredDescriptors(result);
        this.addAllClassDescriptors(result);
        return result;
    }

    protected abstract void addNonDeclaredDescriptors(@NotNull Collection<DeclarationDescriptor> var1);

    @Override
    @NotNull
    public final Collection<DeclarationDescriptor> getAllDescriptors() {
        return this.allDescriptors.compute();
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        ReceiverParameterDescriptor receiver = this.getImplicitReceiver();
        if (receiver != null) {
            return Collections.singletonList(receiver);
        }
        return Collections.emptyList();
    }

    @Nullable
    protected abstract ReceiverParameterDescriptor getImplicitReceiver();

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        return this.getAllDescriptors();
    }

    private static interface Filter<T> {
        public boolean accept(T var1);
    }
}

