/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.di;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinderImpl;
import org.jetbrains.jet.lang.resolve.java.resolver.AnnotationDescriptorDeserializer;
import org.jetbrains.jet.lang.resolve.java.resolver.DeserializedDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaCompileTimeConstResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaConstructorResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaFunctionResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaNamespaceResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaPropertyResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaSupertypeResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaValueParameterResolver;
import org.jetbrains.jet.lang.resolve.java.vfilefinder.VirtualFileFinder;

public class InjectorForJavaDescriptorResolver {
    private final Project project;
    private final BindingTrace bindingTrace;
    private final JavaDescriptorResolver javaDescriptorResolver;
    private final PsiClassFinderImpl psiClassFinder;
    private final VirtualFileFinder virtualFileFinder;
    private final JavaClassResolver javaClassResolver;
    private final JavaAnnotationResolver javaAnnotationResolver;
    private final JavaCompileTimeConstResolver javaCompileTimeConstResolver;
    private final JavaFunctionResolver javaFunctionResolver;
    private final JavaValueParameterResolver javaValueParameterResolver;
    private final JavaTypeTransformer javaTypeTransformer;
    private final JavaSignatureResolver javaSignatureResolver;
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;
    private final AnnotationDescriptorDeserializer annotationDescriptorDeserializer;
    private final JavaNamespaceResolver javaNamespaceResolver;
    private final JavaSupertypeResolver javaSupertypeResolver;
    private final JavaConstructorResolver javaConstructorResolver;
    private final JavaPropertyResolver javaPropertyResolver;

    public InjectorForJavaDescriptorResolver(@NotNull Project project, @NotNull BindingTrace bindingTrace) {
        this.project = project;
        this.bindingTrace = bindingTrace;
        this.javaDescriptorResolver = new JavaDescriptorResolver();
        this.psiClassFinder = new PsiClassFinderImpl();
        this.virtualFileFinder = ServiceManager.getService(project, VirtualFileFinder.class);
        this.javaClassResolver = new JavaClassResolver();
        this.javaAnnotationResolver = new JavaAnnotationResolver();
        this.javaCompileTimeConstResolver = new JavaCompileTimeConstResolver();
        this.javaFunctionResolver = new JavaFunctionResolver();
        this.javaValueParameterResolver = new JavaValueParameterResolver();
        this.javaTypeTransformer = new JavaTypeTransformer();
        this.javaSignatureResolver = new JavaSignatureResolver();
        this.deserializedDescriptorResolver = new DeserializedDescriptorResolver();
        this.annotationDescriptorDeserializer = new AnnotationDescriptorDeserializer();
        this.javaNamespaceResolver = new JavaNamespaceResolver();
        this.javaSupertypeResolver = new JavaSupertypeResolver();
        this.javaConstructorResolver = new JavaConstructorResolver();
        this.javaPropertyResolver = new JavaPropertyResolver();
        this.javaDescriptorResolver.setClassResolver(this.javaClassResolver);
        this.javaDescriptorResolver.setConstructorResolver(this.javaConstructorResolver);
        this.javaDescriptorResolver.setFunctionResolver(this.javaFunctionResolver);
        this.javaDescriptorResolver.setNamespaceResolver(this.javaNamespaceResolver);
        this.javaDescriptorResolver.setPropertiesResolver(this.javaPropertyResolver);
        this.psiClassFinder.setProject(project);
        this.javaClassResolver.setAnnotationResolver(this.javaAnnotationResolver);
        this.javaClassResolver.setFunctionResolver(this.javaFunctionResolver);
        this.javaClassResolver.setJavaDescriptorResolver(this.javaDescriptorResolver);
        this.javaClassResolver.setKotlinDescriptorResolver(this.deserializedDescriptorResolver);
        this.javaClassResolver.setNamespaceResolver(this.javaNamespaceResolver);
        this.javaClassResolver.setPsiClassFinder(this.psiClassFinder);
        this.javaClassResolver.setSignatureResolver(this.javaSignatureResolver);
        this.javaClassResolver.setSupertypesResolver(this.javaSupertypeResolver);
        this.javaClassResolver.setTrace(bindingTrace);
        this.javaClassResolver.setVirtualFileFinder(this.virtualFileFinder);
        this.javaAnnotationResolver.setClassResolver(this.javaClassResolver);
        this.javaAnnotationResolver.setCompileTimeConstResolver(this.javaCompileTimeConstResolver);
        this.javaCompileTimeConstResolver.setAnnotationResolver(this.javaAnnotationResolver);
        this.javaCompileTimeConstResolver.setClassResolver(this.javaClassResolver);
        this.javaFunctionResolver.setAnnotationResolver(this.javaAnnotationResolver);
        this.javaFunctionResolver.setParameterResolver(this.javaValueParameterResolver);
        this.javaFunctionResolver.setSignatureResolver(this.javaSignatureResolver);
        this.javaFunctionResolver.setTrace(bindingTrace);
        this.javaFunctionResolver.setTypeTransformer(this.javaTypeTransformer);
        this.javaValueParameterResolver.setTypeTransformer(this.javaTypeTransformer);
        this.javaTypeTransformer.setResolver(this.javaDescriptorResolver);
        this.javaSignatureResolver.setTypeTransformer(this.javaTypeTransformer);
        this.deserializedDescriptorResolver.setAnnotationDeserializer(this.annotationDescriptorDeserializer);
        this.deserializedDescriptorResolver.setJavaClassResolver(this.javaClassResolver);
        this.deserializedDescriptorResolver.setJavaNamespaceResolver(this.javaNamespaceResolver);
        this.annotationDescriptorDeserializer.setJavaClassResolver(this.javaClassResolver);
        this.annotationDescriptorDeserializer.setPsiClassFinder(this.psiClassFinder);
        this.annotationDescriptorDeserializer.setVirtualFileFinder(this.virtualFileFinder);
        this.javaNamespaceResolver.setDeserializedDescriptorResolver(this.deserializedDescriptorResolver);
        this.javaNamespaceResolver.setJavaDescriptorResolver(this.javaDescriptorResolver);
        this.javaNamespaceResolver.setPsiClassFinder(this.psiClassFinder);
        this.javaNamespaceResolver.setTrace(bindingTrace);
        this.javaNamespaceResolver.setVirtualFileFinder(this.virtualFileFinder);
        this.javaSupertypeResolver.setClassResolver(this.javaClassResolver);
        this.javaSupertypeResolver.setTrace(bindingTrace);
        this.javaSupertypeResolver.setTypeTransformer(this.javaTypeTransformer);
        this.javaConstructorResolver.setTrace(bindingTrace);
        this.javaConstructorResolver.setTypeTransformer(this.javaTypeTransformer);
        this.javaConstructorResolver.setValueParameterResolver(this.javaValueParameterResolver);
        this.javaPropertyResolver.setAnnotationResolver(this.javaAnnotationResolver);
        this.javaPropertyResolver.setTrace(bindingTrace);
        this.javaPropertyResolver.setTypeTransformer(this.javaTypeTransformer);
        this.psiClassFinder.initialize();
    }

    @PreDestroy
    public void destroy() {
    }

    public JavaDescriptorResolver getJavaDescriptorResolver() {
        return this.javaDescriptorResolver;
    }

    public PsiClassFinderImpl getPsiClassFinder() {
        return this.psiClassFinder;
    }
}

