/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Predicates;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerBasic;
import org.jetbrains.jet.lang.ModuleConfiguration;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceLikeBuilder;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceLikeBuilderDummy;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodyResolver;
import org.jetbrains.jet.lang.resolve.DeclarationResolver;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.NamespaceFactoryImpl;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.OverloadResolver;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.TypeHierarchyResolver;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class TopDownAnalyzer {
    @NotNull
    private DeclarationResolver declarationResolver;
    @NotNull
    private TypeHierarchyResolver typeHierarchyResolver;
    @NotNull
    private OverrideResolver overrideResolver;
    @NotNull
    private OverloadResolver overloadResolver;
    @NotNull
    private TopDownAnalysisParameters topDownAnalysisParameters;
    @NotNull
    private TopDownAnalysisContext context;
    @NotNull
    private BindingTrace trace;
    @NotNull
    private ModuleDescriptor moduleDescriptor;
    @NotNull
    private NamespaceFactoryImpl namespaceFactory;
    @NotNull
    private BodyResolver bodyResolver;

    public void setDeclarationResolver(@NotNull DeclarationResolver declarationResolver) {
        this.declarationResolver = declarationResolver;
    }

    public void setTypeHierarchyResolver(@NotNull TypeHierarchyResolver typeHierarchyResolver) {
        this.typeHierarchyResolver = typeHierarchyResolver;
    }

    public void setOverrideResolver(@NotNull OverrideResolver overrideResolver) {
        this.overrideResolver = overrideResolver;
    }

    public void setOverloadResolver(@NotNull OverloadResolver overloadResolver) {
        this.overloadResolver = overloadResolver;
    }

    public void setTopDownAnalysisParameters(@NotNull TopDownAnalysisParameters topDownAnalysisParameters) {
        this.topDownAnalysisParameters = topDownAnalysisParameters;
    }

    public void setTrace(@NotNull BindingTrace trace) {
        this.trace = trace;
    }

    public void setContext(@NotNull TopDownAnalysisContext context) {
        this.context = context;
    }

    public void setModuleDescriptor(@NotNull ModuleDescriptor moduleDescriptor) {
        this.moduleDescriptor = moduleDescriptor;
    }

    public void setNamespaceFactory(@NotNull NamespaceFactoryImpl namespaceFactory) {
        this.namespaceFactory = namespaceFactory;
    }

    public void setBodyResolver(@NotNull BodyResolver bodyResolver) {
        this.bodyResolver = bodyResolver;
    }

    public void doProcess(JetScope outerScope, NamespaceLikeBuilder owner, Collection<? extends PsiElement> declarations) {
        this.context.debug("Enter");
        this.typeHierarchyResolver.process(outerScope, owner, declarations);
        this.declarationResolver.process(outerScope);
        this.overrideResolver.process();
        this.lockScopes();
        this.overloadResolver.process();
        if (!this.topDownAnalysisParameters.isAnalyzingBootstrapLibrary()) {
            this.bodyResolver.resolveBodies();
        }
        this.context.debug("Exit");
        this.context.printDebugOutput(System.out);
    }

    private void lockScopes() {
        for (MutableClassDescriptor mutableClassDescriptor : this.context.getClasses().values()) {
            mutableClassDescriptor.lockScopes();
        }
        for (MutableClassDescriptor mutableClassDescriptor : this.context.getObjects().values()) {
            mutableClassDescriptor.lockScopes();
        }
        for (Map.Entry entry : this.context.getNamespaceScopes().entrySet()) {
            if (((JetFile)entry.getKey()).isScript()) continue;
            ((WritableScope)entry.getValue()).changeLockLevel(WritableScope.LockLevel.READING);
        }
    }

    public static void processStandardLibraryNamespace(@NotNull Project project, @NotNull BindingTrace trace, @NotNull WritableScope outerScope, @NotNull NamespaceDescriptorImpl standardLibraryNamespace, @NotNull List<JetFile> files) {
        TopDownAnalysisParameters topDownAnalysisParameters = new TopDownAnalysisParameters(Predicates.<PsiFile>alwaysFalse(), true, false, Collections.<AnalyzerScriptParameter>emptyList());
        InjectorForTopDownAnalyzerBasic injector = new InjectorForTopDownAnalyzerBasic(project, topDownAnalysisParameters, new ObservableBindingTrace(trace), KotlinBuiltIns.getInstance().getBuiltInsModule());
        injector.getTopDownAnalyzer().doProcessStandardLibraryNamespace(outerScope, standardLibraryNamespace, files);
    }

    private void doProcessStandardLibraryNamespace(WritableScope outerScope, NamespaceDescriptorImpl standardLibraryNamespace, List<JetFile> files) {
        ArrayList<JetDeclaration> toAnalyze = new ArrayList<JetDeclaration>();
        for (JetFile file : files) {
            this.context.getNamespaceDescriptors().put(file, standardLibraryNamespace);
            this.context.getNamespaceScopes().put(file, standardLibraryNamespace.getMemberScope());
            toAnalyze.addAll(file.getDeclarations());
        }
        this.doProcess(outerScope, standardLibraryNamespace.getBuilder(), toAnalyze);
    }

    public static void processClassOrObject(@NotNull ExpressionTypingContext context, final @NotNull DeclarationDescriptor containingDeclaration, @NotNull JetClassOrObject object) {
        ModuleDescriptorImpl moduleDescriptor = new ModuleDescriptorImpl(Name.special("<dummy for object>"), Collections.<ImportPath>emptyList(), PlatformToKotlinClassMap.EMPTY);
        moduleDescriptor.setModuleConfiguration(ModuleConfiguration.EMPTY);
        TopDownAnalysisParameters topDownAnalysisParameters = new TopDownAnalysisParameters(Predicates.equalTo(object.getContainingFile()), false, true, Collections.<AnalyzerScriptParameter>emptyList());
        InjectorForTopDownAnalyzerBasic injector = new InjectorForTopDownAnalyzerBasic(object.getProject(), topDownAnalysisParameters, new ObservableBindingTrace(context.trace), moduleDescriptor);
        injector.getTopDownAnalysisContext().setOuterDataFlowInfo(context.dataFlowInfo);
        injector.getTopDownAnalyzer().doProcess(context.scope, new NamespaceLikeBuilder(){

            @Override
            @NotNull
            public DeclarationDescriptor getOwnerForChildren() {
                return containingDeclaration;
            }

            @Override
            public void addClassifierDescriptor(@NotNull MutableClassDescriptorLite classDescriptor) {
            }

            @Override
            public void addObjectDescriptor(@NotNull MutableClassDescriptorLite objectDescriptor) {
            }

            @Override
            public void addFunctionDescriptor(@NotNull SimpleFunctionDescriptor functionDescriptor) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void addPropertyDescriptor(@NotNull PropertyDescriptor propertyDescriptor) {
            }

            @Override
            public NamespaceLikeBuilder.ClassObjectStatus setClassObjectDescriptor(@NotNull MutableClassDescriptorLite classObjectDescriptor) {
                return NamespaceLikeBuilder.ClassObjectStatus.NOT_ALLOWED;
            }
        }, Collections.singletonList(object));
    }

    public void analyzeFiles(@NotNull Collection<JetFile> files, @NotNull List<AnalyzerScriptParameter> scriptParameters) {
        WritableScopeImpl scope = new WritableScopeImpl(JetScope.EMPTY, this.moduleDescriptor, new TraceBasedRedeclarationHandler(this.trace), "Root scope in analyzeNamespace");
        scope.changeLockLevel(WritableScope.LockLevel.BOTH);
        NamespaceDescriptorImpl rootNs = this.namespaceFactory.createNamespaceDescriptorPathIfNeeded(FqName.ROOT);
        this.namespaceFactory.createNamespaceDescriptorPathIfNeeded(KotlinBuiltIns.getInstance().getBuiltInsPackageFqName());
        scope.importScope(rootNs.getMemberScope());
        scope.changeLockLevel(WritableScope.LockLevel.READING);
        this.doProcess(scope, new NamespaceLikeBuilderDummy(), files);
    }

    public void prepareForTheNextReplLine() {
        this.context.getScriptScopes().clear();
        this.context.getScripts().clear();
    }
}

