/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.collect.ImmutableSet;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.JavaVisibilities;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;

public final class DescriptorResolverUtils {
    private static final ImmutableSet<String> OBJECT_METHODS = ImmutableSet.of("hashCode()", "equals(java.lang.Object)", "toString()");

    private DescriptorResolverUtils() {
    }

    public static boolean isCompiledKotlinPackageClass(@NotNull PsiClass psiClass) {
        String qualifiedName;
        if (psiClass instanceof ClsClassImpl && (qualifiedName = psiClass.getQualifiedName()) != null && PackageClassUtils.isPackageClassFqName(new FqName(qualifiedName))) {
            return DescriptorResolverUtils.hasAnnotation(psiClass, JvmAnnotationNames.KOTLIN_PACKAGE.getFqName());
        }
        return false;
    }

    public static boolean isCompiledKotlinClass(@NotNull PsiClass psiClass) {
        if (psiClass instanceof ClsClassImpl) {
            return DescriptorResolverUtils.hasAnnotation(psiClass, JvmAnnotationNames.KOTLIN_CLASS.getFqName());
        }
        return false;
    }

    public static boolean hasAnnotation(@NotNull PsiClass psiClass, @NotNull FqName annotationFqName) {
        PsiModifierList list = psiClass.getModifierList();
        if (list != null) {
            return list.findAnnotation(annotationFqName.asString()) != null;
        }
        return false;
    }

    public static boolean isCompiledKotlinClassOrPackageClass(@NotNull PsiClass psiClass) {
        return DescriptorResolverUtils.isCompiledKotlinClass(psiClass) || DescriptorResolverUtils.isCompiledKotlinPackageClass(psiClass);
    }

    @NotNull
    public static Collection<JetType> getSupertypes(@NotNull ClassOrNamespaceDescriptor classOrNamespaceDescriptor) {
        if (classOrNamespaceDescriptor instanceof ClassDescriptor) {
            return ((ClassDescriptor)classOrNamespaceDescriptor).getTypeConstructor().getSupertypes();
        }
        return Collections.emptyList();
    }

    public static Visibility resolveVisibility(@NotNull PsiModifierListOwner modifierListOwner) {
        if (modifierListOwner.hasModifierProperty("public")) {
            return Visibilities.PUBLIC;
        }
        if (modifierListOwner.hasModifierProperty("private")) {
            return Visibilities.PRIVATE;
        }
        if (modifierListOwner.hasModifierProperty("protected")) {
            if (modifierListOwner.hasModifierProperty("static")) {
                return JavaVisibilities.PROTECTED_STATIC_VISIBILITY;
            }
            return JavaVisibilities.PROTECTED_AND_PACKAGE;
        }
        return JavaVisibilities.PACKAGE_VISIBILITY;
    }

    @Nullable
    public static ValueParameterDescriptor getValueParameterDescriptorForAnnotationParameter(Name argumentName, ClassDescriptor classDescriptor) {
        Collection<ConstructorDescriptor> constructors = classDescriptor.getConstructors();
        assert (constructors.size() == 1) : "Annotation class descriptor must have only one constructor";
        List<ValueParameterDescriptor> valueParameters = constructors.iterator().next().getValueParameters();
        for (ValueParameterDescriptor parameter : valueParameters) {
            Name parameterName = parameter.getName();
            if (!parameterName.equals(argumentName)) continue;
            return parameter;
        }
        return null;
    }

    public static boolean shouldBeInEnumClassObject(@NotNull PsiMember member) {
        PsiClass psiClass = member.getContainingClass();
        if (psiClass == null || !psiClass.isEnum()) {
            return false;
        }
        if (member instanceof PsiEnumConstant) {
            return true;
        }
        if (!(member instanceof PsiMethod)) {
            return false;
        }
        String signature = PsiFormatUtil.formatMethod((PsiMethod)member, PsiSubstitutor.EMPTY, 257, 8194);
        return "values()".equals(signature) || "valueOf(java.lang.String)".equals(signature);
    }

    public static boolean isCorrectOwnerForEnumMember(@NotNull ClassOrNamespaceDescriptor ownerDescriptor, @NotNull PsiMember member) {
        return DescriptorUtils.isEnumClassObject(ownerDescriptor) == DescriptorResolverUtils.shouldBeInEnumClassObject(member);
    }

    public static boolean isObjectMethodInInterface(@NotNull PsiMember member) {
        if (!(member instanceof PsiMethod)) {
            return false;
        }
        PsiClass containingClass = member.getContainingClass();
        assert (containingClass != null) : "containing class is null for " + member;
        if (!containingClass.isInterface()) {
            return false;
        }
        return DescriptorResolverUtils.isObjectMethod((PsiMethod)member);
    }

    public static boolean isObjectMethod(@NotNull PsiMethod method) {
        String formattedMethod = PsiFormatUtil.formatMethod(method, PsiSubstitutor.EMPTY, 257, 8194);
        return OBJECT_METHODS.contains(formattedMethod);
    }
}

