/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class JavaTypeTransformer {
    private static final Logger LOG = Logger.getInstance(JavaTypeTransformer.class);
    private JavaDescriptorResolver resolver;

    public void setResolver(JavaDescriptorResolver resolver) {
        this.resolver = resolver;
    }

    @NotNull
    private TypeProjection transformToTypeProjection(@NotNull PsiType javaType, final @NotNull TypeParameterDescriptor typeParameterDescriptor, final @NotNull TypeVariableResolver typeVariableByPsiResolver, final @NotNull TypeUsage howThisTypeIsUsed) {
        TypeProjection result = javaType.accept(new PsiTypeVisitor<TypeProjection>(){

            @Override
            public TypeProjection visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeProjection visitWildcardType(PsiWildcardType wildcardType) {
                if (!wildcardType.isBounded()) {
                    return SubstitutionUtils.makeStarProjection(typeParameterDescriptor);
                }
                Variance variance = wildcardType.isExtends() ? Variance.OUT_VARIANCE : Variance.IN_VARIANCE;
                PsiType bound = wildcardType.getBound();
                assert (bound != null);
                return new TypeProjection(variance, JavaTypeTransformer.this.transformToType(bound, TypeUsage.UPPER_BOUND, typeVariableByPsiResolver));
            }

            @Override
            public TypeProjection visitType(PsiType type) {
                return new TypeProjection(JavaTypeTransformer.this.transformToType(type, howThisTypeIsUsed, typeVariableByPsiResolver));
            }
        });
        return result;
    }

    @NotNull
    public JetType transformToType(@NotNull PsiType javaType, @NotNull TypeVariableResolver typeVariableResolver) {
        return this.transformToType(javaType, TypeUsage.MEMBER_SIGNATURE_INVARIANT, typeVariableResolver);
    }

    @NotNull
    public JetType transformToType(@NotNull PsiType javaType, final @NotNull TypeUsage howThisTypeIsUsed, final @NotNull TypeVariableResolver typeVariableResolver) {
        JetType result = javaType.accept(new PsiTypeVisitor<JetType>(){

            @Override
            public JetType visitClassType(PsiClassType classType) {
                PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
                PsiClass psiClass = classResolveResult.getElement();
                if (psiClass == null) {
                    return ErrorUtils.createErrorType("Unresolved java class: " + classType.getPresentableText());
                }
                if (psiClass instanceof PsiTypeParameter) {
                    boolean nullable;
                    PsiMethod psiMethod;
                    PsiTypeParameter typeParameter = (PsiTypeParameter)psiClass;
                    PsiTypeParameterListOwner typeParameterListOwner = typeParameter.getOwner();
                    if (typeParameterListOwner instanceof PsiMethod && (psiMethod = (PsiMethod)typeParameterListOwner).isConstructor()) {
                        HashSet<JetType> supertypesJet = Sets.newHashSet();
                        for (PsiClassType supertype : typeParameter.getExtendsListTypes()) {
                            supertypesJet.add(JavaTypeTransformer.this.transformToType(supertype, TypeUsage.UPPER_BOUND, typeVariableResolver));
                        }
                        return TypeUtils.intersect(JetTypeChecker.INSTANCE, supertypesJet);
                    }
                    TypeParameterDescriptor typeParameterDescriptor = typeVariableResolver.getTypeVariable(typeParameter.getName());
                    boolean bl = nullable = !EnumSet.of(TypeUsage.TYPE_ARGUMENT, TypeUsage.UPPER_BOUND, TypeUsage.SUPERTYPE_ARGUMENT).contains((Object)howThisTypeIsUsed);
                    if (nullable) {
                        return TypeUtils.makeNullable(typeParameterDescriptor.getDefaultType());
                    }
                    return typeParameterDescriptor.getDefaultType();
                }
                boolean nullable = !EnumSet.of(TypeUsage.TYPE_ARGUMENT, TypeUsage.SUPERTYPE_ARGUMENT, TypeUsage.SUPERTYPE).contains((Object)howThisTypeIsUsed);
                ClassDescriptor classData = JavaToKotlinClassMap.getInstance().mapKotlinClass(new FqName(psiClass.getQualifiedName()), howThisTypeIsUsed);
                if (classData == null) {
                    classData = JavaTypeTransformer.this.resolver.resolveClass(new FqName(psiClass.getQualifiedName()), DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
                }
                if (classData == null) {
                    return ErrorUtils.createErrorType("Unresolved java class: " + classType.getPresentableText());
                }
                ArrayList<TypeProjection> arguments = Lists.newArrayList();
                List<TypeParameterDescriptor> parameters = classData.getTypeConstructor().getParameters();
                if (JavaTypeTransformer.isRaw(classType, !parameters.isEmpty())) {
                    for (TypeParameterDescriptor parameter : parameters) {
                        Variance projectionKind = parameter.getVariance() == Variance.OUT_VARIANCE || howThisTypeIsUsed == TypeUsage.SUPERTYPE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
                        arguments.add(new TypeProjection(projectionKind, KotlinBuiltIns.getInstance().getNullableAnyType()));
                    }
                } else {
                    PsiType[] psiArguments = classType.getParameters();
                    if (parameters.size() != psiArguments.length) {
                        LOG.warn("parameters = " + parameters.size() + ", actual arguments = " + psiArguments.length + " in " + classType.getPresentableText() + "\n PsiClass: \n" + psiClass.getText());
                        for (TypeParameterDescriptor parameter : parameters) {
                            arguments.add(new TypeProjection(ErrorUtils.createErrorType(parameter.getName().asString())));
                        }
                    } else {
                        for (int i = 0; i < parameters.size(); ++i) {
                            TypeUsage howTheProjectionIsUsed;
                            PsiType psiArgument = psiArguments[i];
                            TypeParameterDescriptor typeParameterDescriptor = parameters.get(i);
                            TypeProjection typeProjection = JavaTypeTransformer.this.transformToTypeProjection(psiArgument, typeParameterDescriptor, typeVariableResolver, howTheProjectionIsUsed = howThisTypeIsUsed == TypeUsage.SUPERTYPE ? TypeUsage.SUPERTYPE_ARGUMENT : TypeUsage.TYPE_ARGUMENT);
                            if (typeProjection.getProjectionKind() == typeParameterDescriptor.getVariance()) {
                                arguments.add(new TypeProjection(Variance.INVARIANT, typeProjection.getType()));
                                continue;
                            }
                            arguments.add(typeProjection);
                        }
                    }
                }
                return new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), classData.getTypeConstructor(), nullable, arguments, classData.getMemberScope(arguments));
            }

            @Override
            public JetType visitPrimitiveType(PsiPrimitiveType primitiveType) {
                String canonicalText = primitiveType.getCanonicalText();
                JetType type = JavaToKotlinClassMap.getInstance().mapPrimitiveKotlinClass(canonicalText);
                assert (type != null) : canonicalText;
                return type;
            }

            @Override
            public JetType visitArrayType(PsiArrayType arrayType) {
                JetType jetType;
                PsiType componentType = arrayType.getComponentType();
                if (componentType instanceof PsiPrimitiveType && (jetType = JavaToKotlinClassMap.getInstance().mapPrimitiveKotlinClass("[" + componentType.getCanonicalText())) != null) {
                    return TypeUtils.makeNullable(jetType);
                }
                boolean vararg = arrayType instanceof PsiEllipsisType;
                Variance projectionKind = this.arrayElementTypeProjectionKind(vararg);
                TypeUsage howArgumentTypeIsUsed = vararg ? TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT : TypeUsage.TYPE_ARGUMENT;
                JetType type = JavaTypeTransformer.this.transformToType(componentType, howArgumentTypeIsUsed, typeVariableResolver);
                return TypeUtils.makeNullable(KotlinBuiltIns.getInstance().getArrayType(projectionKind, type));
            }

            private Variance arrayElementTypeProjectionKind(boolean vararg) {
                Variance variance = howThisTypeIsUsed == TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT && !vararg ? Variance.OUT_VARIANCE : Variance.INVARIANT;
                return variance;
            }

            @Override
            public JetType visitType(PsiType type) {
                throw new UnsupportedOperationException("Unsupported type: " + type.getPresentableText());
            }
        });
        return result;
    }

    private static boolean isRaw(@NotNull PsiClassType classType, boolean argumentsExpected) {
        return classType.isRaw() || argumentsExpected && classType.getParameterCount() == 0;
    }

    public static TypeUsage adjustTypeUsageWithMutabilityAnnotations(PsiModifierListOwner owner, TypeUsage originalTypeUsage) {
        EnumSet<TypeUsage> signatureTypeUsages = EnumSet.of(TypeUsage.MEMBER_SIGNATURE_COVARIANT, TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT, TypeUsage.MEMBER_SIGNATURE_INVARIANT);
        if (!signatureTypeUsages.contains((Object)originalTypeUsage)) {
            return originalTypeUsage;
        }
        if (JavaAnnotationResolver.findAnnotationWithExternal(owner, JvmAnnotationNames.JETBRAINS_MUTABLE_ANNOTATION.getFqName().asString()) != null) {
            return TypeUsage.MEMBER_SIGNATURE_COVARIANT;
        }
        if (JavaAnnotationResolver.findAnnotationWithExternal(owner, JvmAnnotationNames.JETBRAINS_READONLY_ANNOTATION.getFqName().asString()) != null) {
            return TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT;
        }
        return originalTypeUsage;
    }
}

