/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;

public class TypeVariableResolver {
    @NotNull
    protected final List<TypeParameterDescriptor> typeParameters;
    @NotNull
    protected final DeclarationDescriptor owner;
    @NotNull
    protected final String context;

    public TypeVariableResolver(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull DeclarationDescriptor owner, @NotNull String context) {
        this.typeParameters = typeParameters;
        this.owner = owner;
        this.context = context;
        assert (ContainerUtil.and(typeParameters, new Condition<TypeParameterDescriptor>(){

            @Override
            public boolean value(TypeParameterDescriptor descriptor) {
                return descriptor.getContainingDeclaration() == TypeVariableResolver.this.owner;
            }
        })) : "Type parameters should be parameters of owner: " + owner + "; " + typeParameters;
    }

    @NotNull
    public TypeParameterDescriptor getTypeVariable(@NotNull String name) {
        return this.getTypeVariable(name, this.typeParameters, this.owner);
    }

    @NotNull
    private TypeParameterDescriptor getTypeVariable(@NotNull String name, @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull DeclarationDescriptor owner) {
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            if (!typeParameter.getName().asString().equals(name)) continue;
            return typeParameter;
        }
        DeclarationDescriptor container = owner.getContainingDeclaration();
        if (container instanceof ClassDescriptor) {
            return this.getTypeVariable(name, ((ClassDescriptor)container).getTypeConstructor().getParameters(), container);
        }
        throw new IllegalStateException("Type parameter not found by name '" + name + "' in " + this.context);
    }
}

