/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ComparatorUtil;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.AlternativeSignatureMismatchException;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.ElementAlternativeSignatureData;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiFieldWrapper;
import org.jetbrains.jet.lang.types.JetType;

public class AlternativeFieldSignatureData
extends ElementAlternativeSignatureData {
    private JetType altReturnType;

    public AlternativeFieldSignatureData(@NotNull PsiFieldWrapper field, @NotNull JetType originalReturnType, boolean isVar) {
        String signature = field.getSignatureAnnotation().signature();
        if (signature.isEmpty()) {
            this.setAnnotated(false);
            return;
        }
        this.setAnnotated(true);
        Project project = field.getPsiMember().getProject();
        JetProperty altPropertyDeclaration = JetPsiFactory.createProperty(project, signature);
        try {
            AlternativeFieldSignatureData.checkForSyntaxErrors(altPropertyDeclaration);
            AlternativeFieldSignatureData.checkFieldAnnotation(altPropertyDeclaration, field, isVar);
            this.altReturnType = AlternativeFieldSignatureData.computeReturnType(originalReturnType, altPropertyDeclaration.getTypeRef(), new HashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl>());
        }
        catch (AlternativeSignatureMismatchException e) {
            this.setError(e.getMessage());
        }
    }

    @NotNull
    public JetType getReturnType() {
        this.checkForErrors();
        return this.altReturnType;
    }

    private static void checkFieldAnnotation(JetProperty altProperty, PsiFieldWrapper fieldWrapper, boolean isVar) {
        if (!ComparatorUtil.equalsNullable(fieldWrapper.getName(), altProperty.getName())) {
            throw new AlternativeSignatureMismatchException("Field name mismatch, original: %s, alternative: %s", fieldWrapper.getName(), altProperty.getName());
        }
        if (altProperty.getTypeRef() == null) {
            throw new AlternativeSignatureMismatchException("Field annotation for shouldn't have type reference");
        }
        if (altProperty.getGetter() != null || altProperty.getSetter() != null) {
            throw new AlternativeSignatureMismatchException("Field annotation for shouldn't have getters and setters");
        }
        if (altProperty.isVar() != isVar) {
            throw new AlternativeSignatureMismatchException("Wrong mutability in annotation for field");
        }
        if (altProperty.getInitializer() != null) {
            throw new AlternativeSignatureMismatchException("Default value is not expected in annotation for field");
        }
    }
}

