/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.SignaturesPropagationData;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.renderer.DescriptorRenderer;

class PropagationHeuristics {
    static void checkArrayInReturnType(@NotNull SignaturesPropagationData data, @NotNull JetType type, @NotNull List<SignaturesPropagationData.TypeAndVariance> typesFromSuper) {
        List<SignaturesPropagationData.TypeAndVariance> arrayTypesFromSuper = ContainerUtil.filter(typesFromSuper, new Condition<SignaturesPropagationData.TypeAndVariance>(){

            @Override
            public boolean value(SignaturesPropagationData.TypeAndVariance typeAndVariance) {
                return typeAndVariance.type.getConstructor().getDeclarationDescriptor() == KotlinBuiltIns.getInstance().getArray();
            }
        });
        if (KotlinBuiltIns.getInstance().getArray() == type.getConstructor().getDeclarationDescriptor() && !arrayTypesFromSuper.isEmpty()) {
            assert (type.getArguments().size() == 1);
            if (type.getArguments().get(0).getProjectionKind() == Variance.INVARIANT) {
                for (SignaturesPropagationData.TypeAndVariance typeAndVariance : arrayTypesFromSuper) {
                    JetType arrayTypeFromSuper = typeAndVariance.type;
                    assert (arrayTypeFromSuper.getArguments().size() == 1);
                    JetType elementTypeInSuper = arrayTypeFromSuper.getArguments().get(0).getType();
                    JetType elementType = type.getArguments().get(0).getType();
                    if (!JetTypeChecker.INSTANCE.isSubtypeOf(elementType, elementTypeInSuper) || JetTypeChecker.INSTANCE.equalTypes(elementType, elementTypeInSuper)) continue;
                    JetTypeImpl betterTypeInSuper = new JetTypeImpl(arrayTypeFromSuper.getAnnotations(), arrayTypeFromSuper.getConstructor(), arrayTypeFromSuper.isNullable(), Arrays.asList(new TypeProjection(Variance.OUT_VARIANCE, elementTypeInSuper)), JetScope.EMPTY);
                    data.reportError("Return type is not a subtype of overridden method. To fix it, add annotation with Kotlin signature to super method with type " + DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(arrayTypeFromSuper) + " replaced with " + DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(betterTypeInSuper) + " in return type");
                }
            }
        }
    }

    @Nullable
    static ClassifierDescriptor tryToFixOverridingTWithRawType(@NotNull SignaturesPropagationData data, @NotNull List<SignaturesPropagationData.TypeAndVariance> typesFromSuper) {
        ArrayList<TypeParameterDescriptor> typeParameterClassifiersFromSuper = Lists.newArrayList();
        for (SignaturesPropagationData.TypeAndVariance typeFromSuper : typesFromSuper) {
            ClassifierDescriptor classifierFromSuper = typeFromSuper.type.getConstructor().getDeclarationDescriptor();
            if (!(classifierFromSuper instanceof TypeParameterDescriptor)) continue;
            typeParameterClassifiersFromSuper.add((TypeParameterDescriptor)classifierFromSuper);
        }
        if (!typeParameterClassifiersFromSuper.isEmpty() && typeParameterClassifiersFromSuper.size() == typesFromSuper.size()) {
            for (TypeParameterDescriptor typeParameter : typeParameterClassifiersFromSuper) {
                if (typeParameter.getContainingDeclaration() != data.containingClass) continue;
                return typeParameter;
            }
        }
        return null;
    }

    @NotNull
    static List<PsiMethod> getSuperMethods(@NotNull PsiMethod method) {
        return new SuperMethodCollector(method).collect();
    }

    private PropagationHeuristics() {
    }

    private static class SuperMethodCollector {
        private final PsiMethod initialMethod;
        private final String initialMethodName;
        private final List<PsiType> initialParametersErasure;
        private final List<PsiClass> visitedSuperclasses = Lists.newArrayList();
        private final List<PsiMethod> collectedMethods = Lists.newArrayList();

        private SuperMethodCollector(@NotNull PsiMethod initialMethod) {
            this.initialMethod = initialMethod;
            this.initialMethodName = initialMethod.getName();
            PsiParameterList parameterList = initialMethod.getParameterList();
            this.initialParametersErasure = Lists.newArrayListWithExpectedSize(parameterList.getParametersCount());
            for (PsiParameter parameter : parameterList.getParameters()) {
                this.initialParametersErasure.add(SuperMethodCollector.erasureNoEllipsis(parameter.getType()));
            }
        }

        public List<PsiMethod> collect() {
            if (!SuperMethodCollector.canHaveSuperMethod(this.initialMethod)) {
                return Collections.emptyList();
            }
            PsiClass containingClass = this.initialMethod.getContainingClass();
            assert (containingClass != null) : " containing class is null for " + this.initialMethod;
            for (PsiClassType superType : containingClass.getSuperTypes()) {
                this.collectFromSupertype(superType);
            }
            return this.collectedMethods;
        }

        private void collectFromSupertype(PsiClassType type) {
            PsiClass klass = type.resolve();
            if (klass == null) {
                return;
            }
            if (!this.visitedSuperclasses.add(klass)) {
                return;
            }
            PsiSubstitutor supertypeSubstitutor = SuperMethodCollector.getErasedSubstitutor(type);
            for (PsiMethod methodFromSuper : klass.getMethods()) {
                if (!this.isSubMethodOf(methodFromSuper, supertypeSubstitutor)) continue;
                this.collectedMethods.add(methodFromSuper);
                return;
            }
            for (PsiType superType : type.getSuperTypes()) {
                assert (superType instanceof PsiClassType) : "supertype is not a PsiClassType for " + type + ": " + superType;
                this.collectFromSupertype((PsiClassType)superType);
            }
        }

        private boolean isSubMethodOf(@NotNull PsiMethod methodFromSuper, @NotNull PsiSubstitutor supertypeSubstitutor) {
            if (!methodFromSuper.getName().equals(this.initialMethodName)) {
                return false;
            }
            PsiParameterList fromSuperParameterList = methodFromSuper.getParameterList();
            if (fromSuperParameterList.getParametersCount() != this.initialParametersErasure.size()) {
                return false;
            }
            for (int i = 0; i < this.initialParametersErasure.size(); ++i) {
                PsiType typeFromSuper;
                PsiType typeFromSuperErased;
                PsiType originalType = this.initialParametersErasure.get(i);
                if (Comparing.equal(originalType, typeFromSuperErased = SuperMethodCollector.erasureNoEllipsis(supertypeSubstitutor.substitute(typeFromSuper = fromSuperParameterList.getParameters()[i].getType())))) continue;
                return false;
            }
            return true;
        }

        private static PsiType erasureNoEllipsis(PsiType type) {
            if (type instanceof PsiEllipsisType) {
                return SuperMethodCollector.erasureNoEllipsis(((PsiEllipsisType)type).toArrayType());
            }
            return TypeConversionUtil.erasure(type);
        }

        private static PsiSubstitutor getErasedSubstitutor(PsiClassType type) {
            Map<PsiTypeParameter, PsiType> unerasedMap = type.resolveGenerics().getSubstitutor().getSubstitutionMap();
            HashMap<PsiTypeParameter, PsiType> erasedMap = Maps.newHashMapWithExpectedSize(unerasedMap.size());
            for (Map.Entry<PsiTypeParameter, PsiType> entry : unerasedMap.entrySet()) {
                erasedMap.put(entry.getKey(), TypeConversionUtil.erasure(entry.getValue()));
            }
            return PsiSubstitutorImpl.createSubstitutor(erasedMap);
        }

        private static boolean canHaveSuperMethod(PsiMethod method) {
            if (method.isConstructor()) {
                return false;
            }
            if (method.hasModifierProperty("static")) {
                return false;
            }
            if (method.hasModifierProperty("private")) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            return containingClass != null && !"java.lang.Object".equals(containingClass.getQualifiedName());
        }
    }
}

