/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassData;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.DescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBufUtil;
import org.jetbrains.jet.descriptors.serialization.PackageData;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.AbiVersionUtil;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.resolver.AnnotationDescriptorDeserializer;
import org.jetbrains.jet.lang.resolve.java.resolver.DeserializedResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaNamespaceResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.KotlinClassFileHeader;
import org.jetbrains.jet.lang.resolve.lazy.storage.LockBasedStorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public final class DeserializedDescriptorResolver {
    private AnnotationDescriptorDeserializer annotationDeserializer;
    private final LockBasedStorageManager storageManager = new LockBasedStorageManager();
    private JavaNamespaceResolver javaNamespaceResolver;
    private JavaClassResolver javaClassResolver;
    @NotNull
    private final DescriptorFinder javaDescriptorFinder = new DescriptorFinder(){

        @Override
        @Nullable
        public ClassDescriptor findClass(@NotNull ClassId classId) {
            return DeserializedDescriptorResolver.this.javaClassResolver.resolveClass(DeserializedResolverUtils.kotlinFqNameToJavaFqName(classId.asSingleFqName()), DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        }

        @Override
        @Nullable
        public NamespaceDescriptor findPackage(@NotNull FqName name) {
            return DeserializedDescriptorResolver.this.javaNamespaceResolver.resolveNamespace(name, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        }

        @Override
        @NotNull
        public Collection<Name> getClassNames(@NotNull FqName packageName) {
            return DeserializedDescriptorResolver.this.javaNamespaceResolver.getClassNamesInPackage(packageName);
        }
    };

    public void setAnnotationDeserializer(AnnotationDescriptorDeserializer annotationDeserializer) {
        this.annotationDeserializer = annotationDeserializer;
    }

    public void setJavaNamespaceResolver(JavaNamespaceResolver javaNamespaceResolver) {
        this.javaNamespaceResolver = javaNamespaceResolver;
    }

    public void setJavaClassResolver(JavaClassResolver javaClassResolver) {
        this.javaClassResolver = javaClassResolver;
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull ClassId id, @NotNull VirtualFile file, @NotNull ErrorReporter reporter) {
        ClassData classData = DeserializedDescriptorResolver.readClassDataFromClassFile(file, reporter);
        if (classData == null) {
            return null;
        }
        return this.createDeserializedClass(classData, id);
    }

    @Nullable
    public JetScope createKotlinPackageScope(@NotNull NamespaceDescriptor descriptor, @NotNull VirtualFile file, @NotNull ErrorReporter reporter) {
        PackageData packageData = DeserializedDescriptorResolver.readPackageDataFromClassFile(file, reporter);
        if (packageData == null) {
            return null;
        }
        return new DeserializedPackageMemberScope(this.storageManager, descriptor, this.annotationDeserializer, this.javaDescriptorFinder, packageData);
    }

    @Nullable
    private ClassDescriptor createDeserializedClass(@NotNull ClassData classData, @NotNull ClassId classId) {
        NamespaceDescriptor owner;
        ClassOrNamespaceDescriptor classOrNamespaceDescriptor = owner = classId.isTopLevelClass() ? this.javaNamespaceResolver.resolveNamespace(classId.getPackageFqName(), DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES) : this.javaClassResolver.resolveClass(DeserializedResolverUtils.kotlinFqNameToJavaFqName(classId.getOuterClassId().asSingleFqName()), DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        assert (owner != null) : "No owner found for " + classId;
        return new DeserializedClassDescriptor(classId, this.storageManager, owner, classData.getNameResolver(), this.annotationDeserializer, this.javaDescriptorFinder, classData.getClassProto(), null);
    }

    @Nullable
    private static ClassData readClassDataFromClassFile(@NotNull VirtualFile file, @NotNull ErrorReporter reporter) {
        String[] data = DeserializedDescriptorResolver.readData(file, reporter);
        return data == null ? null : JavaProtoBufUtil.readClassDataFrom(data);
    }

    @Nullable
    private static PackageData readPackageDataFromClassFile(@NotNull VirtualFile file, @NotNull ErrorReporter reporter) {
        String[] data = DeserializedDescriptorResolver.readData(file, reporter);
        return data == null ? null : JavaProtoBufUtil.readPackageDataFrom(data);
    }

    @Nullable
    private static String[] readData(@NotNull VirtualFile virtualFile, @NotNull ErrorReporter reporter) {
        KotlinClassFileHeader header = KotlinClassFileHeader.readKotlinHeaderFromClassFile(virtualFile);
        int version = header.getVersion();
        if (!AbiVersionUtil.isAbiVersionCompatible(version) && header.getType() != KotlinClassFileHeader.HeaderType.NONE) {
            reporter.reportIncompatibleAbiVersion(version);
            return null;
        }
        return header.getAnnotationData();
    }
}

