/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;

public class DeserializedResolverUtils {
    private DeserializedResolverUtils() {
    }

    @NotNull
    public static FqName kotlinFqNameToJavaFqName(@NotNull FqNameUnsafe kotlinFqName) {
        ArrayList<String> correctedSegments = new ArrayList<String>();
        for (Name segment : kotlinFqName.pathSegments()) {
            if (segment.asString().startsWith("<class-object-for")) {
                correctedSegments.add("object");
                continue;
            }
            assert (!segment.isSpecial());
            correctedSegments.add(segment.asString());
        }
        return FqName.fromSegments(correctedSegments);
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull ClassId id, @NotNull VirtualFile outerClassFile) {
        String fileExtension = outerClassFile.getExtension();
        if (!"class".equals(fileExtension)) {
            return null;
        }
        FqNameUnsafe relativeClassName = id.getRelativeClassName();
        assert (relativeClassName.isSafe()) : "Relative class name " + relativeClassName.asString() + " should be safe at this point";
        String classNameWithBucks = relativeClassName.asString().replace(".", "$") + ".class";
        VirtualFile virtualFile = outerClassFile.getParent().findChild(classNameWithBucks);
        if (virtualFile == null) {
            throw new IllegalStateException("No virtual file for " + id.asSingleFqName().asString());
        }
        return virtualFile;
    }

    @NotNull
    public static FqNameUnsafe naiveKotlinFqName(@NotNull ClassDescriptor descriptor) {
        DeclarationDescriptor containing = descriptor.getContainingDeclaration();
        if (containing instanceof ClassDescriptor) {
            return DeserializedResolverUtils.naiveKotlinFqName((ClassDescriptor)containing).child(descriptor.getName());
        }
        if (containing instanceof NamespaceDescriptor) {
            return DescriptorUtils.getFQName(containing).child(descriptor.getName());
        }
        throw new IllegalArgumentException("Class doesn't have a FQ name: " + descriptor);
    }
}

