/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaCompileTimeConstResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.PostponedTasks;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class JavaAnnotationResolver {
    private JavaClassResolver classResolver;
    private JavaCompileTimeConstResolver compileTimeConstResolver;

    public void setClassResolver(JavaClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    public void setCompileTimeConstResolver(JavaCompileTimeConstResolver compileTimeConstResolver) {
        this.compileTimeConstResolver = compileTimeConstResolver;
    }

    @NotNull
    public List<AnnotationDescriptor> resolveAnnotations(@NotNull PsiModifierListOwner owner, @NotNull PostponedTasks tasks) {
        PsiAnnotation[] psiAnnotations = JavaAnnotationResolver.getAllAnnotations(owner);
        ArrayList<AnnotationDescriptor> r = Lists.newArrayListWithCapacity(psiAnnotations.length);
        for (PsiAnnotation psiAnnotation : psiAnnotations) {
            AnnotationDescriptor annotation = this.resolveAnnotation(psiAnnotation, tasks);
            if (annotation == null) continue;
            r.add(annotation);
        }
        return r;
    }

    @NotNull
    public List<AnnotationDescriptor> resolveAnnotations(@NotNull PsiModifierListOwner owner) {
        PostponedTasks postponedTasks = new PostponedTasks();
        List<AnnotationDescriptor> annotations = this.resolveAnnotations(owner, postponedTasks);
        postponedTasks.performTasks();
        return annotations;
    }

    @Nullable
    public AnnotationDescriptor resolveAnnotation(PsiAnnotation psiAnnotation, @NotNull PostponedTasks postponedTasks) {
        final AnnotationDescriptor annotation = new AnnotationDescriptor();
        String qname = psiAnnotation.getQualifiedName();
        if (qname == null) {
            return null;
        }
        if (qname.startsWith("jet.runtime.typeinfo.") || qname.equals(JvmAnnotationNames.JETBRAINS_NOT_NULL_ANNOTATION.getFqName().asString()) || qname.equals(JvmAnnotationNames.KOTLIN_CLASS.getFqName().asString()) || qname.equals(JvmAnnotationNames.KOTLIN_PACKAGE.getFqName().asString())) {
            return null;
        }
        FqName annotationFqName = new FqName(qname);
        AnnotationDescriptor mappedClassDescriptor = JavaToKotlinClassMap.getInstance().mapToAnnotationClass(annotationFqName);
        if (mappedClassDescriptor != null) {
            return mappedClassDescriptor;
        }
        final ClassDescriptor annotationClass = this.classResolver.resolveClass(annotationFqName, DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES, postponedTasks);
        if (annotationClass == null) {
            return null;
        }
        postponedTasks.addTask(new Runnable(){

            @Override
            public void run() {
                annotation.setAnnotationType(annotationClass.getDefaultType());
            }
        });
        PsiAnnotationParameterList parameterList = psiAnnotation.getParameterList();
        for (PsiNameValuePair psiNameValuePair : parameterList.getAttributes()) {
            ValueParameterDescriptor valueParameterDescriptor;
            PsiAnnotationMemberValue value = psiNameValuePair.getValue();
            String name = psiNameValuePair.getName();
            if (name == null) {
                name = "value";
            }
            Name identifier = Name.identifier(name);
            if (value == null) {
                return null;
            }
            CompileTimeConstant<?> compileTimeConst = this.compileTimeConstResolver.getCompileTimeConstFromExpression(annotationFqName, identifier, value, postponedTasks);
            if (compileTimeConst == null || (valueParameterDescriptor = DescriptorResolverUtils.getValueParameterDescriptorForAnnotationParameter(identifier, annotationClass)) == null) continue;
            annotation.setValueArgument(valueParameterDescriptor, compileTimeConst);
        }
        return annotation;
    }

    @NotNull
    private static PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner owner) {
        PsiAnnotation[] externalAnnotations;
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        PsiModifierList list = owner.getModifierList();
        if (list != null) {
            result.addAll(Arrays.asList(list.getAnnotations()));
        }
        if ((externalAnnotations = ExternalAnnotationsManager.getInstance(owner.getProject()).findExternalAnnotations(owner)) != null) {
            result.addAll(Arrays.asList(externalAnnotations));
        }
        return result.toArray(new PsiAnnotation[result.size()]);
    }

    @Nullable
    public static PsiAnnotation findOwnAnnotation(@NotNull PsiModifierListOwner owner, @NotNull String fqName) {
        PsiAnnotation found;
        PsiModifierList list = owner.getModifierList();
        if (list != null && (found = list.findAnnotation(fqName)) != null) {
            return found;
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation findAnnotationWithExternal(@NotNull PsiModifierListOwner owner, @NotNull String fqName) {
        PsiAnnotation annotation = JavaAnnotationResolver.findOwnAnnotation(owner, fqName);
        if (annotation != null) {
            return annotation;
        }
        return ExternalAnnotationsManager.getInstance(owner.getProject()).findExternalAnnotation(owner, fqName);
    }
}

