/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.AbiVersionUtil;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.descriptor.ClassDescriptorFromJvmBytecode;
import org.jetbrains.jet.lang.resolve.java.resolver.DeserializedDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaFunctionResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaNamespaceResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaSupertypeResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.PostponedTasks;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassNonStaticMembersScope;
import org.jetbrains.jet.lang.resolve.java.vfilefinder.VirtualFileFinder;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameBase;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public final class JavaClassResolver {
    @NotNull
    private final Map<FqNameBase, ClassDescriptor> classDescriptorCache = new THashMap<FqNameBase, ClassDescriptor>(new TObjectHashingStrategy<FqNameBase>(){

        @Override
        public int computeHashCode(FqNameBase o) {
            if (o instanceof FqName) {
                return ((FqName)o).toUnsafe().hashCode();
            }
            assert (o instanceof FqNameUnsafe);
            return o.hashCode();
        }

        @Override
        public boolean equals(FqNameBase n1, FqNameBase n2) {
            return n1.equalsTo(n2.toString()) && n2.equalsTo(n1.toString());
        }
    });
    @NotNull
    private final Set<FqNameBase> unresolvedCache = Sets.newHashSet();
    private BindingTrace trace;
    private JavaSignatureResolver signatureResolver;
    private JavaDescriptorResolver javaDescriptorResolver;
    private JavaAnnotationResolver annotationResolver;
    private PsiClassFinder psiClassFinder;
    private JavaNamespaceResolver namespaceResolver;
    private JavaSupertypeResolver supertypesResolver;
    private JavaFunctionResolver functionResolver;
    private DeserializedDescriptorResolver kotlinDescriptorResolver;
    private VirtualFileFinder virtualFileFinder;

    public void setVirtualFileFinder(VirtualFileFinder virtualFileFinder) {
        this.virtualFileFinder = virtualFileFinder;
    }

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void setKotlinDescriptorResolver(DeserializedDescriptorResolver kotlinDescriptorResolver) {
        this.kotlinDescriptorResolver = kotlinDescriptorResolver;
    }

    public void setSignatureResolver(JavaSignatureResolver signatureResolver) {
        this.signatureResolver = signatureResolver;
    }

    public void setJavaDescriptorResolver(JavaDescriptorResolver javaDescriptorResolver) {
        this.javaDescriptorResolver = javaDescriptorResolver;
    }

    public void setAnnotationResolver(JavaAnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    public void setPsiClassFinder(PsiClassFinder psiClassFinder) {
        this.psiClassFinder = psiClassFinder;
    }

    public void setNamespaceResolver(JavaNamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public void setSupertypesResolver(JavaSupertypeResolver supertypesResolver) {
        this.supertypesResolver = supertypesResolver;
    }

    public void setFunctionResolver(JavaFunctionResolver functionResolver) {
        this.functionResolver = functionResolver;
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull FqName qualifiedName, @NotNull DescriptorSearchRule searchRule) {
        PostponedTasks postponedTasks = new PostponedTasks();
        ClassDescriptor classDescriptor = this.resolveClass(qualifiedName, searchRule, postponedTasks);
        postponedTasks.performTasks();
        return classDescriptor;
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull FqName qualifiedName, @NotNull DescriptorSearchRule searchRule, @NotNull PostponedTasks tasks) {
        if (JavaClassResolver.isTraitImplementation(qualifiedName)) {
            return null;
        }
        ClassDescriptor builtinClassDescriptor = JavaClassResolver.getKotlinBuiltinClassDescriptor(qualifiedName);
        if (builtinClassDescriptor != null) {
            return builtinClassDescriptor;
        }
        ClassDescriptor kotlinClassDescriptor = this.trace.get(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, qualifiedName);
        if (kotlinClassDescriptor != null) {
            return searchRule.processFoundInKotlin(kotlinClassDescriptor);
        }
        FqNameUnsafe fqName = JavaClassResolver.javaClassToKotlinFqName(qualifiedName);
        ClassDescriptor cachedDescriptor = this.classDescriptorCache.get(fqName);
        if (cachedDescriptor != null) {
            return cachedDescriptor;
        }
        if (this.unresolvedCache.contains(fqName)) {
            return null;
        }
        return this.doResolveClass(qualifiedName, tasks);
    }

    @Nullable
    private static ClassDescriptor getKotlinBuiltinClassDescriptor(@NotNull FqName qualifiedName) {
        if (!qualifiedName.firstSegmentIs(KotlinBuiltIns.BUILT_INS_PACKAGE_NAME)) {
            return null;
        }
        List<Name> segments = qualifiedName.pathSegments();
        if (segments.size() < 2) {
            return null;
        }
        JetScope scope = KotlinBuiltIns.getInstance().getBuiltInsScope();
        int size = segments.size();
        for (int i = 1; i < size; ++i) {
            ClassifierDescriptor classifier = scope.getClassifier(segments.get(i));
            if (classifier == null) {
                return null;
            }
            assert (classifier instanceof ClassDescriptor) : "Unexpected classifier in built-ins: " + classifier;
            scope = ((ClassDescriptor)classifier).getUnsubstitutedInnerClassesScope();
        }
        return (ClassDescriptor)scope.getContainingDeclaration();
    }

    private ClassDescriptor doResolveClass(@NotNull FqName qualifiedName, @NotNull PostponedTasks tasks) {
        PsiClass psiClass;
        VirtualFile file = this.virtualFileFinder.find(qualifiedName);
        if (file != null) {
            ErrorReporter errorReporter;
            boolean isInnerClass = file.getName().contains("$");
            ClassOrNamespaceDescriptor containingDeclaration = this.resolveParentDescriptor(qualifiedName, isInnerClass);
            ClassDescriptor cachedDescriptor = this.classDescriptorCache.get(JavaClassResolver.javaClassToKotlinFqName(qualifiedName));
            if (cachedDescriptor != null) {
                return cachedDescriptor;
            }
            assert (!this.unresolvedCache.contains(qualifiedName)) : "We can resolve the class, so it can't be 'unresolved' during parent resolution";
            ClassId id = ClassId.fromFqNameAndContainingDeclaration(qualifiedName, containingDeclaration);
            ClassDescriptor deserializedDescriptor = this.kotlinDescriptorResolver.resolveClass(id, file, errorReporter = AbiVersionUtil.abiVersionErrorReporter(file, qualifiedName, this.trace));
            if (deserializedDescriptor != null) {
                this.cache(JavaClassResolver.javaClassToKotlinFqName(qualifiedName), deserializedDescriptor);
                return deserializedDescriptor;
            }
        }
        if ((psiClass = this.psiClassFinder.findPsiClass(qualifiedName, PsiClassFinder.RuntimeClassesHandleMode.REPORT_ERROR)) == null) {
            this.cacheNegativeValue(JavaClassResolver.javaClassToKotlinFqName(qualifiedName));
            return null;
        }
        ClassDescriptor alreadyResolved = this.trace.get(BindingContext.CLASS, psiClass);
        if (alreadyResolved != null) {
            return alreadyResolved;
        }
        ClassOrNamespaceDescriptor containingDeclaration = this.resolveParentDescriptor(qualifiedName, JavaClassResolver.isContainedInClass(psiClass));
        ClassDescriptor cachedDescriptor = this.classDescriptorCache.get(JavaClassResolver.javaClassToKotlinFqName(qualifiedName));
        if (cachedDescriptor != null) {
            return cachedDescriptor;
        }
        assert (!this.unresolvedCache.contains(qualifiedName)) : "We can resolve the class, so it can't be 'unresolved' during parent resolution";
        this.checkFqNamesAreConsistent(psiClass, qualifiedName);
        JavaClassResolver.checkPsiClassIsNotJet(psiClass);
        return this.doCreateClassDescriptor(qualifiedName, psiClass, tasks, containingDeclaration);
    }

    private void cacheNegativeValue(@NotNull FqNameBase qualifiedName) {
        if (this.unresolvedCache.contains(qualifiedName) || this.classDescriptorCache.containsKey(qualifiedName)) {
            throw new IllegalStateException("rewrite at " + qualifiedName);
        }
        this.unresolvedCache.add(qualifiedName);
    }

    private static boolean isTraitImplementation(@NotNull FqName qualifiedName) {
        return qualifiedName.asString().endsWith("$$TImpl");
    }

    @NotNull
    private ClassDescriptorFromJvmBytecode doCreateClassDescriptor(@NotNull FqName fqName, @NotNull PsiClass psiClass, @NotNull PostponedTasks taskList, @NotNull ClassOrNamespaceDescriptor containingDeclaration) {
        ClassDescriptorFromJvmBytecode classDescriptor = new ClassDescriptorFromJvmBytecode(containingDeclaration, JavaClassResolver.getClassKind(psiClass), JavaClassResolver.isInnerClass(psiClass));
        this.cache(JavaClassResolver.javaClassToKotlinFqName(fqName), classDescriptor);
        classDescriptor.setName(Name.identifier(psiClass.getName()));
        List<JavaSignatureResolver.TypeParameterDescriptorInitialization> typeParameterDescriptorInitializations = JavaSignatureResolver.createUninitializedClassTypeParameters(psiClass, classDescriptor);
        classDescriptor.setTypeParameterDescriptors(JavaClassResolver.getTypeParametersDescriptors(typeParameterDescriptorInitializations));
        ArrayList<JetType> supertypes = Lists.newArrayList();
        classDescriptor.setSupertypes(supertypes);
        classDescriptor.setVisibility(DescriptorResolverUtils.resolveVisibility(psiClass));
        classDescriptor.setModality(JavaClassResolver.resolveModality(psiClass, classDescriptor));
        classDescriptor.createTypeConstructor();
        JavaClassNonStaticMembersScope scope = new JavaClassNonStaticMembersScope(classDescriptor, psiClass, false, this.psiClassFinder, this.javaDescriptorResolver);
        classDescriptor.setScopeForMemberLookup(scope);
        classDescriptor.setScopeForConstructorResolve(scope);
        String context = "class " + psiClass.getQualifiedName();
        this.signatureResolver.initializeTypeParameters(typeParameterDescriptorInitializations, classDescriptor, context);
        List<TypeParameterDescriptor> classTypeParameters = classDescriptor.getTypeConstructor().getParameters();
        supertypes.addAll(this.supertypesResolver.getSupertypes(classDescriptor, psiClass, classTypeParameters));
        if (psiClass.isEnum()) {
            ClassDescriptorFromJvmBytecode classObjectDescriptor = this.createClassObjectDescriptorForEnum(classDescriptor, psiClass);
            this.cache(JavaClassResolver.getFqNameForClassObject(psiClass), classObjectDescriptor);
            classDescriptor.getBuilder().setClassObjectDescriptor(classObjectDescriptor);
        }
        classDescriptor.setAnnotations(this.annotationResolver.resolveAnnotations(psiClass, taskList));
        this.trace.record(BindingContext.CLASS, psiClass, classDescriptor);
        PsiMethod samInterfaceMethod = SingleAbstractMethodUtils.getSamInterfaceMethod(psiClass);
        if (samInterfaceMethod != null) {
            SimpleFunctionDescriptor abstractMethod = this.resolveFunctionOfSamInterface(samInterfaceMethod, classDescriptor);
            classDescriptor.setFunctionTypeForSamInterface(SingleAbstractMethodUtils.getFunctionTypeForAbstractMethod(abstractMethod));
        }
        return classDescriptor;
    }

    @NotNull
    private static FqNameUnsafe getFqNameForClassObject(@NotNull PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        assert (qualifiedName != null) : "Reading java class with no qualified name";
        return new FqNameUnsafe(qualifiedName + "." + DescriptorUtils.getClassObjectName(psiClass.getName()).asString());
    }

    @NotNull
    private SimpleFunctionDescriptor resolveFunctionOfSamInterface(@NotNull PsiMethod samInterfaceMethod, @NotNull ClassDescriptorFromJvmBytecode samInterface) {
        PsiClass methodContainer = samInterfaceMethod.getContainingClass();
        assert (methodContainer != null) : "method container is null for " + samInterfaceMethod;
        String containerQualifiedName = methodContainer.getQualifiedName();
        assert (containerQualifiedName != null) : "qualified name is null for " + methodContainer;
        if (DescriptorUtils.getFQName(samInterface).asString().equals(containerQualifiedName)) {
            SimpleFunctionDescriptor abstractMethod = this.functionResolver.resolveFunctionMutely(new PsiMethodWrapper(samInterfaceMethod), samInterface);
            assert (abstractMethod != null) : "couldn't resolve method " + samInterfaceMethod;
            return abstractMethod;
        }
        return JavaClassResolver.findFunctionWithMostSpecificReturnType(TypeUtils.getAllSupertypes(samInterface.getDefaultType()));
    }

    private static SimpleFunctionDescriptor findFunctionWithMostSpecificReturnType(@NotNull Set<JetType> supertypes) {
        ArrayList<SimpleFunctionDescriptor> candidates = Lists.newArrayList();
        for (JetType supertype : supertypes) {
            List<CallableMemberDescriptor> abstractMembers = SingleAbstractMethodUtils.getAbstractMembers(supertype);
            if (abstractMembers.isEmpty()) continue;
            candidates.add((SimpleFunctionDescriptor)abstractMembers.get(0));
        }
        if (candidates.isEmpty()) {
            throw new IllegalStateException("Couldn't find abstract method in supertypes " + supertypes);
        }
        SimpleFunctionDescriptor currentMostSpecificType = (SimpleFunctionDescriptor)candidates.get(0);
        for (SimpleFunctionDescriptor candidate : candidates) {
            if (!JetTypeChecker.INSTANCE.isSubtypeOf(candidate.getReturnType(), currentMostSpecificType.getReturnType())) continue;
            currentMostSpecificType = candidate;
        }
        return currentMostSpecificType;
    }

    private void cache(@NotNull FqNameBase fqName, @Nullable ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            this.cacheNegativeValue(fqName);
        } else {
            ClassDescriptor oldValue = this.classDescriptorCache.put(fqName, classDescriptor);
            assert (oldValue == null);
        }
    }

    @NotNull
    private static List<TypeParameterDescriptor> getTypeParametersDescriptors(@NotNull List<JavaSignatureResolver.TypeParameterDescriptorInitialization> typeParameterDescriptorInitializations) {
        ArrayList<TypeParameterDescriptor> typeParameters = Lists.newArrayList();
        for (JavaSignatureResolver.TypeParameterDescriptorInitialization typeParameter : typeParameterDescriptorInitializations) {
            typeParameters.add(typeParameter.getDescriptor());
        }
        return typeParameters;
    }

    @NotNull
    private static Modality resolveModality(@NotNull PsiClass psiClass, @NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS) {
            return Modality.FINAL;
        }
        return Modality.convertFromFlags(psiClass.hasModifierProperty("abstract") || psiClass.isInterface(), !psiClass.hasModifierProperty("final"));
    }

    private void checkFqNamesAreConsistent(@NotNull PsiClass psiClass, @NotNull FqName desiredFqName) {
        String qualifiedName = psiClass.getQualifiedName();
        assert (qualifiedName != null);
        FqName fqName = new FqName(qualifiedName);
        assert (fqName.equals(desiredFqName));
        FqNameUnsafe correctedName = JavaClassResolver.javaClassToKotlinFqName(fqName);
        if (this.classDescriptorCache.containsKey(correctedName) || this.unresolvedCache.contains(correctedName)) {
            throw new IllegalStateException(qualifiedName);
        }
    }

    private static void checkPsiClassIsNotJet(@NotNull PsiClass psiClass) {
        if (psiClass instanceof JetJavaMirrorMarker) {
            throw new IllegalStateException("trying to resolve fake jet PsiClass as regular PsiClass: " + psiClass.getQualifiedName());
        }
    }

    @NotNull
    private ClassOrNamespaceDescriptor resolveParentDescriptor(@NotNull FqName childClassFQName, boolean isInnerClass) {
        FqName parentFqName = childClassFQName.parent();
        if (isInnerClass) {
            ClassDescriptor parentClass = this.resolveClass(parentFqName, DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
            if (parentClass == null) {
                throw new IllegalStateException("Could not resolve " + parentFqName + " required to be parent for " + childClassFQName);
            }
            return parentClass;
        }
        NamespaceDescriptor parentNamespace = this.namespaceResolver.resolveNamespace(parentFqName, DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
        if (parentNamespace == null) {
            throw new IllegalStateException("Could not resolve " + parentFqName + " required to be parent for " + childClassFQName);
        }
        return parentNamespace;
    }

    @NotNull
    private static FqNameUnsafe javaClassToKotlinFqName(@NotNull FqName rawFqName) {
        ArrayList<Name> correctedSegments = new ArrayList<Name>();
        for (Name segment : rawFqName.pathSegments()) {
            if ("object".equals(segment.asString())) {
                assert (!correctedSegments.isEmpty());
                Name previous = (Name)correctedSegments.get(correctedSegments.size() - 1);
                correctedSegments.add(DescriptorUtils.getClassObjectName(previous));
                continue;
            }
            correctedSegments.add(segment);
        }
        return new FqNameUnsafe(StringUtil.join(correctedSegments, "."));
    }

    private static boolean isContainedInClass(@NotNull PsiClass psiClass) {
        return psiClass.getContainingClass() != null;
    }

    private static boolean isInnerClass(@NotNull PsiClass psiClass) {
        return JavaClassResolver.isContainedInClass(psiClass) && !psiClass.hasModifierProperty("static");
    }

    @NotNull
    private static ClassKind getClassKind(@NotNull PsiClass psiClass) {
        if (psiClass.isInterface()) {
            return psiClass.isAnnotationType() ? ClassKind.ANNOTATION_CLASS : ClassKind.TRAIT;
        }
        if (psiClass.isEnum()) {
            return ClassKind.ENUM_CLASS;
        }
        return ClassKind.CLASS;
    }

    @NotNull
    private ClassDescriptorFromJvmBytecode createClassObjectDescriptorForEnum(@NotNull ClassDescriptor containing, @NotNull PsiClass psiClass) {
        ClassDescriptorFromJvmBytecode classObjectDescriptor = this.createSyntheticClassObject(containing, psiClass);
        classObjectDescriptor.getBuilder().addFunctionDescriptor(DescriptorResolver.createEnumClassObjectValuesMethod(classObjectDescriptor, this.trace));
        classObjectDescriptor.getBuilder().addFunctionDescriptor(DescriptorResolver.createEnumClassObjectValueOfMethod(classObjectDescriptor, this.trace));
        return classObjectDescriptor;
    }

    @NotNull
    private ClassDescriptorFromJvmBytecode createSyntheticClassObject(@NotNull ClassDescriptor containing, @NotNull PsiClass psiClass) {
        ClassDescriptorFromJvmBytecode classObjectDescriptor = new ClassDescriptorFromJvmBytecode(containing, ClassKind.CLASS_OBJECT, false);
        classObjectDescriptor.setName(DescriptorUtils.getClassObjectName(containing.getName()));
        classObjectDescriptor.setModality(Modality.FINAL);
        classObjectDescriptor.setVisibility(containing.getVisibility());
        classObjectDescriptor.setTypeParameterDescriptors(Collections.<TypeParameterDescriptor>emptyList());
        classObjectDescriptor.createTypeConstructor();
        JavaClassNonStaticMembersScope scope = new JavaClassNonStaticMembersScope(classObjectDescriptor, psiClass, true, this.psiClassFinder, this.javaDescriptorResolver);
        WritableScopeImpl writableScope = new WritableScopeImpl(scope, classObjectDescriptor, RedeclarationHandler.THROW_EXCEPTION, "Member lookup scope");
        writableScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        classObjectDescriptor.setScopeForMemberLookup(writableScope);
        classObjectDescriptor.setScopeForConstructorResolve(scope);
        return classObjectDescriptor;
    }
}

