/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorParent;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.descriptor.ClassDescriptorFromJvmBytecode;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.AlternativeMethodSignatureData;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.SignaturesPropagationData;
import org.jetbrains.jet.lang.resolve.java.provider.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaMethodSignatureUtil;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaValueParameterResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.RawTypesCheck;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeSubstitution;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public final class JavaFunctionResolver {
    private static final Logger LOG = Logger.getInstance(JavaFunctionResolver.class);
    private JavaTypeTransformer typeTransformer;
    private BindingTrace trace;
    private JavaSignatureResolver signatureResolver;
    private JavaValueParameterResolver parameterResolver;
    private JavaAnnotationResolver annotationResolver;

    public void setTypeTransformer(JavaTypeTransformer typeTransformer) {
        this.typeTransformer = typeTransformer;
    }

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void setSignatureResolver(JavaSignatureResolver signatureResolver) {
        this.signatureResolver = signatureResolver;
    }

    public void setParameterResolver(JavaValueParameterResolver parameterResolver) {
        this.parameterResolver = parameterResolver;
    }

    public void setAnnotationResolver(JavaAnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    @Nullable
    SimpleFunctionDescriptor resolveFunctionMutely(@NotNull PsiMethodWrapper method, @NotNull ClassOrNamespaceDescriptor ownerDescriptor) {
        PsiClass containingClass = method.getPsiMethod().getContainingClass();
        assert (containingClass != null) : "containing class is null for " + method;
        return this.resolveMethodToFunctionDescriptor(containingClass, method, ownerDescriptor, false);
    }

    @Nullable
    private SimpleFunctionDescriptor resolveMethodToFunctionDescriptor(@NotNull PsiClass psiClass, PsiMethodWrapper method, @NotNull ClassOrNamespaceDescriptor ownerDescriptor, boolean record) {
        List<FunctionDescriptor> superFunctions;
        if (!DescriptorResolverUtils.isCorrectOwnerForEnumMember(ownerDescriptor, method.getPsiMember())) {
            return null;
        }
        PsiType returnPsiType = method.getReturnType();
        if (returnPsiType == null) {
            return null;
        }
        PsiMethod psiMethod = method.getPsiMethod();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (this.trace.get(BindingContext.FUNCTION, psiMethod) != null) {
            return this.trace.get(BindingContext.FUNCTION, psiMethod);
        }
        SimpleFunctionDescriptorImpl functionDescriptorImpl = new SimpleFunctionDescriptorImpl(ownerDescriptor, this.annotationResolver.resolveAnnotations(psiMethod), Name.identifier(method.getName()), CallableMemberDescriptor.Kind.DECLARATION);
        List<TypeParameterDescriptor> methodTypeParameters = this.signatureResolver.resolveMethodTypeParameters(method, functionDescriptorImpl);
        TypeVariableResolver methodTypeVariableResolver = new TypeVariableResolver(methodTypeParameters, functionDescriptorImpl, "method " + method.getName() + " in class " + psiClass.getQualifiedName());
        JavaDescriptorResolver.ValueParameterDescriptors valueParameterDescriptors = this.parameterResolver.resolveParameterDescriptors(functionDescriptorImpl, method.getParameters(), methodTypeVariableResolver);
        JetType returnType = this.makeReturnType(returnPsiType, method, methodTypeVariableResolver);
        ArrayList<String> signatureErrors = Lists.newArrayList();
        if (ownerDescriptor instanceof ClassDescriptor) {
            SignaturesPropagationData signaturesPropagationData = new SignaturesPropagationData((ClassDescriptor)ownerDescriptor, returnType, valueParameterDescriptors, methodTypeParameters, method, this.trace);
            superFunctions = signaturesPropagationData.getSuperFunctions();
            returnType = signaturesPropagationData.getModifiedReturnType();
            valueParameterDescriptors = signaturesPropagationData.getModifiedValueParameters();
            methodTypeParameters = signaturesPropagationData.getModifiedTypeParameters();
            signatureErrors.addAll(signaturesPropagationData.getSignatureErrors());
        } else {
            superFunctions = Collections.emptyList();
        }
        AlternativeMethodSignatureData alternativeMethodSignatureData = new AlternativeMethodSignatureData(method, valueParameterDescriptors, returnType, methodTypeParameters, !superFunctions.isEmpty());
        if (alternativeMethodSignatureData.isAnnotated() && !alternativeMethodSignatureData.hasErrors()) {
            valueParameterDescriptors = alternativeMethodSignatureData.getValueParameters();
            returnType = alternativeMethodSignatureData.getReturnType();
            methodTypeParameters = alternativeMethodSignatureData.getTypeParameters();
        } else if (alternativeMethodSignatureData.hasErrors()) {
            signatureErrors.add(alternativeMethodSignatureData.getError());
        }
        functionDescriptorImpl.initialize(valueParameterDescriptors.getReceiverType(), DescriptorUtils.getExpectedThisObjectIfNeeded(ownerDescriptor), methodTypeParameters, valueParameterDescriptors.getDescriptors(), returnType, Modality.convertFromFlags(method.isAbstract(), !method.isFinal()), DescriptorResolverUtils.resolveVisibility(psiMethod), false);
        if (functionDescriptorImpl.getKind() == CallableMemberDescriptor.Kind.DECLARATION && record) {
            BindingContextUtils.recordFunctionDeclarationToDescriptor(this.trace, psiMethod, functionDescriptorImpl);
        }
        if (record) {
            this.trace.record(JavaBindingContext.IS_DECLARED_IN_JAVA, functionDescriptorImpl);
        }
        if (containingClass != psiClass && !method.isStatic()) {
            throw new IllegalStateException("non-static method in subclass");
        }
        if (!RawTypesCheck.hasRawTypesInHierarchicalSignature(psiMethod) && JavaMethodSignatureUtil.isMethodReturnTypeCompatible(psiMethod) && !JavaFunctionResolver.containsErrorType(superFunctions, functionDescriptorImpl)) {
            if (signatureErrors.isEmpty()) {
                JavaFunctionResolver.checkFunctionsOverrideCorrectly(method, superFunctions, functionDescriptorImpl);
            } else if (record) {
                this.trace.record(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS, functionDescriptorImpl, signatureErrors);
            }
        }
        return functionDescriptorImpl;
    }

    private static void checkFunctionsOverrideCorrectly(PsiMethodWrapper method, List<FunctionDescriptor> superFunctions, FunctionDescriptor functionDescriptor) {
        for (FunctionDescriptor superFunction : superFunctions) {
            ClassDescriptor klass = (ClassDescriptor)functionDescriptor.getContainingDeclaration();
            ArrayList<TypeSubstitution> substitutions = Lists.newArrayList();
            while (true) {
                substitutions.add(SubstitutionUtils.buildDeepSubstitutor(klass.getDefaultType()).getSubstitution());
                if (!klass.isInner()) break;
                klass = (ClassDescriptor)klass.getContainingDeclaration();
            }
            TypeSubstitutor substitutor = TypeSubstitutor.create(substitutions.toArray(new TypeSubstitution[substitutions.size()]));
            FunctionDescriptor superFunctionSubstituted = superFunction.substitute(substitutor);
            assert (superFunctionSubstituted != null) : "Couldn't substitute super function: " + superFunction + ", substitutor = " + substitutor;
            OverridingUtil.OverrideCompatibilityInfo.Result overridableResult = OverridingUtil.isOverridableBy(superFunctionSubstituted, functionDescriptor).getResult();
            boolean paramsOk = overridableResult == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
            boolean returnTypeOk = OverridingUtil.isReturnTypeOkForOverride(JetTypeChecker.INSTANCE, superFunctionSubstituted, functionDescriptor);
            if (paramsOk && returnTypeOk) continue;
            LOG.error("Loaded Java method overrides another, but resolved as Kotlin function, doesn't.\nsuper function = " + superFunction + "\n" + "super class = " + superFunction.getContainingDeclaration() + "\n" + "sub function = " + functionDescriptor + "\n" + "sub class = " + functionDescriptor.getContainingDeclaration() + "\n" + "sub method = " + PsiFormatUtil.getExternalName(method.getPsiMethod()) + "\n" + "@KotlinSignature = " + method.getSignatureAnnotation().signature());
        }
    }

    @NotNull
    public Set<FunctionDescriptor> resolveFunctionGroupForClass(@NotNull NamedMembers namedMembers, @NotNull ClassOrNamespaceDescriptor owner, @NotNull PsiClass psiClass) {
        Name methodName = namedMembers.getName();
        Set<SimpleFunctionDescriptor> functionsFromSupertypes = null;
        if (owner instanceof ClassDescriptor) {
            functionsFromSupertypes = JavaFunctionResolver.getFunctionsFromSupertypes(methodName, owner);
        }
        HashSet<SimpleFunctionDescriptor> functionsFromCurrent = Sets.newHashSet();
        for (PsiMethodWrapper method : namedMembers.getMethods()) {
            SimpleFunctionDescriptor function = this.resolveMethodToFunctionDescriptor(psiClass, method, owner, true);
            if (function == null) continue;
            functionsFromCurrent.add(function);
            ContainerUtil.addIfNotNull(functionsFromCurrent, this.resolveSamAdapter(function));
        }
        if (owner instanceof NamespaceDescriptor) {
            ContainerUtil.addIfNotNull(functionsFromCurrent, this.resolveSamConstructor((NamespaceDescriptor)owner, namedMembers));
        }
        final HashSet fakeOverrides = new HashSet();
        if (owner instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)owner;
            OverrideResolver.generateOverridesInFunctionGroup(methodName, functionsFromSupertypes, functionsFromCurrent, classDescriptor, new OverrideResolver.DescriptorSink(){

                @Override
                public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                    fakeOverrides.add((FunctionDescriptor)fakeOverride);
                }

                @Override
                public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                }
            });
        }
        OverrideResolver.resolveUnknownVisibilities(fakeOverrides, this.trace);
        HashSet<FunctionDescriptor> functions = Sets.newHashSet(fakeOverrides);
        if (DescriptorUtils.isEnumClassObject(owner)) {
            for (SimpleFunctionDescriptor functionDescriptor : functionsFromCurrent) {
                if (DescriptorUtils.isEnumValueOfMethod(functionDescriptor) || DescriptorUtils.isEnumValuesMethod(functionDescriptor)) continue;
                functions.add(functionDescriptor);
            }
        } else {
            functions.addAll(functionsFromCurrent);
        }
        return functions;
    }

    @Nullable
    private static ClassDescriptorFromJvmBytecode findClassInScope(@NotNull JetScope memberScope, @NotNull Name name) {
        ClassifierDescriptor classifier = memberScope.getClassifier(name);
        if (classifier instanceof ClassDescriptorFromJvmBytecode) {
            return (ClassDescriptorFromJvmBytecode)classifier;
        }
        return null;
    }

    @Nullable
    private static ClassDescriptorFromJvmBytecode findClassInNamespace(@NotNull NamespaceDescriptor namespace, @NotNull Name name) {
        ClassDescriptorFromJvmBytecode found = JavaFunctionResolver.findClassInScope(namespace.getMemberScope(), name);
        if (found != null) {
            return found;
        }
        NamespaceDescriptorParent parent = namespace.getContainingDeclaration();
        if (parent instanceof NamespaceDescriptor) {
            ClassDescriptorFromJvmBytecode classForCurrentNamespace = JavaFunctionResolver.findClassInNamespace((NamespaceDescriptor)parent, namespace.getName());
            if (classForCurrentNamespace == null) {
                return null;
            }
            return JavaFunctionResolver.findClassInScope(DescriptorUtils.getStaticNestedClassesScope(classForCurrentNamespace), name);
        }
        return null;
    }

    @Nullable
    private SimpleFunctionDescriptor resolveSamConstructor(@NotNull NamespaceDescriptor ownerDescriptor, @NotNull NamedMembers namedMembers) {
        ClassDescriptorFromJvmBytecode klass;
        PsiClass samInterface = namedMembers.getSamInterface();
        if (samInterface != null && (klass = JavaFunctionResolver.findClassInNamespace(ownerDescriptor, namedMembers.getName())) != null) {
            return JavaFunctionResolver.recordSamConstructor(klass, SingleAbstractMethodUtils.createSamConstructorFunction(ownerDescriptor, klass), this.trace);
        }
        return null;
    }

    @Nullable
    private SimpleFunctionDescriptor resolveSamAdapter(@NotNull SimpleFunctionDescriptor original) {
        return SingleAbstractMethodUtils.isSamAdapterNecessary(original) ? JavaFunctionResolver.recordSamAdapter(original, SingleAbstractMethodUtils.createSamAdapterFunction(original), this.trace) : null;
    }

    @NotNull
    public Set<FunctionDescriptor> resolveFunctionGroupForPackage(@NotNull NamedMembers members, @NotNull NamespaceDescriptor owner) {
        SimpleFunctionDescriptor samConstructor = this.resolveSamConstructor(owner, members);
        if (samConstructor != null) {
            return Collections.singleton(samConstructor);
        }
        return Collections.emptySet();
    }

    @NotNull
    private JetType makeReturnType(PsiType returnType, PsiMethodWrapper method, @NotNull TypeVariableResolver typeVariableResolver) {
        TypeUsage typeUsage = JavaTypeTransformer.adjustTypeUsageWithMutabilityAnnotations(method.getPsiMethod(), TypeUsage.MEMBER_SIGNATURE_COVARIANT);
        JetType transformedType = this.typeTransformer.transformToType(returnType, typeUsage, typeVariableResolver);
        if (JavaAnnotationResolver.findAnnotationWithExternal(method.getPsiMethod(), JvmAnnotationNames.JETBRAINS_NOT_NULL_ANNOTATION.getFqName().asString()) != null) {
            return TypeUtils.makeNullableAsSpecified(transformedType, false);
        }
        return transformedType;
    }

    @NotNull
    private static Set<SimpleFunctionDescriptor> getFunctionsFromSupertypes(@NotNull Name methodName, @NotNull ClassOrNamespaceDescriptor classOrNamespaceDescriptor) {
        LinkedHashSet<SimpleFunctionDescriptor> r = Sets.newLinkedHashSet();
        for (JetType supertype : DescriptorResolverUtils.getSupertypes(classOrNamespaceDescriptor)) {
            for (FunctionDescriptor function : supertype.getMemberScope().getFunctions(methodName)) {
                r.add((SimpleFunctionDescriptor)function);
            }
        }
        return r;
    }

    private static boolean containsErrorType(@NotNull List<FunctionDescriptor> superFunctions, @NotNull FunctionDescriptor function) {
        if (ErrorUtils.containsErrorType(function)) {
            return true;
        }
        for (FunctionDescriptor superFunction : superFunctions) {
            if (!ErrorUtils.containsErrorType(superFunction)) continue;
            return true;
        }
        return false;
    }

    private static SimpleFunctionDescriptor recordSamConstructor(ClassDescriptorFromJvmBytecode klass, SimpleFunctionDescriptor constructorFunction, BindingTrace trace) {
        trace.record(JavaBindingContext.SAM_CONSTRUCTOR_TO_INTERFACE, constructorFunction, klass);
        trace.record(BindingContext.SOURCE_DESCRIPTOR_FOR_SYNTHESIZED, constructorFunction, klass);
        return constructorFunction;
    }

    static <F extends FunctionDescriptor> F recordSamAdapter(F original, F adapterFunction, BindingTrace trace) {
        trace.record(JavaBindingContext.SAM_ADAPTER_FUNCTION_TO_ORIGINAL, adapterFunction, original);
        trace.record(BindingContext.SOURCE_DESCRIPTOR_FOR_SYNTHESIZED, adapterFunction, original);
        return adapterFunction;
    }
}

