/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorParent;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.AbiVersionUtil;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;
import org.jetbrains.jet.lang.resolve.java.JavaBridgeConfiguration;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaNamespaceKind;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaNamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.java.resolver.DeserializedDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.java.scope.JavaBaseScope;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassStaticMembersScope;
import org.jetbrains.jet.lang.resolve.java.scope.JavaPackageScope;
import org.jetbrains.jet.lang.resolve.java.vfilefinder.VirtualFileFinder;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public final class JavaNamespaceResolver {
    @NotNull
    public static final ModuleDescriptor FAKE_ROOT_MODULE = new ModuleDescriptorImpl(JavaDescriptorResolver.JAVA_ROOT, JavaBridgeConfiguration.ALL_JAVA_IMPORTS, JavaToKotlinClassMap.getInstance());
    @NotNull
    private final Map<FqName, JetScope> resolvedNamespaceCache = Maps.newHashMap();
    @NotNull
    private final Set<FqName> unresolvedCache = Sets.newHashSet();
    private PsiClassFinder psiClassFinder;
    private BindingTrace trace;
    private JavaDescriptorResolver javaDescriptorResolver;
    private DeserializedDescriptorResolver deserializedDescriptorResolver;
    private VirtualFileFinder virtualFileFinder;

    public void setVirtualFileFinder(VirtualFileFinder virtualFileFinder) {
        this.virtualFileFinder = virtualFileFinder;
    }

    public void setPsiClassFinder(PsiClassFinder psiClassFinder) {
        this.psiClassFinder = psiClassFinder;
    }

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void setJavaDescriptorResolver(@NotNull JavaDescriptorResolver javaDescriptorResolver) {
        this.javaDescriptorResolver = javaDescriptorResolver;
    }

    public void setDeserializedDescriptorResolver(DeserializedDescriptorResolver deserializedDescriptorResolver) {
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }

    @Nullable
    public NamespaceDescriptor resolveNamespace(@NotNull FqName qualifiedName, @NotNull DescriptorSearchRule searchRule) {
        NamespaceDescriptor kotlinNamespaceDescriptor = this.trace.get(BindingContext.FQNAME_TO_NAMESPACE_DESCRIPTOR, qualifiedName);
        if (kotlinNamespaceDescriptor != null) {
            return searchRule.processFoundInKotlin(kotlinNamespaceDescriptor);
        }
        if (this.unresolvedCache.contains(qualifiedName)) {
            return null;
        }
        JetScope scope = this.resolvedNamespaceCache.get(qualifiedName);
        if (scope != null) {
            return (NamespaceDescriptor)scope.getContainingDeclaration();
        }
        NamespaceDescriptorParent parentNs = this.resolveParentNamespace(qualifiedName);
        if (parentNs == null) {
            return null;
        }
        JavaNamespaceDescriptor javaNamespaceDescriptor = new JavaNamespaceDescriptor(parentNs, Collections.<AnnotationDescriptor>emptyList(), qualifiedName);
        JetScope newScope = this.createNamespaceScope(qualifiedName, javaNamespaceDescriptor);
        if (newScope == null) {
            return null;
        }
        if (newScope instanceof JavaBaseScope) {
            this.trace.record(BindingContext.NAMESPACE, ((JavaBaseScope)newScope).getPsiElement(), javaNamespaceDescriptor);
        }
        javaNamespaceDescriptor.setMemberScope(newScope);
        return javaNamespaceDescriptor;
    }

    @Nullable
    private NamespaceDescriptorParent resolveParentNamespace(@NotNull FqName fqName) {
        if (fqName.isRoot()) {
            return FAKE_ROOT_MODULE;
        }
        return this.resolveNamespace(fqName.parent(), DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
    }

    @Nullable
    private JetScope createNamespaceScope(@NotNull FqName fqName, @NotNull NamespaceDescriptor namespaceDescriptor) {
        JetScope namespaceScope = this.doCreateNamespaceScope(fqName, namespaceDescriptor);
        this.cache(fqName, namespaceScope);
        return namespaceScope;
    }

    @Nullable
    private JetScope doCreateNamespaceScope(@NotNull FqName fqName, @NotNull NamespaceDescriptor namespaceDescriptor) {
        PsiPackage psiPackage = this.psiClassFinder.findPsiPackage(fqName);
        if (psiPackage != null) {
            ErrorReporter errorReporter;
            JetScope kotlinPackageScope;
            FqName packageClassFqName = PackageClassUtils.getPackageClassFqName(fqName);
            VirtualFile virtualFile = this.virtualFileFinder.find(packageClassFqName);
            this.trace.record(JavaBindingContext.JAVA_NAMESPACE_KIND, namespaceDescriptor, JavaNamespaceKind.PROPER);
            if (virtualFile != null && (kotlinPackageScope = this.deserializedDescriptorResolver.createKotlinPackageScope(namespaceDescriptor, virtualFile, errorReporter = AbiVersionUtil.abiVersionErrorReporter(virtualFile, packageClassFqName, this.trace))) != null) {
                return kotlinPackageScope;
            }
            return new JavaPackageScope(namespaceDescriptor, psiPackage, fqName, this.javaDescriptorResolver, this.psiClassFinder);
        }
        PsiClass psiClass = this.psiClassFinder.findPsiClass(fqName, PsiClassFinder.RuntimeClassesHandleMode.IGNORE);
        if (psiClass == null) {
            return null;
        }
        if (DescriptorResolverUtils.isCompiledKotlinClassOrPackageClass(psiClass)) {
            return null;
        }
        if (!JavaNamespaceResolver.hasStaticMembers(psiClass)) {
            return null;
        }
        this.trace.record(JavaBindingContext.JAVA_NAMESPACE_KIND, namespaceDescriptor, JavaNamespaceKind.CLASS_STATICS);
        return new JavaClassStaticMembersScope(namespaceDescriptor, fqName, psiClass, this.psiClassFinder, this.javaDescriptorResolver);
    }

    private void cache(@NotNull FqName fqName, @Nullable JetScope packageScope) {
        if (packageScope == null) {
            this.unresolvedCache.add(fqName);
            return;
        }
        JetScope oldValue = this.resolvedNamespaceCache.put(fqName, packageScope);
        if (oldValue != null) {
            throw new IllegalStateException("rewrite at " + fqName);
        }
    }

    @Nullable
    public JetScope getJavaPackageScopeForExistingNamespaceDescriptor(@NotNull NamespaceDescriptor namespaceDescriptor) {
        FqName fqName = DescriptorUtils.getFQName(namespaceDescriptor).toSafe();
        if (this.unresolvedCache.contains(fqName)) {
            throw new IllegalStateException("This means that we are trying to create a Java package, but have a package with the same FQN defined in Kotlin: " + fqName);
        }
        JetScope alreadyResolvedScope = this.resolvedNamespaceCache.get(fqName);
        if (alreadyResolvedScope != null) {
            return alreadyResolvedScope;
        }
        return this.createNamespaceScope(fqName, namespaceDescriptor);
    }

    private static boolean hasStaticMembers(@NotNull PsiClass psiClass) {
        for (PsiDocCommentOwner member : ContainerUtil.concat(psiClass.getMethods(), psiClass.getFields())) {
            if (!member.hasModifierProperty("static") || DescriptorResolverUtils.shouldBeInEnumClassObject(member)) continue;
            return true;
        }
        for (PsiClass nestedClass : psiClass.getInnerClasses()) {
            if (SingleAbstractMethodUtils.isSamInterface(nestedClass)) {
                return true;
            }
            if (!nestedClass.hasModifierProperty("static") || !JavaNamespaceResolver.hasStaticMembers(nestedClass)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<Name> getClassNamesInPackage(@NotNull FqName packageName) {
        PsiPackage psiPackage = this.psiClassFinder.findPsiPackage(packageName);
        if (psiPackage == null) {
            return Collections.emptyList();
        }
        PsiClass[] classes = psiPackage.getClasses();
        ArrayList<Name> result = new ArrayList<Name>(classes.length);
        for (PsiClass psiClass : classes) {
            if (!DescriptorResolverUtils.isCompiledKotlinClass(psiClass)) continue;
            result.add(Name.identifier(psiClass.getName()));
        }
        return result;
    }
}

