/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.java.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public final class JavaSignatureResolver {
    @NotNull
    private JavaTypeTransformer typeTransformer;

    public void setTypeTransformer(@NotNull JavaTypeTransformer javaTypeTransformer) {
        this.typeTransformer = javaTypeTransformer;
    }

    private static List<TypeParameterDescriptorInitialization> makeUninitializedTypeParameters(@NotNull DeclarationDescriptor containingDeclaration, @NotNull PsiTypeParameter[] typeParameters) {
        ArrayList<TypeParameterDescriptorInitialization> result = Lists.newArrayList();
        for (PsiTypeParameter typeParameter : typeParameters) {
            TypeParameterDescriptorInitialization typeParameterDescriptor = JavaSignatureResolver.makeUninitializedTypeParameter(containingDeclaration, typeParameter);
            result.add(typeParameterDescriptor);
        }
        return result;
    }

    @NotNull
    private static TypeParameterDescriptorInitialization makeUninitializedTypeParameter(@NotNull DeclarationDescriptor containingDeclaration, @NotNull PsiTypeParameter psiTypeParameter) {
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDeclaration, Collections.<AnnotationDescriptor>emptyList(), false, Variance.INVARIANT, Name.identifier(psiTypeParameter.getName()), psiTypeParameter.getIndex());
        return new TypeParameterDescriptorInitialization(typeParameterDescriptor, psiTypeParameter);
    }

    private void initializeTypeParameter(TypeParameterDescriptorInitialization typeParameter, TypeVariableResolver typeVariableByPsiResolver) {
        TypeParameterDescriptorImpl typeParameterDescriptor = typeParameter.descriptor;
        PsiClassType[] referencedTypes = typeParameter.psiTypeParameter.getExtendsList().getReferencedTypes();
        if (referencedTypes.length == 0) {
            typeParameterDescriptor.addUpperBound(KotlinBuiltIns.getInstance().getNullableAnyType());
        } else {
            for (PsiClassType referencedType : referencedTypes) {
                JetType transformedType = this.typeTransformer.transformToType(referencedType, TypeUsage.UPPER_BOUND, typeVariableByPsiResolver);
                typeParameterDescriptor.addUpperBound(transformedType);
            }
        }
        typeParameterDescriptor.setInitialized();
    }

    public void initializeTypeParameters(List<TypeParameterDescriptorInitialization> typeParametersInitialization, @NotNull DeclarationDescriptor typeParametersOwner, @NotNull String context) {
        ArrayList<TypeParameterDescriptorImpl> prevTypeParameters = Lists.newArrayList();
        ArrayList<TypeParameterDescriptor> typeParameters = Lists.newArrayList();
        for (TypeParameterDescriptorInitialization typeParameterDescriptor : typeParametersInitialization) {
            typeParameters.add(typeParameterDescriptor.descriptor);
        }
        for (TypeParameterDescriptorInitialization psiTypeParameter : typeParametersInitialization) {
            prevTypeParameters.add(psiTypeParameter.descriptor);
            this.initializeTypeParameter(psiTypeParameter, new TypeVariableResolver(typeParameters, typeParametersOwner, context));
        }
    }

    @NotNull
    public static List<TypeParameterDescriptorInitialization> createUninitializedClassTypeParameters(PsiClass psiClass, ClassDescriptor classDescriptor) {
        ArrayList<TypeParameterDescriptorInitialization> result = Lists.newArrayList();
        for (PsiTypeParameter typeParameter : psiClass.getTypeParameters()) {
            TypeParameterDescriptorInitialization typeParameterDescriptor = JavaSignatureResolver.makeUninitializedTypeParameter(classDescriptor, typeParameter);
            result.add(typeParameterDescriptor);
        }
        return result;
    }

    public List<TypeParameterDescriptor> resolveMethodTypeParameters(@NotNull PsiMethodWrapper method, @NotNull DeclarationDescriptor functionDescriptor) {
        PsiMethod psiMethod = method.getPsiMethod();
        List<TypeParameterDescriptorInitialization> typeParametersIntialization = JavaSignatureResolver.makeUninitializedTypeParameters(functionDescriptor, psiMethod.getTypeParameters());
        PsiClass psiMethodContainingClass = psiMethod.getContainingClass();
        assert (psiMethodContainingClass != null);
        String context = "method " + method.getName() + " in class " + psiMethodContainingClass.getQualifiedName();
        this.initializeTypeParameters(typeParametersIntialization, functionDescriptor, context);
        ArrayList<TypeParameterDescriptor> typeParameters = Lists.newArrayListWithCapacity(typeParametersIntialization.size());
        for (TypeParameterDescriptorInitialization tpdi : typeParametersIntialization) {
            typeParameters.add(tpdi.descriptor);
        }
        return typeParameters;
    }

    public static class TypeParameterDescriptorInitialization {
        @NotNull
        private final TypeParameterDescriptorImpl descriptor;
        private final PsiTypeParameter psiTypeParameter;

        private TypeParameterDescriptorInitialization(@NotNull TypeParameterDescriptorImpl descriptor, @NotNull PsiTypeParameter psiTypeParameter) {
            this.descriptor = descriptor;
            this.psiTypeParameter = psiTypeParameter;
        }

        @NotNull
        public TypeParameterDescriptorImpl getDescriptor() {
            return this.descriptor;
        }
    }
}

