/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import com.intellij.psi.PsiClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassMembersScope;
import org.jetbrains.jet.lang.resolve.java.scope.MembersProvider;
import org.jetbrains.jet.lang.resolve.name.FqName;

public final class JavaClassNonStaticMembersScope
extends JavaClassMembersScope {
    private Collection<ConstructorDescriptor> constructors = null;
    private ConstructorDescriptor primaryConstructor = null;
    @NotNull
    private final ClassDescriptor descriptor;
    @NotNull
    private final PsiClass psiClass;
    private final boolean staticMembersOfPsiClass;

    public JavaClassNonStaticMembersScope(@NotNull ClassDescriptor descriptor, @NotNull PsiClass psiClass, boolean staticMembersOfPsiClass, @NotNull PsiClassFinder psiClassFinder, @NotNull JavaDescriptorResolver javaDescriptorResolver) {
        super(descriptor, psiClass, MembersProvider.forClass(psiClassFinder, psiClass, staticMembersOfPsiClass), javaDescriptorResolver);
        this.descriptor = descriptor;
        this.psiClass = psiClass;
        this.staticMembersOfPsiClass = staticMembersOfPsiClass;
    }

    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        this.initConstructorsIfNeeded();
        return this.constructors;
    }

    @Nullable
    public ConstructorDescriptor getPrimaryConstructor() {
        this.initConstructorsIfNeeded();
        return this.primaryConstructor;
    }

    private void initConstructorsIfNeeded() {
        if (this.constructors == null) {
            this.constructors = this.javaDescriptorResolver.resolveConstructors(this.psiClass, this.descriptor);
            for (ConstructorDescriptor constructor : this.constructors) {
                if (!constructor.isPrimary()) continue;
                if (this.primaryConstructor != null) {
                    throw new IllegalStateException("Class has more than one primary constructor: " + this.primaryConstructor + "\n" + constructor);
                }
                this.primaryConstructor = constructor;
            }
        }
    }

    @Override
    @NotNull
    protected Collection<ClassDescriptor> computeInnerClasses() {
        if (this.staticMembersOfPsiClass) {
            return Collections.emptyList();
        }
        PsiClass[] innerPsiClasses = this.psiClass.getInnerClasses();
        ArrayList<ClassDescriptor> result = new ArrayList<ClassDescriptor>(innerPsiClasses.length);
        for (PsiClass innerPsiClass : innerPsiClasses) {
            result.add(this.resolveInnerClass(innerPsiClass));
        }
        return result;
    }

    @NotNull
    private ClassDescriptor resolveInnerClass(@NotNull PsiClass innerPsiClass) {
        String name = innerPsiClass.getQualifiedName();
        assert (name != null) : "Inner class has no qualified name: " + innerPsiClass;
        ClassDescriptor classDescriptor = this.javaDescriptorResolver.resolveClass(new FqName(name), DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        assert (classDescriptor != null) : "Couldn't resolve inner class " + name;
        return classDescriptor;
    }
}

