/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import com.intellij.psi.PsiClass;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassMembersScope;
import org.jetbrains.jet.lang.resolve.java.scope.MembersProvider;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class JavaClassStaticMembersScope
extends JavaClassMembersScope {
    @NotNull
    private final FqName packageFQN;
    @NotNull
    private final PsiClass psiClass;

    public JavaClassStaticMembersScope(@NotNull NamespaceDescriptor descriptor, @NotNull FqName packageFQN, @NotNull PsiClass psiClass, @NotNull PsiClassFinder psiClassFinder, @NotNull JavaDescriptorResolver javaDescriptorResolver) {
        super(descriptor, psiClass, MembersProvider.forClass(psiClassFinder, psiClass, true), javaDescriptorResolver);
        this.packageFQN = packageFQN;
        this.psiClass = psiClass;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        return this.javaDescriptorResolver.resolveNamespace(this.packageFQN.child(name), DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> computeAllDescriptors() {
        Collection<DeclarationDescriptor> result = super.computeAllDescriptors();
        for (PsiClass nested : this.psiClass.getInnerClasses()) {
            ContainerUtil.addIfNotNull(result, this.getNamespace(Name.identifier(nested.getName())));
        }
        return result;
    }

    @Override
    @NotNull
    protected Collection<ClassDescriptor> computeInnerClasses() {
        return Collections.emptyList();
    }
}

