/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.provider.MembersCache;
import org.jetbrains.jet.lang.resolve.java.provider.NamedMembers;
import org.jetbrains.jet.lang.resolve.name.Name;

class MembersProvider {
    @NotNull
    private final PsiClassFinder psiClassFinder;
    @Nullable
    private final PsiClass psiClass;
    @Nullable
    private final PsiPackage psiPackage;
    private final boolean staticMembers;
    private MembersCache membersCache;

    private MembersProvider(@NotNull PsiClassFinder psiClassFinder, @Nullable PsiClass psiClass, @Nullable PsiPackage psiPackage, boolean staticMembers) {
        this.psiClassFinder = psiClassFinder;
        this.psiClass = psiClass;
        this.psiPackage = psiPackage;
        this.staticMembers = staticMembers;
    }

    @NotNull
    public static MembersProvider forPackage(@NotNull PsiClassFinder psiClassFinder, @NotNull PsiPackage psiPackage) {
        return new MembersProvider(psiClassFinder, null, psiPackage, true);
    }

    @NotNull
    public static MembersProvider forClass(@NotNull PsiClassFinder psiClassFinder, @NotNull PsiClass psiClass, boolean staticMembers) {
        return new MembersProvider(psiClassFinder, psiClass, null, staticMembers);
    }

    @Nullable
    public NamedMembers get(@NotNull Name name) {
        return this.getMembersCache().get(name);
    }

    @NotNull
    public Collection<NamedMembers> allMembers() {
        return this.getMembersCache().allMembers();
    }

    @NotNull
    private MembersCache getMembersCache() {
        if (this.membersCache == null) {
            this.membersCache = MembersCache.buildMembersByNameCache(this.psiClassFinder, this.psiClass, this.psiPackage, this.staticMembers);
        }
        return this.membersCache;
    }
}

