/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.wrapper;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMemberWrapper;

public class PsiMethodWrapper
extends PsiMemberWrapper {
    private List<PsiParameter> parameters;

    public PsiMethodWrapper(@NotNull PsiMethod psiMethod) {
        super(psiMethod);
    }

    @NotNull
    public List<PsiParameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = Lists.newArrayList(this.getPsiMethod().getParameterList().getParameters());
        }
        return this.parameters;
    }

    @Override
    public boolean isAbstract() {
        return this.psiMember.hasModifierProperty("abstract");
    }

    @NotNull
    public PsiMethod getPsiMethod() {
        return (PsiMethod)this.psiMember;
    }

    @Nullable
    public PsiType getReturnType() {
        return this.getPsiMethod().getReturnType();
    }
}

