/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.Computable;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetTypedef;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSessionUtils;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassInfoUtil;
import org.jetbrains.jet.lang.resolve.lazy.declarations.DeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public abstract class AbstractLazyMemberScope<D extends DeclarationDescriptor, DP extends DeclarationProvider>
implements JetScope {
    protected final ResolveSession resolveSession;
    protected final DP declarationProvider;
    protected final D thisDescriptor;
    private final MemoizedFunctionToNotNull<Name, List<ClassDescriptor>> classDescriptors;
    private final MemoizedFunctionToNotNull<Name, List<ClassDescriptor>> objectDescriptors;
    private final MemoizedFunctionToNotNull<Name, Set<FunctionDescriptor>> functionDescriptors;
    private final MemoizedFunctionToNotNull<Name, Set<VariableDescriptor>> propertyDescriptors;
    private final NotNullLazyValue<AllDescriptors> allDescriptors;

    protected AbstractLazyMemberScope(@NotNull ResolveSession resolveSession, @NotNull DP declarationProvider, @NotNull D thisDescriptor) {
        this.resolveSession = resolveSession;
        this.declarationProvider = declarationProvider;
        this.thisDescriptor = thisDescriptor;
        StorageManager storageManager = resolveSession.getStorageManager();
        this.classDescriptors = storageManager.createMemoizedFunction(new Function<Name, List<ClassDescriptor>>(){

            @Override
            public List<ClassDescriptor> fun(Name name) {
                return AbstractLazyMemberScope.this.resolveClassOrObjectDescriptor(name, false);
            }
        }, StorageManager.ReferenceKind.STRONG);
        this.objectDescriptors = storageManager.createMemoizedFunction(new Function<Name, List<ClassDescriptor>>(){

            @Override
            public List<ClassDescriptor> fun(Name name) {
                return AbstractLazyMemberScope.this.resolveClassOrObjectDescriptor(name, true);
            }
        }, StorageManager.ReferenceKind.STRONG);
        this.functionDescriptors = storageManager.createMemoizedFunction(new Function<Name, Set<FunctionDescriptor>>(){

            @Override
            public Set<FunctionDescriptor> fun(Name name) {
                return AbstractLazyMemberScope.this.doGetFunctions(name);
            }
        }, StorageManager.ReferenceKind.STRONG);
        this.propertyDescriptors = storageManager.createMemoizedFunction(new Function<Name, Set<VariableDescriptor>>(){

            @Override
            public Set<VariableDescriptor> fun(Name name) {
                return AbstractLazyMemberScope.this.doGetProperties(name);
            }
        }, StorageManager.ReferenceKind.STRONG);
        this.allDescriptors = storageManager.createLazyValue(new Computable<AllDescriptors>(){

            @Override
            public AllDescriptors compute() {
                return AbstractLazyMemberScope.this.computeAllDescriptors();
            }
        });
    }

    @Nullable
    private List<ClassDescriptor> resolveClassOrObjectDescriptor(final @NotNull Name name, final boolean object) {
        Collection<JetClassOrObject> classOrObjectDeclarations = this.declarationProvider.getClassOrObjectDeclarations(name);
        return ContainerUtil.mapNotNull(classOrObjectDeclarations, new Function<JetClassOrObject, ClassDescriptor>(){

            @Override
            public ClassDescriptor fun(JetClassOrObject classOrObject) {
                if (object != AbstractLazyMemberScope.declaresObjectOrEnumConstant(classOrObject)) {
                    return null;
                }
                return new LazyClassDescriptor(AbstractLazyMemberScope.this.resolveSession, (DeclarationDescriptor)AbstractLazyMemberScope.this.thisDescriptor, name, JetClassInfoUtil.createClassLikeInfo(classOrObject));
            }
        });
    }

    private static boolean declaresObjectOrEnumConstant(JetClassOrObject declaration) {
        return declaration instanceof JetObjectDeclaration || declaration instanceof JetEnumEntry;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        return AbstractLazyMemberScope.first(this.classDescriptors.fun(name));
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        return AbstractLazyMemberScope.first(this.objectDescriptors.fun(name));
    }

    private static <T> T first(@NotNull List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @NotNull
    public Set<FunctionDescriptor> getFunctions(@NotNull Name name) {
        return this.functionDescriptors.fun(name);
    }

    @NotNull
    private Set<FunctionDescriptor> doGetFunctions(@NotNull Name name) {
        LinkedHashSet<FunctionDescriptor> result = Sets.newLinkedHashSet();
        Collection<JetNamedFunction> declarations = this.declarationProvider.getFunctionDeclarations(name);
        for (JetNamedFunction functionDeclaration : declarations) {
            JetScope resolutionScope = this.getScopeForMemberDeclarationResolution(functionDeclaration);
            result.add(this.resolveSession.getInjector().getDescriptorResolver().resolveFunctionDescriptorWithAnnotationArguments((DeclarationDescriptor)this.thisDescriptor, resolutionScope, functionDeclaration, this.resolveSession.getTrace(), DataFlowInfo.EMPTY));
        }
        this.getNonDeclaredFunctions(name, result);
        return result;
    }

    @NotNull
    protected abstract JetScope getScopeForMemberDeclarationResolution(JetDeclaration var1);

    protected abstract void getNonDeclaredFunctions(@NotNull Name var1, @NotNull Set<FunctionDescriptor> var2);

    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull Name name) {
        return this.propertyDescriptors.fun(name);
    }

    @NotNull
    public Set<VariableDescriptor> doGetProperties(@NotNull Name name) {
        LinkedHashSet<VariableDescriptor> result = Sets.newLinkedHashSet();
        Collection<JetProperty> declarations = this.declarationProvider.getPropertyDeclarations(name);
        for (JetProperty propertyDeclaration : declarations) {
            JetScope resolutionScope = this.getScopeForMemberDeclarationResolution(propertyDeclaration);
            PropertyDescriptor propertyDescriptor = this.resolveSession.getInjector().getDescriptorResolver().resolvePropertyDescriptor((DeclarationDescriptor)this.thisDescriptor, resolutionScope, propertyDeclaration, this.resolveSession.getTrace(), DataFlowInfo.EMPTY);
            result.add(propertyDescriptor);
            this.resolveSession.getInjector().getAnnotationResolver().resolveAnnotationsArguments(propertyDescriptor, this.resolveSession.getTrace(), resolutionScope);
        }
        Collection<JetClassOrObject> classOrObjectDeclarations = this.declarationProvider.getClassOrObjectDeclarations(name);
        for (JetClassOrObject classOrObjectDeclaration : classOrObjectDeclarations) {
            if (!AbstractLazyMemberScope.declaresObjectOrEnumConstant(classOrObjectDeclaration)) continue;
            ClassDescriptor classifier = this.getObjectDescriptor(name);
            if (classifier == null) {
                throw new IllegalStateException("Object declaration " + name + " found in the DeclarationProvider " + this.declarationProvider + " but not in the scope " + this);
            }
            VariableDescriptor propertyDescriptor = this.resolveSession.getInjector().getDescriptorResolver().resolveObjectDeclaration((DeclarationDescriptor)this.thisDescriptor, classOrObjectDeclaration, classifier, this.resolveSession.getTrace());
            result.add(propertyDescriptor);
        }
        this.getNonDeclaredProperties(name, result);
        return result;
    }

    protected abstract void getNonDeclaredProperties(@NotNull Name var1, @NotNull Set<VariableDescriptor> var2);

    @Override
    @NotNull
    public Collection<ClassDescriptor> getObjectDescriptors() {
        return this.allDescriptors.compute().objects;
    }

    @Override
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        return null;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.thisDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
        return Collections.emptySet();
    }

    @Override
    public PropertyDescriptor getPropertyByFieldReference(@NotNull Name fieldName) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        return this.allDescriptors.compute().all;
    }

    @NotNull
    private AllDescriptors computeAllDescriptors() {
        AllDescriptors result = new AllDescriptors();
        for (JetDeclaration declaration : this.declarationProvider.getAllDeclarations()) {
            Name name;
            if (declaration instanceof JetEnumEntry) {
                JetEnumEntry jetEnumEntry = (JetEnumEntry)declaration;
                name = ResolveSessionUtils.safeNameForLazyResolve(jetEnumEntry);
                if (name == null) continue;
                result.all.addAll(this.getProperties(name));
                result.objects.add(this.getObjectDescriptor(name));
                continue;
            }
            if (declaration instanceof JetObjectDeclaration) {
                JetObjectDeclaration objectDeclaration = (JetObjectDeclaration)declaration;
                name = ResolveSessionUtils.safeNameForLazyResolve(objectDeclaration.getNameAsDeclaration());
                if (name == null) continue;
                result.all.addAll(this.getProperties(name));
                result.objects.add(this.getObjectDescriptor(name));
                continue;
            }
            if (declaration instanceof JetClassOrObject) {
                JetClassOrObject classOrObject = (JetClassOrObject)declaration;
                name = ResolveSessionUtils.safeNameForLazyResolve(classOrObject.getNameAsName());
                if (name == null) continue;
                result.all.addAll((Collection)this.classDescriptors.fun(name));
                continue;
            }
            if (declaration instanceof JetFunction) {
                JetFunction function = (JetFunction)declaration;
                result.all.addAll(this.getFunctions(ResolveSessionUtils.safeNameForLazyResolve(function)));
                continue;
            }
            if (declaration instanceof JetProperty) {
                JetProperty property = (JetProperty)declaration;
                result.all.addAll(this.getProperties(ResolveSessionUtils.safeNameForLazyResolve(property)));
                continue;
            }
            if (declaration instanceof JetParameter) {
                JetParameter parameter = (JetParameter)declaration;
                name = ResolveSessionUtils.safeNameForLazyResolve(parameter);
                result.all.addAll(this.getProperties(name));
                continue;
            }
            if (declaration instanceof JetTypedef || declaration instanceof JetMultiDeclaration) continue;
            throw new IllegalArgumentException("Unsupported declaration kind: " + declaration);
        }
        this.addExtraDescriptors(result.all);
        return result;
    }

    protected abstract void addExtraDescriptors(@NotNull Collection<DeclarationDescriptor> var1);

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        ReceiverParameterDescriptor receiver = this.getImplicitReceiver();
        if (receiver != null) {
            return Collections.singletonList(receiver);
        }
        return Collections.emptyList();
    }

    @Nullable
    protected abstract ReceiverParameterDescriptor getImplicitReceiver();

    public abstract String toString();

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        return this.getAllDescriptors();
    }

    private static class AllDescriptors {
        private final Collection<DeclarationDescriptor> all = Sets.newLinkedHashSet();
        private final Collection<ClassDescriptor> objects = Sets.newLinkedHashSet();

        private AllDescriptors() {
        }
    }
}

