/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.ModuleConfiguration;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeConstructorImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.error.ErrorSimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class ErrorUtils {
    private static final ModuleDescriptor ERROR_MODULE;
    private static final ClassDescriptorImpl ERROR_CLASS;
    private static final Set<ConstructorDescriptor> ERROR_CONSTRUCTOR_GROUP;
    private static final ConstructorDescriptor ERROR_CONSTRUCTOR;
    private static final JetType ERROR_PROPERTY_TYPE;
    private static final VariableDescriptor ERROR_PROPERTY;
    private static final Set<VariableDescriptor> ERROR_PROPERTY_GROUP;
    private static final JetType ERROR_PARAMETER_TYPE;

    public static boolean containsErrorType(@NotNull FunctionDescriptor function) {
        if (ErrorUtils.containsErrorType(function.getReturnType())) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameter = function.getReceiverParameter();
        if (receiverParameter != null && ErrorUtils.containsErrorType(receiverParameter.getType())) {
            return true;
        }
        for (ValueParameterDescriptor valueParameterDescriptor : function.getValueParameters()) {
            if (!ErrorUtils.containsErrorType(valueParameterDescriptor.getType())) continue;
            return true;
        }
        for (TypeParameterDescriptor typeParameterDescriptor : function.getTypeParameters()) {
            for (JetType upperBound : typeParameterDescriptor.getUpperBounds()) {
                if (!ErrorUtils.containsErrorType(upperBound)) continue;
                return true;
            }
        }
        return false;
    }

    public static JetScope createErrorScope(String debugMessage) {
        return ErrorUtils.createErrorScope(debugMessage, false);
    }

    public static JetScope createErrorScope(String debugMessage, boolean throwExceptions) {
        if (throwExceptions) {
            return new ThrowingScope(debugMessage);
        }
        return new ErrorScope(debugMessage);
    }

    private static SimpleFunctionDescriptor createErrorFunction(ErrorScope ownerScope) {
        ErrorSimpleFunctionDescriptorImpl function = new ErrorSimpleFunctionDescriptorImpl(ownerScope);
        function.initialize(null, ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, Collections.emptyList(), Collections.<ValueParameterDescriptor>emptyList(), ErrorUtils.createErrorType("<ERROR FUNCTION RETURN TYPE>"), Modality.OPEN, Visibilities.INTERNAL, false);
        return function;
    }

    public static ConstructorDescriptor createErrorConstructor(int typeParameterCount, List<JetType> positionedValueParameterTypes) {
        ConstructorDescriptorImpl r = new ConstructorDescriptorImpl(ERROR_CLASS, Collections.<AnnotationDescriptor>emptyList(), false);
        r.initialize(Collections.<TypeParameterDescriptor>emptyList(), Collections.<ValueParameterDescriptor>emptyList(), Visibilities.INTERNAL);
        r.setReturnType(ErrorUtils.createErrorType("<ERROR RETURN TYPE>"));
        return r;
    }

    @NotNull
    public static JetType createErrorType(String debugMessage) {
        return ErrorUtils.createErrorType(debugMessage, ErrorUtils.createErrorScope(debugMessage));
    }

    private static JetType createErrorType(String debugMessage, JetScope memberScope) {
        return ErrorUtils.createErrorTypeWithCustomDebugName(memberScope, "[ERROR : " + debugMessage + "]");
    }

    @NotNull
    public static JetType createErrorTypeWithCustomDebugName(String debugName) {
        return ErrorUtils.createErrorTypeWithCustomDebugName(ErrorUtils.createErrorScope(debugName), debugName);
    }

    private static JetType createErrorTypeWithCustomDebugName(JetScope memberScope, String debugName) {
        ErrorTypeConstructor constructor = new ErrorTypeConstructor(ERROR_CLASS, Collections.emptyList(), false, debugName, Collections.emptyList(), Collections.singleton(KotlinBuiltIns.getInstance().getAnyType()));
        return new ErrorTypeImpl(constructor, memberScope);
    }

    public static JetType createWrongVarianceErrorType(TypeProjection value) {
        return ErrorUtils.createErrorType(value + " is not allowed here", value.getType().getMemberScope());
    }

    public static ClassifierDescriptor getErrorClass() {
        return ERROR_CLASS;
    }

    public static boolean isError(@NotNull TypeConstructor typeConstructor) {
        return typeConstructor == ERROR_CLASS.getTypeConstructor() || typeConstructor instanceof ErrorTypeConstructor;
    }

    public static boolean isErrorType(@NotNull JetType type) {
        return type != TypeUtils.NO_EXPECTED_TYPE && !(type instanceof NamespaceType) && (type instanceof DeferredType && (((DeferredType)type).getActualType() == null || ErrorUtils.isErrorType(((DeferredType)type).getActualType())) || type instanceof ErrorTypeImpl || ErrorUtils.isError(type.getConstructor()));
    }

    public static boolean containsErrorType(@Nullable JetType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof NamespaceType) {
            return false;
        }
        if (ErrorUtils.isErrorType(type)) {
            return true;
        }
        for (TypeProjection projection : type.getArguments()) {
            if (!ErrorUtils.containsErrorType(projection.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isError(@NotNull DeclarationDescriptor candidate) {
        return candidate == ErrorUtils.getErrorClass() || candidate.getContainingDeclaration() == ErrorUtils.getErrorClass() || candidate == ERROR_MODULE;
    }

    public static ModuleDescriptor getErrorModule() {
        return ERROR_MODULE;
    }

    private ErrorUtils() {
    }

    static {
        ModuleDescriptorImpl module = new ModuleDescriptorImpl(Name.special("<ERROR MODULE>"), Collections.<ImportPath>emptyList(), PlatformToKotlinClassMap.EMPTY);
        module.setModuleConfiguration(ModuleConfiguration.EMPTY);
        ERROR_MODULE = module;
        ERROR_CLASS = new ClassDescriptorImpl((DeclarationDescriptor)ERROR_MODULE, Collections.emptyList(), Modality.OPEN, Name.special("<ERROR CLASS>")){

            @Override
            @NotNull
            public Collection<ConstructorDescriptor> getConstructors() {
                return ERROR_CONSTRUCTOR_GROUP;
            }

            @Override
            @NotNull
            public Modality getModality() {
                return Modality.OPEN;
            }

            @Override
            @NotNull
            public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
                return ERROR_CLASS;
            }
        };
        ERROR_CONSTRUCTOR_GROUP = Collections.singleton(ErrorUtils.createErrorConstructor(0, Collections.<JetType>emptyList()));
        ERROR_CONSTRUCTOR = new ConstructorDescriptorImpl(ERROR_CLASS, Collections.<AnnotationDescriptor>emptyList(), true);
        ERROR_CLASS.initialize(true, Collections.emptyList(), Collections.<JetType>emptyList(), ErrorUtils.createErrorScope("ERROR_CLASS"), ERROR_CONSTRUCTOR_GROUP, ERROR_CONSTRUCTOR, false);
        ERROR_PROPERTY_TYPE = ErrorUtils.createErrorType("<ERROR PROPERTY TYPE>");
        ERROR_PROPERTY = new PropertyDescriptorImpl(ERROR_CLASS, Collections.<AnnotationDescriptor>emptyList(), Modality.OPEN, Visibilities.INTERNAL, true, null, ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, Name.special("<ERROR PROPERTY>"), ERROR_PROPERTY_TYPE, CallableMemberDescriptor.Kind.DECLARATION);
        ERROR_PROPERTY_GROUP = Collections.singleton(ERROR_PROPERTY);
        ERROR_PARAMETER_TYPE = ErrorUtils.createErrorType("<ERROR VALUE_PARAMETER TYPE>");
    }

    private static class ErrorTypeImpl
    implements JetType {
        private final TypeConstructor constructor;
        private final JetScope memberScope;

        private ErrorTypeImpl(TypeConstructor constructor, JetScope memberScope) {
            this.constructor = constructor;
            this.memberScope = memberScope;
        }

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            return this.constructor;
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            return Collections.emptyList();
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        @NotNull
        public JetScope getMemberScope() {
            return this.memberScope;
        }

        @Override
        public List<AnnotationDescriptor> getAnnotations() {
            return Collections.emptyList();
        }

        public String toString() {
            return this.constructor.toString();
        }
    }

    private static final class ErrorTypeConstructor
    extends TypeConstructorImpl {
        private ErrorTypeConstructor(@Nullable ClassifierDescriptor classifierDescriptor, @NotNull List<AnnotationDescriptor> annotations, boolean sealed, @NotNull String debugName, @NotNull List<? extends TypeParameterDescriptor> parameters, @NotNull Collection<JetType> supertypes) {
            super(classifierDescriptor, annotations, sealed, debugName, parameters, supertypes);
        }
    }

    private static class ThrowingScope
    implements JetScope {
        private final String debugMessage;

        private ThrowingScope(String message) {
            this.debugMessage = message;
        }

        @Override
        @Nullable
        public ClassifierDescriptor getClassifier(@NotNull Name name) {
            throw new IllegalStateException();
        }

        @Override
        @Nullable
        public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<ClassDescriptor> getObjectDescriptors() {
            throw new IllegalStateException();
        }

        @Override
        @Nullable
        public NamespaceDescriptor getNamespace(@NotNull Name name) {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
            throw new IllegalStateException();
        }

        @Override
        @Nullable
        public VariableDescriptor getLocalVariable(@NotNull Name name) {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            return ERROR_MODULE;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
            throw new IllegalStateException();
        }

        @Override
        @Nullable
        public PropertyDescriptor getPropertyByFieldReference(@NotNull Name fieldName) {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getAllDescriptors() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
            throw new IllegalStateException();
        }

        public String toString() {
            return "ThrowingScope{" + this.debugMessage + '}';
        }
    }

    public static class ErrorScope
    implements JetScope {
        private final String debugMessage;

        private ErrorScope(String debugMessage) {
            this.debugMessage = debugMessage;
        }

        @Override
        public ClassifierDescriptor getClassifier(@NotNull Name name) {
            return ERROR_CLASS;
        }

        @Override
        public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
            return ERROR_CLASS;
        }

        @NotNull
        public Set<ClassDescriptor> getObjectDescriptors() {
            return Collections.emptySet();
        }

        @NotNull
        public Set<VariableDescriptor> getProperties(@NotNull Name name) {
            return ERROR_PROPERTY_GROUP;
        }

        @Override
        public VariableDescriptor getLocalVariable(@NotNull Name name) {
            return ERROR_PROPERTY;
        }

        @Override
        public NamespaceDescriptor getNamespace(@NotNull Name name) {
            return null;
        }

        @Override
        @NotNull
        public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
            return Collections.emptyList();
        }

        @NotNull
        public Set<FunctionDescriptor> getFunctions(@NotNull Name name) {
            return Collections.singleton(ErrorUtils.createErrorFunction(this));
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            return ERROR_MODULE;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getDeclarationsByLabel(LabelName labelName) {
            return Collections.emptyList();
        }

        @Override
        public PropertyDescriptor getPropertyByFieldReference(@NotNull Name fieldName) {
            return null;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getAllDescriptors() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
            return Collections.emptyList();
        }

        public String toString() {
            return "ErrorScope{" + this.debugMessage + '}';
        }
    }
}

