/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Named;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.k2js.translate.context.AliasingContext;
import org.jetbrains.k2js.translate.context.DynamicContext;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.StaticContext;
import org.jetbrains.k2js.translate.context.TemporaryConstVariable;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.UsageTracker;
import org.jetbrains.k2js.translate.declaration.ClassDeclarationTranslator;
import org.jetbrains.k2js.translate.expression.LiteralFunctionTranslator;
import org.jetbrains.k2js.translate.intrinsic.Intrinsics;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public class TranslationContext {
    @NotNull
    private final DynamicContext dynamicContext;
    @NotNull
    private final StaticContext staticContext;
    @NotNull
    private final AliasingContext aliasingContext;
    @Nullable
    private final UsageTracker usageTracker;
    private final HashMap<JsExpression, TemporaryConstVariable> expressionToTempConstVariableCache = new HashMap();

    @NotNull
    public static TranslationContext rootContext(@NotNull StaticContext staticContext, JsFunction rootFunction) {
        DynamicContext rootDynamicContext = DynamicContext.rootContext(rootFunction.getScope(), rootFunction.getBody());
        AliasingContext rootAliasingContext = AliasingContext.getCleanContext();
        return new TranslationContext(staticContext, rootDynamicContext, rootAliasingContext, null);
    }

    public boolean isEcma5() {
        return this.staticContext.isEcma5();
    }

    private TranslationContext(@NotNull StaticContext staticContext, @NotNull DynamicContext dynamicContext, @NotNull AliasingContext aliasingContext, @Nullable UsageTracker usageTracker) {
        this.dynamicContext = dynamicContext;
        this.staticContext = staticContext;
        this.aliasingContext = aliasingContext;
        this.usageTracker = usageTracker;
    }

    private TranslationContext(@NotNull TranslationContext parent, @NotNull AliasingContext aliasingContext) {
        this(parent.staticContext, parent.dynamicContext, aliasingContext, parent.usageTracker);
    }

    private TranslationContext(@NotNull TranslationContext parent, @NotNull JsFunction fun, @NotNull AliasingContext aliasingContext, @Nullable UsageTracker usageTracker) {
        this(parent.staticContext, DynamicContext.newContext(fun.getScope(), fun.getBody()), aliasingContext, usageTracker == null ? parent.usageTracker : usageTracker);
    }

    @Nullable
    public UsageTracker usageTracker() {
        return this.usageTracker;
    }

    public DynamicContext dynamicContext() {
        return this.dynamicContext;
    }

    @NotNull
    public TranslationContext contextWithScope(@NotNull JsFunction fun) {
        return new TranslationContext(this, fun, this.aliasingContext, null);
    }

    @NotNull
    private TranslationContext contextWithScope(@NotNull JsScope newScope, @NotNull JsBlock block, @NotNull AliasingContext aliasingContext, @Nullable UsageTracker usageTracker) {
        return new TranslationContext(this.staticContext, DynamicContext.newContext(newScope, block), aliasingContext, usageTracker);
    }

    @NotNull
    public TranslationContext newFunctionBody(@NotNull JsFunction fun, @Nullable AliasingContext aliasingContext, @Nullable UsageTracker usageTracker) {
        return new TranslationContext(this, fun, aliasingContext == null ? new AliasingContext(this.aliasingContext) : aliasingContext, usageTracker);
    }

    @NotNull
    public TranslationContext innerBlock(@NotNull JsBlock block) {
        return new TranslationContext(this.staticContext, this.dynamicContext.innerBlock(block), this.aliasingContext, this.usageTracker);
    }

    @NotNull
    public TranslationContext newDeclaration(@NotNull DeclarationDescriptor descriptor) {
        return this.contextWithScope(this.getScopeForDescriptor(descriptor), this.getBlockForDescriptor(descriptor), this.aliasingContext, this.usageTracker);
    }

    @NotNull
    public TranslationContext innerContextWithThisAliased(@NotNull DeclarationDescriptor correspondingDescriptor, @NotNull JsNameRef alias) {
        return new TranslationContext(this, this.aliasingContext.inner(correspondingDescriptor, alias));
    }

    @NotNull
    public TranslationContext innerContextWithAliasesForExpressions(@NotNull Map<JetExpression, JsName> aliases) {
        return new TranslationContext(this, this.aliasingContext.withExpressionsAliased(aliases));
    }

    @NotNull
    public TranslationContext innerContextWithDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsExpression> aliases) {
        return new TranslationContext(this, this.aliasingContext.withDescriptorsAliased(aliases));
    }

    @NotNull
    public JsBlock getBlockForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor instanceof CallableDescriptor) {
            return this.getFunctionObject((CallableDescriptor)descriptor).getBody();
        }
        return new JsBlock();
    }

    @NotNull
    public BindingContext bindingContext() {
        return this.staticContext.getBindingContext();
    }

    @NotNull
    public JsScope getScopeForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        return this.staticContext.getScopeForDescriptor(descriptor);
    }

    @NotNull
    public JsName getNameForElement(@NotNull PsiElement element) {
        DeclarationDescriptor descriptor = BindingUtils.getDescriptorForElement(this.bindingContext(), element);
        return this.getNameForDescriptor(descriptor);
    }

    @NotNull
    public JsName getNameForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        return this.staticContext.getNameForDescriptor(descriptor);
    }

    @NotNull
    public JsStringLiteral nameToLiteral(@NotNull Named named) {
        return this.program().getStringLiteral(named.getName().asString());
    }

    @NotNull
    public JsNameRef getQualifiedReference(@NotNull DeclarationDescriptor descriptor) {
        return this.staticContext.getQualifiedReference(descriptor);
    }

    @Nullable
    public JsNameRef getQualifierForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        return this.staticContext.getQualifierForDescriptor(descriptor);
    }

    @NotNull
    public TemporaryVariable declareTemporary(@Nullable JsExpression initExpression) {
        return this.dynamicContext.declareTemporary(initExpression);
    }

    @NotNull
    public TemporaryConstVariable getOrDeclareTemporaryConstVariable(@NotNull JsExpression expression) {
        TemporaryConstVariable tempVar = this.expressionToTempConstVariableCache.get(expression);
        if (tempVar == null) {
            TemporaryVariable tmpVar = this.declareTemporary(expression);
            tempVar = new TemporaryConstVariable(tmpVar.name(), tmpVar.assignmentExpression());
            this.expressionToTempConstVariableCache.put(expression, tempVar);
            this.expressionToTempConstVariableCache.put(tmpVar.assignmentExpression(), tempVar);
        }
        return tempVar;
    }

    public void associateExpressionToLazyValue(JsExpression expression, TemporaryConstVariable temporaryConstVariable) {
        assert (expression == temporaryConstVariable.assignmentExpression());
        this.expressionToTempConstVariableCache.put(expression, temporaryConstVariable);
    }

    @NotNull
    public Namer namer() {
        return this.staticContext.getNamer();
    }

    @NotNull
    public Intrinsics intrinsics() {
        return this.staticContext.getIntrinsics();
    }

    @NotNull
    public JsProgram program() {
        return this.staticContext.getProgram();
    }

    @NotNull
    public JsScope scope() {
        return this.dynamicContext.getScope();
    }

    @NotNull
    public AliasingContext aliasingContext() {
        return this.aliasingContext;
    }

    @NotNull
    public LiteralFunctionTranslator literalFunctionTranslator() {
        return this.staticContext.getLiteralFunctionTranslator();
    }

    @NotNull
    public ClassDeclarationTranslator classDeclarationTranslator() {
        return this.staticContext.getClassDeclarationTranslator();
    }

    @NotNull
    public JsFunction getFunctionObject(@NotNull CallableDescriptor descriptor) {
        return this.staticContext.getFunctionWithScope(descriptor);
    }

    public void addStatementToCurrentBlock(@NotNull JsStatement statement) {
        this.dynamicContext.jsBlock().getStatements().add(statement);
    }

    @Nullable
    public JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (this.usageTracker != null) {
            this.usageTracker.triggerUsed(descriptor);
        }
        return this.aliasingContext.getAliasForDescriptor(descriptor);
    }

    @NotNull
    public JsExpression getThisObject(@NotNull DeclarationDescriptor descriptor) {
        JsExpression alias;
        DeclarationDescriptor effectiveDescriptor;
        if (descriptor instanceof CallableDescriptor) {
            effectiveDescriptor = JsDescriptorUtils.getExpectedReceiverDescriptor((CallableDescriptor)descriptor);
            assert (effectiveDescriptor != null);
        } else {
            effectiveDescriptor = descriptor;
        }
        if (this.usageTracker != null) {
            this.usageTracker.triggerUsed(effectiveDescriptor);
        }
        return (alias = this.aliasingContext.getAliasForDescriptor(effectiveDescriptor)) == null ? JsLiteral.THIS : alias;
    }
}

