/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsDocComment;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVars;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.NamespaceTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class NamespaceDeclarationTranslator
extends AbstractTranslator {
    private final Iterable<JetFile> files;
    private final Map<NamespaceDescriptor, NamespaceTranslator> descriptorToTranslator = new LinkedHashMap<NamespaceDescriptor, NamespaceTranslator>();

    public static List<JsStatement> translateFiles(@NotNull Collection<JetFile> files, @NotNull TranslationContext context) {
        return new NamespaceDeclarationTranslator(files, context).translate();
    }

    private NamespaceDeclarationTranslator(@NotNull Iterable<JetFile> files, @NotNull TranslationContext context) {
        super(context);
        this.files = files;
    }

    @NotNull
    private List<JsStatement> translate() {
        List<JsStatement> result;
        THashMap<NamespaceDescriptor, List<JsExpression>> descriptorToDefineInvocation = new THashMap<NamespaceDescriptor, List<JsExpression>>();
        JsObjectLiteral rootNamespaceDefinition = null;
        for (JetFile file : this.files) {
            NamespaceDescriptor descriptor = this.context().bindingContext().get(BindingContext.FILE_TO_NAMESPACE, file);
            assert (descriptor != null);
            NamespaceTranslator translator = this.descriptorToTranslator.get(descriptor);
            if (translator == null) {
                if (rootNamespaceDefinition == null) {
                    rootNamespaceDefinition = this.getRootPackage(descriptorToDefineInvocation, descriptor);
                }
                translator = new NamespaceTranslator(descriptor, descriptorToDefineInvocation, this.context());
                this.descriptorToTranslator.put(descriptor, translator);
            }
            translator.translate(file);
        }
        if (rootNamespaceDefinition == null) {
            return Collections.emptyList();
        }
        JsVars vars = new JsVars(true);
        if (this.context().isEcma5()) {
            result = Collections.singletonList(vars);
        } else {
            result = new ArrayList<JsVars>();
            result.add(vars);
        }
        this.context().classDeclarationTranslator().generateDeclarations();
        for (NamespaceTranslator translator : this.descriptorToTranslator.values()) {
            translator.add(descriptorToDefineInvocation, result);
        }
        vars.addIfHasInitializer(this.context().classDeclarationTranslator().getDeclaration());
        vars.addIfHasInitializer(this.getDeclaration(rootNamespaceDefinition));
        return result;
    }

    private JsObjectLiteral getRootPackage(Map<NamespaceDescriptor, List<JsExpression>> descriptorToDefineInvocation, NamespaceDescriptor descriptor) {
        NamespaceDescriptor rootNamespace = descriptor;
        while (DescriptorUtils.isTopLevelDeclaration(rootNamespace)) {
            rootNamespace = (NamespaceDescriptor)rootNamespace.getContainingDeclaration();
        }
        JsObjectLiteral rootNamespaceDefinition = new JsObjectLiteral(true);
        descriptorToDefineInvocation.put(rootNamespace, NamespaceDeclarationTranslator.createDefineInvocation(rootNamespace, null, rootNamespaceDefinition, this.context()));
        return rootNamespaceDefinition;
    }

    static List<JsExpression> createDefineInvocation(@NotNull NamespaceDescriptor descriptor, @Nullable JsExpression initializer, @NotNull JsObjectLiteral members, @NotNull TranslationContext context) {
        if (context.isEcma5()) {
            return Arrays.asList(initializer == null ? JsLiteral.NULL : initializer, new JsDocComment("lends", context.getQualifiedReference(descriptor)), members);
        }
        return Collections.singletonList(members);
    }

    private JsVars.JsVar getDeclaration(@NotNull JsObjectLiteral rootNamespaceDefinition) {
        JsExpressionImpl packageMapValue = this.context().isEcma5() ? new JsInvocation((JsExpression)JsAstUtils.CREATE_OBJECT, JsLiteral.NULL, new JsDocComment("lends", Namer.getRootNamespaceName()), rootNamespaceDefinition) : rootNamespaceDefinition;
        return new JsVars.JsVar(this.context().scope().declareName(Namer.getRootNamespaceName()), packageMapValue);
    }
}

