/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.k2js.translate.LabelGenerator;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.DeclarationBodyVisitor;
import org.jetbrains.k2js.translate.declaration.NamespaceDeclarationTranslator;
import org.jetbrains.k2js.translate.expression.LiteralFunctionTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.initializer.InitializerUtils;
import org.jetbrains.k2js.translate.initializer.InitializerVisitor;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

final class NamespaceTranslator
extends AbstractTranslator {
    @NotNull
    private final NamespaceDescriptor descriptor;
    private final FileDeclarationVisitor visitor;
    private final NotNullLazyValue<Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression>> definitionPlace;

    NamespaceTranslator(final @NotNull NamespaceDescriptor descriptor, final @NotNull Map<NamespaceDescriptor, List<JsExpression>> descriptorToDefineInvocation, @NotNull TranslationContext context) {
        super(context.newDeclaration(descriptor));
        this.descriptor = descriptor;
        this.visitor = new FileDeclarationVisitor();
        this.definitionPlace = new NotNullLazyValue<Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression>>(){

            @Override
            @NotNull
            public Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression> compute() {
                List defineInvocation = (List)descriptorToDefineInvocation.get(descriptor);
                if (defineInvocation == null) {
                    defineInvocation = NamespaceTranslator.this.createDefinitionPlace(null, descriptorToDefineInvocation);
                }
                return LiteralFunctionTranslator.createPlace(NamespaceTranslator.this.getListFromPlace(defineInvocation), NamespaceTranslator.this.context().getQualifiedReference(descriptor));
            }
        };
    }

    public void translate(JetFile file) {
        this.context().literalFunctionTranslator().setDefinitionPlace(this.definitionPlace);
        for (JetDeclaration declaration : file.getDeclarations()) {
            if (AnnotationsUtils.isPredefinedObject(BindingUtils.getDescriptorForElement(this.bindingContext(), declaration))) continue;
            declaration.accept(this.visitor, this.context());
        }
        this.context().literalFunctionTranslator().setDefinitionPlace(null);
    }

    private List<JsExpression> createDefinitionPlace(@Nullable JsExpression initializer, Map<NamespaceDescriptor, List<JsExpression>> descriptorToDefineInvocation) {
        List<JsExpression> place = NamespaceDeclarationTranslator.createDefineInvocation(this.descriptor, initializer, new JsObjectLiteral(this.visitor.getResult(), true), this.context());
        descriptorToDefineInvocation.put(this.descriptor, place);
        this.addToParent((NamespaceDescriptor)this.descriptor.getContainingDeclaration(), this.getEntry(this.descriptor, place), descriptorToDefineInvocation);
        return place;
    }

    public void add(@NotNull Map<NamespaceDescriptor, List<JsExpression>> descriptorToDefineInvocation, @NotNull List<JsStatement> initializers) {
        JsFunction initializer;
        if (this.visitor.initializerStatements.isEmpty()) {
            initializer = null;
        } else {
            initializer = this.visitor.initializer;
            if (!this.context().isEcma5()) {
                initializers.add(new JsInvocation((JsExpression)new JsNameRef("call", (JsExpression)initializer), (JsExpression)this.context().getQualifiedReference(this.descriptor)).makeStmt());
            }
        }
        List<JsExpression> defineInvocation = descriptorToDefineInvocation.get(this.descriptor);
        if (defineInvocation == null) {
            if (initializer != null || !this.visitor.getResult().isEmpty()) {
                this.createDefinitionPlace(initializer, descriptorToDefineInvocation);
            }
        } else {
            List<JsPropertyInitializer> listFromPlace;
            if (this.context().isEcma5() && initializer != null) {
                assert (defineInvocation.get(0) == JsLiteral.NULL);
                defineInvocation.set(0, initializer);
            }
            if ((listFromPlace = this.getListFromPlace(defineInvocation)) != this.visitor.getResult()) {
                listFromPlace.addAll(this.visitor.getResult());
            }
        }
    }

    private List<JsPropertyInitializer> getListFromPlace(List<JsExpression> defineInvocation) {
        return ((JsObjectLiteral)defineInvocation.get(this.context().isEcma5() ? 2 : 0)).getPropertyInitializers();
    }

    private JsPropertyInitializer getEntry(@NotNull NamespaceDescriptor descriptor, List<JsExpression> defineInvocation) {
        return new JsPropertyInitializer(this.context().getNameForDescriptor(descriptor).makeRef(), new JsInvocation(this.context().namer().packageDefinitionMethodReference(), defineInvocation));
    }

    private boolean addEntryIfParentExists(NamespaceDescriptor parentDescriptor, JsPropertyInitializer entry, Map<NamespaceDescriptor, List<JsExpression>> descriptorToDeclarationPlace) {
        List<JsExpression> parentDefineInvocation = descriptorToDeclarationPlace.get(parentDescriptor);
        if (parentDefineInvocation != null) {
            this.getListFromPlace(parentDefineInvocation).add(entry);
            return true;
        }
        return false;
    }

    private void addToParent(NamespaceDescriptor parentDescriptor, JsPropertyInitializer entry, Map<NamespaceDescriptor, List<JsExpression>> descriptorToDefineInvocation) {
        while (!this.addEntryIfParentExists(parentDescriptor, entry, descriptorToDefineInvocation)) {
            JsObjectLiteral members = new JsObjectLiteral(new SmartList<JsPropertyInitializer>(entry), true);
            List<JsExpression> defineInvocation = NamespaceDeclarationTranslator.createDefineInvocation(parentDescriptor, null, members, this.context());
            entry = this.getEntry(parentDescriptor, defineInvocation);
            descriptorToDefineInvocation.put(parentDescriptor, defineInvocation);
            parentDescriptor = (NamespaceDescriptor)parentDescriptor.getContainingDeclaration();
        }
    }

    private class FileDeclarationVisitor
    extends DeclarationBodyVisitor {
        private final JsFunction initializer;
        private final TranslationContext initializerContext;
        private final List<JsStatement> initializerStatements;
        private final InitializerVisitor initializerVisitor;

        private FileDeclarationVisitor() {
            this.initializer = JsAstUtils.createFunctionWithEmptyBody(NamespaceTranslator.this.context().scope());
            this.initializerContext = NamespaceTranslator.this.context().contextWithScope(this.initializer);
            this.initializerStatements = this.initializer.getBody().getStatements();
            this.initializerVisitor = new InitializerVisitor(this.initializerStatements);
        }

        @Override
        public Void visitClass(@NotNull JetClass declaration, @NotNull TranslationContext context) {
            JsPropertyInitializer entry = context.classDeclarationTranslator().translate(declaration, context);
            if (entry != null) {
                this.result.add(entry);
            }
            return null;
        }

        @Override
        public Void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration, @NotNull TranslationContext context) {
            InitializerUtils.generate(declaration, this.initializerStatements, context);
            return null;
        }

        @Override
        public Void visitProperty(@NotNull JetProperty property, @NotNull TranslationContext context) {
            JsStatement delegate;
            super.visitProperty(property, context);
            JetExpression initializer = property.getInitializer();
            if (initializer != null) {
                JsExpression value = Translation.translateAsExpression(initializer, this.initializerContext);
                PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptor(context.bindingContext(), property);
                if (value instanceof JsLiteral) {
                    this.result.add(new JsPropertyInitializer(context.getNameForDescriptor(propertyDescriptor).makeRef(), NamespaceTranslator.this.context().isEcma5() ? JsAstUtils.createPropertyDataDescriptor(propertyDescriptor, value) : value));
                } else {
                    this.initializerStatements.add(InitializerUtils.generateInitializerForProperty(context, propertyDescriptor, value));
                }
            }
            if ((delegate = InitializerUtils.generateInitializerForDelegate(context, property)) != null) {
                this.initializerStatements.add(delegate);
            }
            return null;
        }

        @Override
        public Void visitAnonymousInitializer(@NotNull JetClassInitializer expression, @NotNull TranslationContext context) {
            expression.accept(this.initializerVisitor, this.initializerContext);
            return null;
        }
    }
}

