/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions;

import com.google.common.collect.Lists;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.NumberConversionFIF;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.PrimitiveBinaryOperationFIF;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.PrimitiveUnaryOperationFIF;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.StringOperationFIF;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.TopLevelFIF;

public final class FunctionIntrinsics {
    @NotNull
    private final Map<FunctionDescriptor, FunctionIntrinsic> intrinsicCache = new THashMap<FunctionDescriptor, FunctionIntrinsic>();
    @NotNull
    private final List<FunctionIntrinsicFactory> factories = Lists.newArrayList();

    public FunctionIntrinsics() {
        this.registerFactories();
    }

    private void registerFactories() {
        this.register(PrimitiveUnaryOperationFIF.INSTANCE);
        this.register(PrimitiveBinaryOperationFIF.INSTANCE);
        this.register(StringOperationFIF.INSTANCE);
        this.register(ArrayFIF.INSTANCE);
        this.register(TopLevelFIF.INSTANCE);
        this.register(NumberConversionFIF.INSTANCE);
    }

    private void register(@NotNull FunctionIntrinsicFactory instance) {
        this.factories.add(instance);
    }

    @NotNull
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor) {
        FunctionIntrinsic intrinsic = this.lookUpCache(descriptor);
        if (intrinsic != null) {
            return intrinsic;
        }
        intrinsic = this.computeAndCacheIntrinsic(descriptor);
        return intrinsic;
    }

    @Nullable
    private FunctionIntrinsic lookUpCache(@NotNull FunctionDescriptor descriptor) {
        return this.intrinsicCache.get(descriptor);
    }

    @NotNull
    private FunctionIntrinsic computeAndCacheIntrinsic(@NotNull FunctionDescriptor descriptor) {
        FunctionIntrinsic result = this.computeIntrinsic(descriptor);
        this.intrinsicCache.put(descriptor, result);
        return result;
    }

    @NotNull
    private FunctionIntrinsic computeIntrinsic(@NotNull FunctionDescriptor descriptor) {
        for (FunctionIntrinsicFactory factory : this.factories) {
            FunctionIntrinsic intrinsic = factory.getIntrinsic(descriptor);
            if (intrinsic == null) continue;
            return intrinsic;
        }
        return FunctionIntrinsic.NO_INTRINSIC;
    }
}

