/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.k2js.translate.operation.AssignmentTranslator;
import org.jetbrains.k2js.translate.operation.CompareToTranslator;
import org.jetbrains.k2js.translate.operation.OperatorTable;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class BinaryOperationTranslator
extends AbstractTranslator {
    @NotNull
    private final JetBinaryExpression expression;
    @Nullable
    private final FunctionDescriptor operationDescriptor;

    @NotNull
    public static JsExpression translate(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        JsExpression jsExpression = new BinaryOperationTranslator(expression, context).translate();
        return JsAstUtils.source(jsExpression, expression);
    }

    @NotNull
    static JsExpression translateAsOverloadedCall(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        JsExpression jsExpression = new BinaryOperationTranslator(expression, context).translateAsOverloadedBinaryOperation();
        return JsAstUtils.source(jsExpression, expression);
    }

    private BinaryOperationTranslator(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        super(context);
        this.expression = expression;
        this.operationDescriptor = BindingUtils.getFunctionDescriptorForOperationExpression(this.bindingContext(), expression);
    }

    @NotNull
    private JsExpression translate() {
        BinaryOperationIntrinsic intrinsic = this.getIntrinsicForExpression();
        if (intrinsic != null) {
            return this.applyIntrinsic(intrinsic);
        }
        if (PsiUtils.getOperationToken(this.expression).equals(JetTokens.ELVIS)) {
            return TranslationUtils.notNullConditional(TranslationUtils.translateLeftExpression(this.context(), this.expression), TranslationUtils.translateRightExpression(this.context(), this.expression), this.context());
        }
        if (AssignmentTranslator.isAssignmentOperator(this.expression)) {
            return AssignmentTranslator.translate(this.expression, this.context());
        }
        if (this.isNotOverloadable()) {
            return this.translateAsUnOverloadableBinaryOperation();
        }
        if (CompareToTranslator.isCompareToCall(this.expression, this.context())) {
            return CompareToTranslator.translate(this.expression, this.context());
        }
        assert (this.operationDescriptor != null) : "Overloadable operations must have not null descriptor";
        return this.translateAsOverloadedBinaryOperation();
    }

    @Nullable
    private BinaryOperationIntrinsic getIntrinsicForExpression() {
        return this.context().intrinsics().getBinaryOperationIntrinsics().getIntrinsic(this.expression, this.context());
    }

    @NotNull
    private JsExpression applyIntrinsic(@NotNull BinaryOperationIntrinsic intrinsic) {
        return intrinsic.apply(this.expression, TranslationUtils.translateLeftExpression(this.context(), this.expression), TranslationUtils.translateRightExpression(this.context(), this.expression), this.context());
    }

    private boolean isNotOverloadable() {
        return this.operationDescriptor == null;
    }

    @NotNull
    private JsExpression translateAsUnOverloadableBinaryOperation() {
        JetToken token = PsiUtils.getOperationToken(this.expression);
        JsBinaryOperator operator = OperatorTable.getBinaryOperator(token);
        assert (OperatorConventions.NOT_OVERLOADABLE.contains(token));
        JsExpression left = TranslationUtils.translateLeftExpression(this.context(), this.expression);
        JsExpression right = TranslationUtils.translateRightExpression(this.context(), this.expression);
        return new JsBinaryOperation(operator, left, right);
    }

    @NotNull
    private JsExpression translateAsOverloadedBinaryOperation() {
        CallBuilder callBuilder = this.setReceiverAndArguments();
        ResolvedCall<?> resolvedCall = BindingUtils.getResolvedCall(this.bindingContext(), this.expression.getOperationReference());
        JsExpression result = callBuilder.resolvedCall(resolvedCall).type(CallType.NORMAL).translate();
        return this.mayBeWrapWithNegation(result);
    }

    @NotNull
    private CallBuilder setReceiverAndArguments() {
        CallBuilder callBuilder = CallBuilder.build(this.context());
        JsExpression leftExpression = TranslationUtils.translateLeftExpression(this.context(), this.expression);
        JsExpression rightExpression = TranslationUtils.translateRightExpression(this.context(), this.expression);
        if (PsiUtils.isInOrNotInOperation(this.expression)) {
            return callBuilder.receiver(rightExpression).args(leftExpression);
        }
        return callBuilder.receiver(leftExpression).args(rightExpression);
    }

    @NotNull
    private JsExpression mayBeWrapWithNegation(@NotNull JsExpression result) {
        if (PsiUtils.isNegatedOperation(this.expression)) {
            return JsAstUtils.not(result);
        }
        return result;
    }
}

