/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;

public class ClassObjectAccessTranslator
extends AbstractTranslator
implements CachedAccessTranslator {
    @NotNull
    private final JsExpression referenceToClassObject;

    @NotNull
    static ClassObjectAccessTranslator newInstance(@NotNull JetSimpleNameExpression expression, @NotNull TranslationContext context) {
        DeclarationDescriptor referenceDescriptor = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression);
        assert (referenceDescriptor != null) : "JetSimpleName expression must reference a descriptor " + expression.getText();
        return new ClassObjectAccessTranslator(referenceDescriptor, context);
    }

    static boolean isClassObjectReference(@NotNull JetReferenceExpression expression, @NotNull TranslationContext context) {
        DeclarationDescriptor descriptor = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression);
        return descriptor instanceof ClassDescriptor && !AnnotationsUtils.isNativeObject(descriptor);
    }

    private ClassObjectAccessTranslator(@NotNull DeclarationDescriptor descriptor, @NotNull TranslationContext context) {
        super(context);
        this.referenceToClassObject = Namer.getClassObjectAccessor(ReferenceTranslator.translateAsFQReference(descriptor, this.context()));
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        return this.referenceToClassObject;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression toSetTo) {
        throw new IllegalStateException("Class object can't set");
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        return this;
    }

    @Override
    @NotNull
    public List<TemporaryVariable> declaredTemporaries() {
        return Collections.emptyList();
    }
}

