/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils.mutator;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.mutator.Mutator;

public final class LastExpressionMutator {
    @NotNull
    private final Mutator mutator;

    public static JsStatement mutateLastExpression(@NotNull JsNode node, @NotNull Mutator mutator) {
        return JsAstUtils.convertToStatement(new LastExpressionMutator(mutator).apply(node));
    }

    private LastExpressionMutator(@NotNull Mutator mutator) {
        this.mutator = mutator;
    }

    @NotNull
    private JsNode apply(@NotNull JsNode node) {
        if (node instanceof JsBlock) {
            return this.applyToBlock((JsBlock)node);
        }
        if (node instanceof JsIf) {
            return this.applyToIf((JsIf)node);
        }
        if (node instanceof JsExpressionStatement) {
            return this.applyToStatement((JsExpressionStatement)node);
        }
        return this.mutator.mutate(node);
    }

    @NotNull
    private JsNode applyToStatement(@NotNull JsExpressionStatement node) {
        return JsAstUtils.convertToStatement(this.apply(node.getExpression()));
    }

    @NotNull
    private JsNode applyToIf(@NotNull JsIf node) {
        node.setThenStatement(JsAstUtils.convertToStatement(this.apply(node.getThenStatement())));
        JsStatement elseStmt = node.getElseStatement();
        if (elseStmt != null) {
            node.setElseStatement(JsAstUtils.convertToStatement(this.apply(elseStmt)));
        }
        return node;
    }

    @NotNull
    private JsNode applyToBlock(@NotNull JsBlock node) {
        List<JsStatement> statements = node.getStatements();
        if (statements.isEmpty()) {
            return node;
        }
        int size = statements.size();
        statements.set(size - 1, JsAstUtils.convertToStatement(this.apply(statements.get(size - 1))));
        return node;
    }
}

