/*
 * Copyright 2010-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.jet.lang.resolve.java.scope;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.scopes.ChainedScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

import java.util.Collection;

public class JavaFullPackageScope extends ChainedScope implements JavaPackageFragmentScope {
    private final JavaPurePackageScope purePackageScope;

    public JavaFullPackageScope(
            @NotNull PackageFragmentDescriptor packageFragment,
            @NotNull JetScope kotlinPackageScope,
            @NotNull JavaPurePackageScope purePackageScope
    ) {
        super(packageFragment, kotlinPackageScope, purePackageScope);
        this.purePackageScope = purePackageScope;
    }

    @Override
    public Collection<FqName> getSubPackages() {
        return purePackageScope.getSubPackages();
    }
}
