/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageExtension<T>
extends KeyedExtensionCollector<T, Language> {
    private final T myDefaultImplementation;
    private final Key<T> IN_LANGUAGE_CACHE;

    public LanguageExtension(@NonNls String epName) {
        this(epName, null);
    }

    public LanguageExtension(@NonNls String epName, @Nullable T defaultImplementation) {
        super(epName);
        this.myDefaultImplementation = defaultImplementation;
        this.IN_LANGUAGE_CACHE = Key.create("EXTENSIONS_IN_LANGUAGE_" + epName);
    }

    @Override
    protected String keyToString(Language key) {
        return key.getID();
    }

    public T forLanguage(@NotNull Language l) {
        Language base;
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/LanguageExtension", "forLanguage"));
        }
        T cached = l.getUserData(this.IN_LANGUAGE_CACHE);
        if (cached != null) {
            return cached;
        }
        List extensions = this.forKey(l);
        Object result = extensions.isEmpty() ? ((base = l.getBaseLanguage()) == null ? this.myDefaultImplementation : this.forLanguage(base)) : extensions.get(0);
        if (result == null) {
            return null;
        }
        result = l.putUserDataIfAbsent(this.IN_LANGUAGE_CACHE, result);
        return result;
    }

    @NotNull
    public List<T> allForLanguage(Language l) {
        Language base;
        List list = this.forKey(l);
        if (list.isEmpty() && (base = l.getBaseLanguage()) != null) {
            List<T> list2 = this.allForLanguage(base);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageExtension", "allForLanguage"));
            }
            return list2;
        }
        List list3 = list;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageExtension", "allForLanguage"));
        }
        return list3;
    }

    protected T getDefaultImplementation() {
        return this.myDefaultImplementation;
    }

    protected Key<T> getLanguageCache() {
        return this.IN_LANGUAGE_CACHE;
    }
}

