/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProvider;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.ClassExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemPresentationProviders
extends ClassExtension<ItemPresentationProvider> {
    public static final ItemPresentationProviders INSTANCE = new ItemPresentationProviders();

    private ItemPresentationProviders() {
        super("com.intellij.itemPresentationProvider");
    }

    @Nullable
    public static <T extends NavigationItem> ItemPresentationProvider<T> getItemPresentationProvider(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/navigation/ItemPresentationProviders", "getItemPresentationProvider"));
        }
        ItemPresentationProvider provider = (ItemPresentationProvider)INSTANCE.forClass(element.getClass());
        return provider;
    }

    @Nullable
    public static ItemPresentation getItemPresentation(NavigationItem element) {
        ItemPresentationProvider<NavigationItem> provider = ItemPresentationProviders.getItemPresentationProvider(element);
        return provider != null ? provider.getPresentation(element) : null;
    }
}

