/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import com.intellij.util.containers.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextAttributesKey
implements Comparable<TextAttributesKey> {
    private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();
    private static final ConcurrentHashMap<String, TextAttributesKey> ourRegistry = new ConcurrentHashMap();
    private static final NullableLazyValue<TextAttributeKeyDefaultsProvider> ourDefaultsProvider = new VolatileNullableLazyValue<TextAttributeKeyDefaultsProvider>(){

        @Override
        @Nullable
        protected TextAttributeKeyDefaultsProvider compute() {
            return ServiceManager.getService(TextAttributeKeyDefaultsProvider.class);
        }
    };
    public String myExternalName;
    public TextAttributes myDefaultAttributes = NULL_ATTRIBUTES;
    private TextAttributesKey myFallbackAttributeKey;

    private TextAttributesKey(String externalName) {
        this.myExternalName = externalName;
    }

    public TextAttributesKey() {
    }

    @NotNull
    public static TextAttributesKey find(@NotNull @NonNls String externalName) {
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/colors/TextAttributesKey", "find"));
        }
        TextAttributesKey textAttributesKey = ourRegistry.cacheOrGet(externalName, new TextAttributesKey(externalName));
        if (textAttributesKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/TextAttributesKey", "find"));
        }
        return textAttributesKey;
    }

    public String toString() {
        return this.myExternalName;
    }

    @Override
    public int compareTo(TextAttributesKey key) {
        return this.myExternalName.compareTo(key.myExternalName);
    }

    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName) {
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/colors/TextAttributesKey", "createTextAttributesKey"));
        }
        TextAttributesKey textAttributesKey = TextAttributesKey.find(externalName);
        if (textAttributesKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/TextAttributesKey", "createTextAttributesKey"));
        }
        return textAttributesKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextAttributesKey that = (TextAttributesKey)o;
        return this.myExternalName.equals(that.myExternalName);
    }

    public int hashCode() {
        return this.myExternalName.hashCode();
    }

    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName, TextAttributesKey fallbackAttributeKey) {
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/colors/TextAttributesKey", "createTextAttributesKey"));
        }
        TextAttributesKey key = TextAttributesKey.find(externalName);
        key.setFallbackAttributeKey(fallbackAttributeKey);
        TextAttributesKey textAttributesKey = key;
        if (textAttributesKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/TextAttributesKey", "createTextAttributesKey"));
        }
        return textAttributesKey;
    }

    public void setFallbackAttributeKey(TextAttributesKey fallbackAttributeKey) {
        this.myFallbackAttributeKey = fallbackAttributeKey;
    }

    public static interface TextAttributeKeyDefaultsProvider {
    }
}

