/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.util.SegmentArrayWithData;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.text.MergingCharSequence;
import org.jetbrains.annotations.NotNull;

public class LineSet {
    private SegmentArrayWithData mySegments = new SegmentArrayWithData();
    private static boolean doTest = false;

    public int findLineIndex(int offset) {
        int lineIndex = this.mySegments.findSegmentIndex(offset);
        assert (lineIndex >= 0);
        return lineIndex;
    }

    public final int getLineStart(int index) {
        int lineStart = this.mySegments.getSegmentStart(index);
        assert (lineStart >= 0);
        return lineStart;
    }

    public final int getLineEnd(int index) {
        return this.mySegments.getSegmentEnd(index);
    }

    final int getSeparatorLength(int index) {
        return this.mySegments.getSegmentData(index) & 3;
    }

    final int getLineCount() {
        return this.mySegments.getSegmentCount();
    }

    public void documentCreated(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/LineSet", "documentCreated"));
        }
        this.initSegments(document.getCharsSequence(), false);
    }

    public void changedUpdate(DocumentEvent e1) {
        DocumentEventImpl e = (DocumentEventImpl)e1;
        if (e.isOnlyOneLineChanged() && this.mySegments.getSegmentCount() > 0) {
            this.processOneLineChange(e);
        } else {
            if (this.mySegments.getSegmentCount() == 0 || e.getStartOldIndex() >= this.mySegments.getSegmentCount() || e.getStartOldIndex() < 0) {
                this.initSegments(e.getDocument().getCharsSequence(), true);
                return;
            }
            int optimizedLineShift = e.getOptimizedLineShift();
            if (optimizedLineShift != -1) {
                this.processOptimizedMultilineInsert(e, optimizedLineShift);
            } else {
                int optimizedOldLineShift = e.getOptimizedOldLineShift();
                if (optimizedOldLineShift != -1) {
                    this.processOptimizedMultilineDelete(e, optimizedOldLineShift);
                } else {
                    this.processMultilineChange(e);
                }
            }
        }
        if (e.isWholeTextReplaced()) {
            this.clearModificationFlags();
        }
    }

    private void processOptimizedMultilineDelete(DocumentEventImpl e, int optimizedLineShift) {
        SegmentArrayWithData segments;
        int insertionPoint = e.getOffset();
        int changedLineIndex = e.getStartOldIndex();
        int lengthDiff = e.getOldLength();
        SegmentArrayWithData workingCopySegmentsForTesting = null;
        if (doTest) {
            segments = new SegmentArrayWithData();
            workingCopySegmentsForTesting = new SegmentArrayWithData();
            this.fillSegments(segments, workingCopySegmentsForTesting);
        } else {
            segments = this.mySegments;
        }
        int oldSegmentStart = segments.getSegmentStart(changedLineIndex);
        int lastChangedEnd = segments.getSegmentEnd(changedLineIndex + optimizedLineShift);
        short lastChangedData = segments.getSegmentData(changedLineIndex + optimizedLineShift);
        int newSegmentEnd = oldSegmentStart + (insertionPoint - oldSegmentStart) + (lastChangedEnd - insertionPoint - lengthDiff);
        segments.remove(changedLineIndex, changedLineIndex + optimizedLineShift);
        if (newSegmentEnd != 0) {
            segments.setElementAt(changedLineIndex, oldSegmentStart, newSegmentEnd, lastChangedData | 4);
        } else {
            segments.remove(changedLineIndex, changedLineIndex + 1);
        }
        int segmentCount = segments.getSegmentCount();
        for (int i = changedLineIndex + 1; i < segmentCount; ++i) {
            segments.setElementAt(i, segments.getSegmentStart(i) - lengthDiff, segments.getSegmentEnd(i) - lengthDiff, segments.getSegmentData(i));
        }
        if (doTest) {
            SegmentArrayWithData data = this.mySegments;
            this.mySegments = segments;
            this.addEmptyLineAtEnd();
            this.doCheckResults(workingCopySegmentsForTesting, e, data, segments);
        } else {
            this.addEmptyLineAtEnd();
        }
    }

    private void processOptimizedMultilineInsert(DocumentEventImpl e, int optimizedLineShift) {
        int i;
        SegmentArrayWithData segments;
        int insertionPoint = e.getOffset();
        int changedLineIndex = e.getStartOldIndex();
        int lengthDiff = e.getNewLength();
        LineTokenizer tokenizer = new LineTokenizer(e.getNewFragment());
        SegmentArrayWithData workingCopySegmentsForTesting = null;
        if (doTest) {
            segments = new SegmentArrayWithData();
            workingCopySegmentsForTesting = new SegmentArrayWithData();
            this.fillSegments(segments, workingCopySegmentsForTesting);
        } else {
            segments = this.mySegments;
        }
        for (i = segments.getSegmentCount() - 1; i > changedLineIndex; --i) {
            segments.setElementAt(i + optimizedLineShift, segments.getSegmentStart(i) + lengthDiff, segments.getSegmentEnd(i) + lengthDiff, segments.getSegmentData(i));
        }
        int oldSegmentEnd = segments.getSegmentEnd(changedLineIndex);
        int oldSegmentStart = segments.getSegmentStart(changedLineIndex);
        short oldSegmentData = segments.getSegmentData(changedLineIndex);
        int newChangedLineEnd = insertionPoint + tokenizer.getLineSeparatorLength() + tokenizer.getOffset() + tokenizer.getLength();
        segments.setElementAt(changedLineIndex, oldSegmentStart, newChangedLineEnd, tokenizer.getLineSeparatorLength() | 4);
        tokenizer.advance();
        i = 1;
        int lastFragmentLength = 0;
        while (!tokenizer.atEnd()) {
            lastFragmentLength = tokenizer.getLineSeparatorLength() != 0 ? 0 : tokenizer.getLength();
            segments.setElementAt(changedLineIndex + i, insertionPoint + tokenizer.getOffset(), insertionPoint + tokenizer.getOffset() + tokenizer.getLength() + tokenizer.getLineSeparatorLength(), tokenizer.getLineSeparatorLength() | 4);
            ++i;
            tokenizer.advance();
        }
        segments.setElementAt(changedLineIndex + optimizedLineShift, insertionPoint + lengthDiff - lastFragmentLength, oldSegmentEnd + lengthDiff, oldSegmentData | 4);
        if (doTest) {
            SegmentArrayWithData data = this.mySegments;
            this.mySegments = segments;
            this.addEmptyLineAtEnd();
            this.doCheckResults(workingCopySegmentsForTesting, e, data, segments);
        } else {
            this.addEmptyLineAtEnd();
        }
    }

    private void doCheckResults(SegmentArrayWithData workingCopySegmentsForTesting, DocumentEventImpl e, SegmentArrayWithData data, SegmentArrayWithData segments) {
        this.mySegments = workingCopySegmentsForTesting;
        this.processMultilineChange(e);
        this.mySegments = data;
        assert (workingCopySegmentsForTesting.getSegmentCount() == segments.getSegmentCount());
        for (int i = 0; i < segments.getSegmentCount(); ++i) {
            assert (workingCopySegmentsForTesting.getSegmentStart(i) == segments.getSegmentStart(i));
            assert (workingCopySegmentsForTesting.getSegmentEnd(i) == segments.getSegmentEnd(i));
            assert (workingCopySegmentsForTesting.getSegmentData(i) == segments.getSegmentData(i));
        }
        this.processMultilineChange(e);
    }

    private void fillSegments(SegmentArrayWithData segments, SegmentArrayWithData workingCopySegmentsForTesting) {
        for (int i = this.mySegments.getSegmentCount() - 1; i >= 0; --i) {
            segments.setElementAt(i, this.mySegments.getSegmentStart(i), this.mySegments.getSegmentEnd(i), this.mySegments.getSegmentData(i));
            workingCopySegmentsForTesting.setElementAt(i, this.mySegments.getSegmentStart(i), this.mySegments.getSegmentEnd(i), this.mySegments.getSegmentData(i));
        }
    }

    private void processMultilineChange(DocumentEventImpl e) {
        int offset2;
        int oldEndLine;
        int offset = e.getOffset();
        CharSequence newString = e.getNewFragment();
        CharSequence chars = e.getDocument().getCharsSequence();
        int oldStartLine = e.getStartOldIndex();
        int offset1 = this.getLineStart(oldStartLine);
        if (offset1 != offset) {
            CharSequence prefix = chars.subSequence(offset1, offset);
            newString = new MergingCharSequence(prefix, newString);
        }
        if ((oldEndLine = this.findLineIndex(e.getOffset() + e.getOldLength())) < 0) {
            oldEndLine = this.getLineCount() - 1;
        }
        if ((offset2 = this.getLineEnd(oldEndLine)) != offset + e.getOldLength()) {
            int start = offset + e.getNewLength();
            int length = offset2 - offset - e.getOldLength();
            CharSequence postfix = chars.subSequence(start, start + length);
            newString = new MergingCharSequence(newString, postfix);
        }
        this.updateSegments(newString, oldStartLine, oldEndLine, offset1, e);
        this.addEmptyLineAtEnd();
    }

    private void updateSegments(CharSequence newText, int oldStartLine, int oldEndLine, int offset1, DocumentEventImpl e) {
        int count = 0;
        LineTokenizer lineTokenizer = new LineTokenizer(newText);
        for (int index = oldStartLine; index <= oldEndLine; ++index) {
            if (lineTokenizer.atEnd()) {
                this.mySegments.remove(index, oldEndLine + 1);
                break;
            }
            LineSet.setSegmentAt(this.mySegments, index, lineTokenizer, offset1, true);
            lineTokenizer.advance();
            ++count;
        }
        if (!lineTokenizer.atEnd()) {
            SegmentArrayWithData insertSegments = new SegmentArrayWithData();
            int i = 0;
            while (!lineTokenizer.atEnd()) {
                LineSet.setSegmentAt(insertSegments, i, lineTokenizer, offset1, true);
                lineTokenizer.advance();
                ++count;
                ++i;
            }
            this.mySegments.insert(insertSegments, oldEndLine + 1);
        }
        int shift = e.getNewLength() - e.getOldLength();
        this.mySegments.shiftSegments(oldStartLine + count, shift);
    }

    private void processOneLineChange(DocumentEventImpl e) {
        if (e.getOffset() >= this.mySegments.getSegmentEnd(this.mySegments.getSegmentCount() - 1)) {
            this.mySegments.changeSegmentLength(this.mySegments.getSegmentCount() - 1, e.getNewLength() - e.getOldLength());
            LineSet.setSegmentModified(this.mySegments, this.mySegments.getSegmentCount() - 1);
        } else {
            this.mySegments.changeSegmentLength(e.getStartOldIndex(), e.getNewLength() - e.getOldLength());
            LineSet.setSegmentModified(this.mySegments, e.getStartOldIndex());
        }
    }

    public void clearModificationFlags() {
        for (int i = 0; i < this.mySegments.getSegmentCount(); ++i) {
            this.mySegments.setSegmentData(i, this.mySegments.getSegmentData(i) & 0xFFFFFFFB);
        }
    }

    private static void setSegmentAt(SegmentArrayWithData segmentArrayWithData, int index, LineTokenizer lineTokenizer, int offsetShift, boolean isModified) {
        int separatorLength;
        int offset = lineTokenizer.getOffset() + offsetShift;
        int length = lineTokenizer.getLength();
        int separatorAndModifiedFlag = separatorLength = lineTokenizer.getLineSeparatorLength();
        if (isModified) {
            separatorAndModifiedFlag |= 4;
        }
        segmentArrayWithData.setElementAt(index, offset, offset + length + separatorLength, separatorAndModifiedFlag);
    }

    private static void setSegmentModified(SegmentArrayWithData segments, int i) {
        segments.setSegmentData(i, segments.getSegmentData(i) | 4);
    }

    private void initSegments(CharSequence text, boolean toSetModified) {
        this.mySegments.removeAll();
        LineTokenizer lineTokenizer = new LineTokenizer(text);
        int i = 0;
        while (!lineTokenizer.atEnd()) {
            LineSet.setSegmentAt(this.mySegments, i, lineTokenizer, 0, toSetModified);
            ++i;
            lineTokenizer.advance();
        }
        this.addEmptyLineAtEnd();
    }

    private void addEmptyLineAtEnd() {
        int segmentCount = this.mySegments.getSegmentCount();
        if (segmentCount > 0 && this.getSeparatorLength(segmentCount - 1) > 0) {
            this.mySegments.setElementAt(segmentCount, this.mySegments.getSegmentEnd(segmentCount - 1), this.mySegments.getSegmentEnd(segmentCount - 1), 0);
            LineSet.setSegmentModified(this.mySegments, segmentCount);
        }
    }
}

