/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayUtil;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;

public class JDOMUtil {
    private static final ThreadLocal<SoftReference<SAXBuilder>> ourSaxBuilder = new ThreadLocal();
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();

    @NotNull
    public static Object[] getChildNodesWithAttrs(@NotNull Element e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/JDOMUtil", "getChildNodesWithAttrs"));
        }
        ArrayList<Cloneable> result = new ArrayList<Cloneable>();
        result.addAll(e.getContent());
        result.addAll(e.getAttributes());
        Object[] objectArray = ArrayUtil.toObjectArray(result);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getChildNodesWithAttrs"));
        }
        return objectArray;
    }

    @NotNull
    public static Content[] getContent(@NotNull Element m) {
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/JDOMUtil", "getContent"));
        }
        List<Content> list = m.getContent();
        Content[] contentArray = list.toArray(new Content[list.size()]);
        if (contentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getContent"));
        }
        return contentArray;
    }

    @NotNull
    public static String concatTextNodesValues(@NotNull Object[] nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/JDOMUtil", "concatTextNodesValues"));
        }
        StringBuilder result = new StringBuilder();
        for (Object node : nodes) {
            result.append(((Content)node).getValue());
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "concatTextNodesValues"));
        }
        return string;
    }

    public static String getValue(Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            return content.getValue();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Wrong node: " + node);
    }

    private static class EmptyTextFilter
    implements Filter {
        private EmptyTextFilter() {
        }

        @Override
        public boolean matches(Object obj) {
            if (obj instanceof Text) {
                Text t = (Text)obj;
                return !CharArrayUtil.containsOnlyWhiteSpaces(t.getText());
            }
            return true;
        }
    }
}

