/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Segment;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextRange
implements Segment,
Serializable {
    private static final long serialVersionUID = -670091356599757430L;
    public static final TextRange EMPTY_RANGE = new TextRange(0, 0);
    private final int myStartOffset;
    private final int myEndOffset;

    public TextRange(int startOffset, int endOffset) {
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
    }

    @Override
    public final int getStartOffset() {
        return this.myStartOffset;
    }

    @Override
    public final int getEndOffset() {
        return this.myEndOffset;
    }

    public final int getLength() {
        return this.myEndOffset - this.myStartOffset;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextRange)) {
            return false;
        }
        TextRange range = (TextRange)obj;
        return this.myStartOffset == range.myStartOffset && this.myEndOffset == range.myEndOffset;
    }

    public int hashCode() {
        return this.myStartOffset + this.myEndOffset;
    }

    public boolean contains(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/TextRange", "contains"));
        }
        return this.containsRange(range.getStartOffset(), range.getEndOffset());
    }

    public boolean containsRange(int startOffset, int endOffset) {
        return this.myStartOffset <= startOffset && this.myEndOffset >= endOffset;
    }

    public boolean containsOffset(int offset) {
        return this.myStartOffset <= offset && offset <= this.myEndOffset;
    }

    public String toString() {
        return "(" + this.myStartOffset + "," + this.myEndOffset + ")";
    }

    public boolean contains(int offset) {
        return this.myStartOffset <= offset && offset < this.myEndOffset;
    }

    @NotNull
    public String substring(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/TextRange", "substring"));
        }
        String string = str.substring(this.myStartOffset, this.myEndOffset);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/TextRange", "substring"));
        }
        return string;
    }

    @NotNull
    public TextRange cutOut(@NotNull TextRange subRange) {
        if (subRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/TextRange", "cutOut"));
        }
        assert (subRange.getStartOffset() <= this.getLength()) : subRange + "; this=" + this;
        assert (subRange.getEndOffset() <= this.getLength()) : subRange + "; this=" + this;
        TextRange textRange = new TextRange(this.myStartOffset + subRange.getStartOffset(), Math.min(this.myEndOffset, this.myStartOffset + subRange.getEndOffset()));
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/TextRange", "cutOut"));
        }
        return textRange;
    }

    @NotNull
    public TextRange shiftRight(int delta) {
        if (delta == 0) {
            TextRange textRange = this;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/TextRange", "shiftRight"));
            }
            return textRange;
        }
        TextRange textRange = new TextRange(this.myStartOffset + delta, this.myEndOffset + delta);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/TextRange", "shiftRight"));
        }
        return textRange;
    }

    @NotNull
    public TextRange grown(int lengthDelta) {
        TextRange textRange = TextRange.from(this.myStartOffset, this.getLength() + lengthDelta);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/TextRange", "grown"));
        }
        return textRange;
    }

    @NotNull
    public static TextRange from(int offset, int length) {
        TextRange textRange = TextRange.create(offset, offset + length);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/TextRange", "from"));
        }
        return textRange;
    }

    @NotNull
    public static TextRange create(int startOffset, int endOffset) {
        TextRange textRange = new TextRange(startOffset, endOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/TextRange", "create"));
        }
        return textRange;
    }

    @NotNull
    public static TextRange create(@NotNull Segment segment) {
        if (segment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/TextRange", "create"));
        }
        TextRange textRange = TextRange.create(segment.getStartOffset(), segment.getEndOffset());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/TextRange", "create"));
        }
        return textRange;
    }

    public static boolean areSegmentsEqual(@NotNull Segment segment1, @NotNull Segment segment2) {
        if (segment1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/TextRange", "areSegmentsEqual"));
        }
        if (segment2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/TextRange", "areSegmentsEqual"));
        }
        return segment1.getStartOffset() == segment2.getStartOffset() && segment1.getEndOffset() == segment2.getEndOffset();
    }

    @NotNull
    public String replace(@NotNull String original, @NotNull String replacement) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/TextRange", "replace"));
        }
        if (replacement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/TextRange", "replace"));
        }
        String beginning = original.substring(0, this.getStartOffset());
        String ending = original.substring(this.getEndOffset(), original.length());
        String string = beginning + replacement + ending;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/TextRange", "replace"));
        }
        return string;
    }

    public boolean intersects(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/TextRange", "intersects"));
        }
        return this.intersects((Segment)textRange);
    }

    public boolean intersects(@NotNull Segment textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/TextRange", "intersects"));
        }
        return this.intersects(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public boolean intersects(int startOffset, int endOffset) {
        return Math.max(this.myStartOffset, startOffset) <= Math.min(this.myEndOffset, endOffset);
    }

    public boolean intersectsStrict(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/TextRange", "intersectsStrict"));
        }
        return this.intersectsStrict(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public boolean intersectsStrict(int startOffset, int endOffset) {
        return Math.max(this.myStartOffset, startOffset) < Math.min(this.myEndOffset, endOffset);
    }

    @Nullable
    public TextRange intersection(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/TextRange", "intersection"));
        }
        if (!this.intersects(range)) {
            return null;
        }
        return new TextRange(Math.max(this.myStartOffset, range.getStartOffset()), Math.min(this.myEndOffset, range.getEndOffset()));
    }

    public boolean isEmpty() {
        return this.myStartOffset >= this.myEndOffset;
    }

    @NotNull
    public TextRange union(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/TextRange", "union"));
        }
        TextRange textRange2 = new TextRange(Math.min(this.myStartOffset, textRange.getStartOffset()), Math.max(this.myEndOffset, textRange.getEndOffset()));
        if (textRange2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/TextRange", "union"));
        }
        return textRange2;
    }

    public boolean equalsToRange(int startOffset, int endOffset) {
        return startOffset == this.myStartOffset && endOffset == this.myEndOffset;
    }

    public static TextRange allOf(String s) {
        return new TextRange(0, s.length());
    }
}

