/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ReflectionCache;
import com.intellij.util.containers.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiplePsiFilesPerDocumentFileViewProvider
extends SingleRootFileViewProvider {
    private final ConcurrentMap<Language, PsiFile> myRoots = new ConcurrentHashMap<Language, PsiFile>(1, 0.75f, 1);
    private MultiplePsiFilesPerDocumentFileViewProvider myOriginal = null;

    public MultiplePsiFilesPerDocumentFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical, Language.ANY);
    }

    @Override
    @NotNull
    public abstract Language getBaseLanguage();

    @Override
    @NotNull
    public List<PsiFile> getAllFiles() {
        ArrayList<PsiFile> roots = new ArrayList<PsiFile>();
        for (Language language : this.getLanguages()) {
            PsiFile psi = this.getPsi(language);
            if (psi == null) continue;
            roots.add(psi);
        }
        PsiFile base = this.getPsi(this.getBaseLanguage());
        if (!roots.isEmpty() && roots.get(0) != base) {
            roots.remove(base);
            roots.add(0, base);
        }
        ArrayList<PsiFile> arrayList = roots;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider", "getAllFiles"));
        }
        return arrayList;
    }

    protected void removeFile(Language language) {
        this.myRoots.remove(language);
    }

    @Override
    protected PsiFile getPsiInner(@NotNull Language target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider", "getPsiInner"));
        }
        PsiFile file = (PsiFile)this.myRoots.get(target);
        if (file == null) {
            PsiFile originalFile;
            if (this.isPhysical()) {
                VirtualFile virtualFile = this.getVirtualFile();
                if (this.isIgnored()) {
                    return null;
                }
                VirtualFile parent = virtualFile.getParent();
                if (parent != null) {
                    this.getManager().findDirectory(parent);
                }
            }
            if ((file = this.createFile(target)) == null) {
                return null;
            }
            if (this.myOriginal != null && (originalFile = this.myOriginal.getPsi(target)) != null) {
                ((PsiFileImpl)file).setOriginalFile(originalFile);
            }
            file = ConcurrencyUtil.cacheOrGet(this.myRoots, target, file);
        }
        return file;
    }

    @Override
    public PsiFile getCachedPsi(Language target) {
        return (PsiFile)this.myRoots.get(target);
    }

    @Override
    public FileElement[] getKnownTreeRoots() {
        ArrayList<FileElement> files = new ArrayList<FileElement>(this.myRoots.size());
        for (PsiFile file : this.myRoots.values()) {
            FileElement treeElement = ((PsiFileImpl)file).getTreeElement();
            if (treeElement == null) continue;
            files.add(treeElement);
        }
        return files.toArray(new FileElement[files.size()]);
    }

    public void checkAllTreesEqual() {
        Collection roots = this.myRoots.values();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(this.getManager().getProject());
        documentManager.commitAllDocuments();
        for (PsiFile root : roots) {
            Document document = documentManager.getDocument(root);
            PsiDocumentManagerBase.checkConsistency(root, document);
            assert (root.getText().equals(document.getText()));
        }
    }

    @Override
    @NotNull
    public final MultiplePsiFilesPerDocumentFileViewProvider createCopy(@NotNull VirtualFile fileCopy) {
        if (fileCopy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider", "createCopy"));
        }
        MultiplePsiFilesPerDocumentFileViewProvider copy = this.cloneInner(fileCopy);
        copy.myOriginal = this.myOriginal == null ? this : this.myOriginal;
        MultiplePsiFilesPerDocumentFileViewProvider multiplePsiFilesPerDocumentFileViewProvider = copy;
        if (multiplePsiFilesPerDocumentFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider", "createCopy"));
        }
        return multiplePsiFilesPerDocumentFileViewProvider;
    }

    protected abstract MultiplePsiFilesPerDocumentFileViewProvider cloneInner(VirtualFile var1);

    @Override
    @Nullable
    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider", "findElementAt"));
        }
        PsiFile mainRoot = this.getPsi(this.getBaseLanguage());
        PsiElement ret = null;
        for (Language language : this.getLanguages()) {
            PsiFile psiRoot;
            PsiElement psiElement;
            if (!ReflectionCache.isAssignable(lang, language.getClass()) || lang.equals(Language.class) && !this.getLanguages().contains(language) || (psiElement = MultiplePsiFilesPerDocumentFileViewProvider.findElementAt(psiRoot = this.getPsi(language), offset)) == null || psiElement instanceof OuterLanguageElement || ret != null && psiRoot == mainRoot) continue;
            ret = psiElement;
        }
        return ret;
    }

    @Override
    @Nullable
    public PsiElement findElementAt(int offset) {
        return this.findElementAt(offset, Language.class);
    }

    @Override
    @Nullable
    public PsiReference findReferenceAt(int offset) {
        TextRange minRange = new TextRange(0, this.getContents().length());
        PsiReference ret = null;
        for (Language language : this.getLanguages()) {
            TextRange textRange;
            PsiFile psiRoot = this.getPsi(language);
            PsiReference reference = SharedPsiElementImplUtil.findReferenceAt(psiRoot, offset, language);
            if (reference == null || !minRange.contains(textRange = reference.getRangeInElement().shiftRight(reference.getElement().getTextRange().getStartOffset())) || textRange.contains(minRange)) continue;
            minRange = textRange;
            ret = reference;
        }
        return ret;
    }

    @Override
    public void contentsSynchronized() {
        super.contentsSynchronized();
        Set<Language> languages = this.getLanguages();
        Iterator iterator = this.myRoots.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (languages.contains(entry.getKey())) continue;
            iterator.remove();
        }
    }
}

