/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodReferenceUtil {
    public static ThreadLocal<Map<PsiMethodReferenceExpression, PsiType>> ourRefs = new ThreadLocal();
    public static final Logger LOG = Logger.getInstance("#" + PsiMethodReferenceUtil.class.getName());

    public static boolean isValidQualifier(PsiMethodReferenceExpression expression) {
        PsiElement referenceNameElement = expression.getReferenceNameElement();
        if (referenceNameElement instanceof PsiKeyword) {
            PsiElement qualifier = expression.getQualifier();
            if (qualifier instanceof PsiTypeElement) {
                return true;
            }
            if (qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).resolve() instanceof PsiClass) {
                return true;
            }
        }
        return false;
    }

    public static QualifierResolveResult getQualifierResolveResult(PsiMethodReferenceExpression methodReferenceExpression) {
        PsiClass containingClass = null;
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiExpression expression = methodReferenceExpression.getQualifierExpression();
        if (expression != null) {
            JavaResolveResult resolveResult;
            PsiElement resolve;
            PsiType expressionType = PsiMethodReferenceUtil.getExpandedType(expression.getType(), expression);
            PsiClassType.ClassResolveResult result = PsiUtil.resolveGenericsClassInType(expressionType);
            containingClass = result.getElement();
            if (containingClass != null) {
                substitutor = result.getSubstitutor();
            }
            if (containingClass == null && expression instanceof PsiReferenceExpression && (resolve = (resolveResult = ((PsiReferenceExpression)expression).advancedResolve(false)).getElement()) instanceof PsiClass) {
                containingClass = (PsiClass)resolve;
                substitutor = resolveResult.getSubstitutor();
                return new QualifierResolveResult(containingClass, substitutor, true);
            }
        } else {
            PsiType type;
            PsiClassType.ClassResolveResult result;
            PsiTypeElement typeElement = methodReferenceExpression.getQualifierType();
            if (typeElement != null && (containingClass = (result = PsiUtil.resolveGenericsClassInType(type = PsiMethodReferenceUtil.getExpandedType(typeElement.getType(), typeElement))).getElement()) != null) {
                substitutor = result.getSubstitutor();
            }
        }
        return new QualifierResolveResult(containingClass, substitutor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAcceptable(@Nullable PsiMethodReferenceExpression methodReferenceExpression, PsiType left) {
        JavaResolveResult result;
        if (methodReferenceExpression == null) {
            return false;
        }
        if (left instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)left).getConjuncts()) {
                if (!PsiMethodReferenceUtil.isAcceptable(methodReferenceExpression, conjunct)) continue;
                return true;
            }
            return false;
        }
        Map<PsiMethodReferenceExpression, PsiType> map = ourRefs.get();
        if (map == null) {
            map = new HashMap<PsiMethodReferenceExpression, PsiType>();
            ourRefs.set(map);
        }
        try {
            if (map.put(methodReferenceExpression, left) != null) {
                boolean i$ = false;
                return i$;
            }
            result = methodReferenceExpression.advancedResolve(false);
        }
        finally {
            map.remove(methodReferenceExpression);
        }
        final PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(left);
        PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
        if (method != null) {
            PsiType interfaceReturnType;
            QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(methodReferenceExpression);
            PsiElement resolve = result.getElement();
            if (resolve instanceof PsiMethod) {
                MethodSignature signature1 = method.getSignature(LambdaUtil.getSubstitutor(method, resolveResult));
                PsiSubstitutor subst = PsiSubstitutor.EMPTY;
                subst = subst.putAll(qualifierResolveResult.getSubstitutor());
                subst = subst.putAll(result.getSubstitutor());
                MethodSignature signature2 = ((PsiMethod)resolve).getSignature(subst);
                PsiType interfaceReturnType2 = LambdaUtil.getFunctionalInterfaceReturnType(left);
                PsiType returnType = PsiTypesUtil.patchMethodGetClassReturnType(methodReferenceExpression, methodReferenceExpression, (PsiMethod)resolve, null, PsiUtil.getLanguageLevel(methodReferenceExpression));
                if (returnType == null) {
                    returnType = ((PsiMethod)resolve).getReturnType();
                }
                PsiType methodReturnType = subst.substitute(returnType);
                if (interfaceReturnType2 != null && interfaceReturnType2 != PsiType.VOID) {
                    if (methodReturnType == null) {
                        methodReturnType = JavaPsiFacade.getElementFactory(methodReferenceExpression.getProject()).createType(((PsiMethod)resolve).getContainingClass(), subst);
                    }
                    if (!TypeConversionUtil.isAssignable(interfaceReturnType2, methodReturnType, false)) {
                        return false;
                    }
                }
                if (PsiMethodReferenceUtil.areAcceptable(signature1, signature2, qualifierResolveResult.getContainingClass(), qualifierResolveResult.getSubstitutor(), ((PsiMethod)resolve).isVarArgs())) {
                    return true;
                }
            } else if (resolve instanceof PsiClass && (interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(left)) != null) {
                if (interfaceReturnType == PsiType.VOID) {
                    return true;
                }
                PsiParameter[] parameters = method.getParameterList().getParameters();
                if (resolve == JavaPsiFacade.getElementFactory(resolve.getProject()).getArrayClass(PsiUtil.getLanguageLevel(resolve))) {
                    if (!PsiMethodReferenceUtil.arrayCompatibleSignature(parameters, (Function<T[], PsiType>)new Function<PsiParameter[], PsiType>(){

                        @Override
                        public PsiType fun(PsiParameter[] parameters) {
                            return resolveResult.getSubstitutor().substitute(parameters[0].getType());
                        }
                    })) {
                        return false;
                    }
                    PsiTypeParameter[] typeParameters = ((PsiClass)resolve).getTypeParameters();
                    if (typeParameters.length == 1) {
                        PsiType arrayComponentType = result.getSubstitutor().substitute(typeParameters[0]);
                        return arrayComponentType != null && TypeConversionUtil.isAssignable(interfaceReturnType, arrayComponentType.createArrayType(), true);
                    }
                    return false;
                }
                PsiClassType classType = JavaPsiFacade.getElementFactory(methodReferenceExpression.getProject()).createType((PsiClass)resolve, result.getSubstitutor());
                if (TypeConversionUtil.isAssignable(interfaceReturnType, classType, !((PsiClass)resolve).hasTypeParameters())) {
                    if (parameters.length == 0) {
                        return true;
                    }
                    if (parameters.length == 1 && PsiMethodReferenceUtil.isReceiverType(resolveResult.getSubstitutor().substitute(parameters[0].getType()), qualifierResolveResult.getContainingClass(), qualifierResolveResult.getSubstitutor())) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isReceiverType(@Nullable PsiClass aClass, @Nullable PsiClass containingClass) {
        return InheritanceUtil.isInheritorOrSelf(aClass, containingClass, true);
    }

    public static boolean isReceiverType(PsiType receiverType, @Nullable PsiClass containingClass, PsiSubstitutor psiSubstitutor) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass receiverClass;
        boolean arrayType = receiverType instanceof PsiArrayType;
        if (containingClass != null) {
            receiverType = PsiMethodReferenceUtil.getExpandedType(receiverType, containingClass);
        }
        if ((receiverClass = (resolveResult = PsiUtil.resolveGenericsClassInType(GenericsUtil.eliminateWildcards(receiverType))).getElement()) != null && PsiMethodReferenceUtil.isReceiverType(receiverClass, containingClass)) {
            LOG.assertTrue(containingClass != null);
            return arrayType || resolveResult.getSubstitutor().equals(psiSubstitutor) || PsiMethodReferenceUtil.emptyOrRaw(containingClass, psiSubstitutor) || PsiMethodReferenceUtil.emptyOrRaw(receiverClass, resolveResult.getSubstitutor());
        }
        return false;
    }

    private static boolean emptyOrRaw(PsiClass containingClass, PsiSubstitutor psiSubstitutor) {
        return PsiUtil.isRawSubstitutor(containingClass, psiSubstitutor) || !containingClass.hasTypeParameters() && psiSubstitutor.getSubstitutionMap().isEmpty();
    }

    public static boolean isReceiverType(PsiType functionalInterfaceType, PsiClass containingClass, @Nullable PsiMethod referencedMethod) {
        PsiType firstParamType;
        boolean isReceiver;
        int interfaceMethodParamsLength;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        MethodSignature function = LambdaUtil.getFunction(resolveResult.getElement());
        if (function != null && (interfaceMethodParamsLength = function.getParameterTypes().length) > 0 && (isReceiver = PsiMethodReferenceUtil.isReceiverType(firstParamType = resolveResult.getSubstitutor().substitute(function.getParameterTypes()[0]), containingClass, PsiUtil.resolveGenericsClassInType(firstParamType).getSubstitutor()))) {
            if (referencedMethod == null) {
                return interfaceMethodParamsLength == 1;
            }
            return referencedMethod.getParameterList().getParametersCount() == interfaceMethodParamsLength - 1;
        }
        return false;
    }

    public static boolean areAcceptable(MethodSignature signature1, MethodSignature signature2, PsiClass psiClass, PsiSubstitutor psiSubstitutor, boolean isVarargs) {
        PsiType[] signatureParameterTypes2;
        int offset = 0;
        PsiType[] signatureParameterTypes1 = signature1.getParameterTypes();
        if (signatureParameterTypes1.length != (signatureParameterTypes2 = signature2.getParameterTypes()).length) {
            if (signatureParameterTypes1.length == signatureParameterTypes2.length + 1) {
                if (PsiMethodReferenceUtil.isReceiverType(signatureParameterTypes1[0], psiClass, psiSubstitutor)) {
                    ++offset;
                } else if (!isVarargs) {
                    return false;
                }
            } else if (!isVarargs) {
                return false;
            }
        }
        int min = Math.min(signatureParameterTypes2.length, signatureParameterTypes1.length);
        for (int i = 0; i < min; ++i) {
            PsiType type1 = GenericsUtil.eliminateWildcards(psiSubstitutor.substitute(signatureParameterTypes1[offset + i]));
            if (isVarargs && i == min - 1) {
                if (!(signatureParameterTypes2[i] instanceof PsiArrayType)) {
                    return false;
                }
                if (TypeConversionUtil.isAssignable(((PsiArrayType)signatureParameterTypes2[i]).getComponentType(), type1) || TypeConversionUtil.isAssignable(signatureParameterTypes2[i], type1)) continue;
                return false;
            }
            if (TypeConversionUtil.isAssignable(signatureParameterTypes2[i], type1)) continue;
            return false;
        }
        return true;
    }

    public static boolean onArrayType(PsiClass containingClass, MethodSignature signature) {
        if (PsiMethodReferenceUtil.arrayCompatibleSignature(signature.getParameterTypes(), (Function<T[], PsiType>)new Function<PsiType[], PsiType>(){

            @Override
            public PsiType fun(PsiType[] types) {
                return types[0];
            }
        }) && containingClass != null) {
            Project project = containingClass.getProject();
            LanguageLevel level = PsiUtil.getLanguageLevel(containingClass);
            return containingClass == JavaPsiFacade.getElementFactory(project).getArrayClass(level);
        }
        return false;
    }

    private static <T> boolean arrayCompatibleSignature(T[] paramTypes, Function<T[], PsiType> fun) {
        PsiType paramType;
        return paramTypes.length == 1 && (paramType = fun.fun(paramTypes)) != null && TypeConversionUtil.isAssignable(PsiType.INT, paramType);
    }

    private static PsiType getExpandedType(PsiType type, @NotNull PsiElement typeElement) {
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/PsiMethodReferenceUtil", "getExpandedType"));
        }
        if (type instanceof PsiArrayType) {
            type = JavaPsiFacade.getElementFactory(typeElement.getProject()).getArrayClassType(((PsiArrayType)type).getComponentType(), PsiUtil.getLanguageLevel(typeElement));
        }
        return type;
    }

    public static class QualifierResolveResult {
        private final PsiClass myContainingClass;
        private final PsiSubstitutor mySubstitutor;
        private final boolean myReferenceTypeQualified;

        public QualifierResolveResult(PsiClass containingClass, PsiSubstitutor substitutor, boolean referenceTypeQualified) {
            this.myContainingClass = containingClass;
            this.mySubstitutor = substitutor;
            this.myReferenceTypeQualified = referenceTypeQualified;
        }

        public PsiClass getContainingClass() {
            return this.myContainingClass;
        }

        public PsiSubstitutor getSubstitutor() {
            return this.mySubstitutor;
        }

        public boolean isReferenceTypeQualified() {
            return this.myReferenceTypeQualified;
        }
    }
}

