/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiNameHelper {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(?:\\s)|(?:/\\*.*\\*/)|(?://[^\\n]*)");

    public abstract boolean isIdentifier(@Nullable String var1);

    public abstract boolean isIdentifier(@Nullable String var1, LanguageLevel var2);

    public abstract boolean isKeyword(@Nullable String var1);

    public abstract boolean isQualifiedName(@Nullable String var1);

    @NotNull
    public static String getShortClassName(@NotNull String referenceText) {
        String sub;
        int i;
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/PsiNameHelper", "getShortClassName"));
        }
        int lessPos = referenceText.length();
        int bracesBalance = 0;
        block5: for (i = referenceText.length() - 1; i >= 0; --i) {
            char ch = referenceText.charAt(i);
            switch (ch) {
                case ')': 
                case '>': {
                    ++bracesBalance;
                    continue block5;
                }
                case '(': 
                case '<': {
                    --bracesBalance;
                    lessPos = i;
                    continue block5;
                }
                case '.': 
                case '@': {
                    if (bracesBalance > 0) continue block5;
                    break block5;
                }
                default: {
                    if (!Character.isWhitespace(ch) || bracesBalance > 0) continue block5;
                    for (int j = i + 1; j < lessPos; ++j) {
                        if (!Character.isWhitespace(referenceText.charAt(j))) break block5;
                    }
                    lessPos = i;
                }
            }
        }
        String string = (sub = referenceText.substring(i + 1, lessPos).trim()).length() == referenceText.length() ? sub : new String(sub);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiNameHelper", "getShortClassName"));
        }
        return string;
    }

    @NotNull
    public static String getPresentableText(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/PsiNameHelper", "getPresentableText"));
        }
        String name = ref.getReferenceName();
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)ref, PsiAnnotation.class);
        String string = PsiNameHelper.getPresentableText(name, ObjectUtils.notNull(annotations, PsiAnnotation.EMPTY_ARRAY), ref.getTypeParameters());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiNameHelper", "getPresentableText"));
        }
        return string;
    }

    @NotNull
    public static String getPresentableText(@Nullable String refName, @NotNull PsiAnnotation[] annotations, @NotNull PsiType[] typeParameters) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/PsiNameHelper", "getPresentableText"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/PsiNameHelper", "getPresentableText"));
        }
        if (typeParameters.length == 0 && annotations.length == 0) {
            String string = refName != null ? refName : "";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiNameHelper", "getPresentableText"));
            }
            return string;
        }
        StringBuilder buffer = new StringBuilder();
        if (annotations.length > 0) {
            for (PsiAnnotation annotation : annotations) {
                buffer.append(annotation.getText()).append(' ');
            }
        }
        buffer.append(refName);
        if (typeParameters.length > 0) {
            buffer.append("<");
            for (int i = 0; i < typeParameters.length; ++i) {
                buffer.append(typeParameters[i].getPresentableText());
                if (i >= typeParameters.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append(">");
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiNameHelper", "getPresentableText"));
        }
        return string;
    }

    public static String getPresentableText(@Nullable String referenceName, @NotNull PsiType[] typeParameters) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/PsiNameHelper", "getPresentableText"));
        }
        return PsiNameHelper.getPresentableText(referenceName, PsiAnnotation.EMPTY_ARRAY, typeParameters);
    }

    @NotNull
    public static String getQualifiedClassName(String referenceText, boolean removeWhitespace) {
        if (removeWhitespace) {
            referenceText = PsiNameHelper.removeWhitespace(referenceText);
        }
        if (referenceText.indexOf(60) < 0) {
            String string = referenceText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiNameHelper", "getQualifiedClassName"));
            }
            return string;
        }
        StringBuilder buffer = new StringBuilder(referenceText.length());
        char[] chars = referenceText.toCharArray();
        int gtPos = 0;
        int count = 0;
        block4: for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++count != 1) continue block4;
                    buffer.append(new String(chars, gtPos, i - gtPos));
                    continue block4;
                }
                case '>': {
                    --count;
                    gtPos = i + 1;
                }
            }
        }
        if (count == 0) {
            buffer.append(new String(chars, gtPos, chars.length - gtPos));
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiNameHelper", "getQualifiedClassName"));
        }
        return string;
    }

    private static String removeWhitespace(String referenceText) {
        return WHITESPACE_PATTERN.matcher(referenceText).replaceAll("");
    }

    public static String[] getClassParametersText(String referenceText) {
        if (referenceText.indexOf(60) < 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        referenceText = PsiNameHelper.removeWhitespace(referenceText);
        char[] chars = referenceText.toCharArray();
        int afterLastDotIndex = 0;
        int level = 0;
        block15: for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    ++level;
                    continue block15;
                }
                case '.': {
                    if (level != 0) continue block15;
                    afterLastDotIndex = i + 1;
                    continue block15;
                }
                case '>': {
                    --level;
                }
            }
        }
        if (level != 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        int dim = 0;
        block16: for (int i = afterLastDotIndex; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++level != 1) continue block16;
                    ++dim;
                    continue block16;
                }
                case ',': {
                    if (level != 1) continue block16;
                    ++dim;
                    continue block16;
                }
                case '>': {
                    --level;
                }
            }
        }
        if (level != 0 || dim == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[dim];
        dim = 0;
        int ltPos = 0;
        block17: for (int i = afterLastDotIndex; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++level != 1) continue block17;
                    ltPos = i;
                    continue block17;
                }
                case ',': {
                    if (level != 1) continue block17;
                    result[dim++] = new String(chars, ltPos + 1, i - ltPos - 1);
                    ltPos = i;
                    continue block17;
                }
                case '>': {
                    if (--level != 0) continue block17;
                    result[dim++] = new String(chars, ltPos + 1, i - ltPos - 1);
                }
            }
        }
        return result;
    }
}

