/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.TreeAspectEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.TextBlock;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DocumentCommitProcessor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.DocumentCommitThread");

    public abstract void commitSynchronously(@NotNull Document var1, @NotNull Project var2);

    public abstract void commitAsynchronously(@NotNull Project var1, @NotNull Document var2, @NonNls @NotNull Object var3);

    @Nullable(value="returns runnable to execute under write action in AWT to finish the commit")
    public Processor<Document> doCommit(final @NotNull CommitTask task, final @NotNull PsiFile file, final boolean synchronously) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/DocumentCommitProcessor", "doCommit"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/DocumentCommitProcessor", "doCommit"));
        }
        Document document = task.document;
        final TextBlock textBlock = TextBlock.get(file);
        if (textBlock.isEmpty()) {
            return null;
        }
        final long startDocModificationTimeStamp = document.getModificationStamp();
        final FileElement myTreeElementBeingReparsedSoItWontBeCollected = ((PsiFileImpl)file).calcTreeElement();
        if (textBlock.isEmpty()) {
            return null;
        }
        CharSequence chars = document.getCharsSequence();
        Boolean data = document.getUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY);
        if (data != null) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, data);
        }
        final String oldPsiText = ApplicationManager.getApplication().isInternal() && ApplicationManager.getApplication().isUnitTestMode() ? myTreeElementBeingReparsedSoItWontBeCollected.getText() : null;
        TextRange changedPsiRange = DocumentCommitProcessor.getChangedPsiRange(file, textBlock.getStartOffset(), textBlock.getPsiEndOffset(), document.getTextLength());
        if (!DocumentCommitProcessor.assertBeforeCommit(document, file, textBlock, chars, oldPsiText, myTreeElementBeingReparsedSoItWontBeCollected)) {
            return new Processor<Document>(){

                @Override
                public boolean process(Document document) {
                    VirtualFile vFile = FileDocumentManager.getInstance().getFile(document);
                    DocumentCommitProcessor.this.log("Recovering from assertBeforeCommit", task, synchronously, vFile, vFile != null && vFile.isValid());
                    if (vFile != null && vFile.isValid()) {
                        FileContentUtilCore.reparseFiles(Arrays.asList(vFile));
                    }
                    return true;
                }
            };
        }
        BlockSupport blockSupport = BlockSupport.getInstance(file.getProject());
        final DiffLog diffLog = blockSupport.reparseRange(file, changedPsiRange, chars, task.indicator);
        return new Processor<Document>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean process(Document document) {
                ApplicationManager.getApplication().assertWriteAccessAllowed();
                DocumentCommitProcessor.this.log("Finishing", task, synchronously, document.getModificationStamp(), startDocModificationTimeStamp);
                if (document.getModificationStamp() != startDocModificationTimeStamp) {
                    return false;
                }
                try {
                    CodeStyleManager.getInstance(file.getProject()).performActionWithFormatterDisabled(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = PsiLock.LOCK;
                            synchronized (object) {
                                DocumentCommitProcessor.doActualPsiChange(file, diffLog);
                            }
                        }
                    });
                    DocumentCommitProcessor.this.assertAfterCommit(document, file, oldPsiText, myTreeElementBeingReparsedSoItWontBeCollected);
                }
                finally {
                    textBlock.clear();
                }
                return true;
            }
        };
    }

    public static TextRange getChangedPsiRange(PsiFile file, int changeStart, int changeEnd, int newTextLength) {
        if (file.getViewProvider().supportsIncrementalReparse(file.getLanguage())) {
            return new TextRange(changeStart, changeEnd);
        }
        return new TextRange(0, newTextLength);
    }

    public static void doActualPsiChange(final @NotNull PsiFile file, final @NotNull DiffLog diffLog) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/DocumentCommitProcessor", "doActualPsiChange"));
        }
        if (diffLog == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/DocumentCommitProcessor", "doActualPsiChange"));
        }
        file.getViewProvider().beforeContentsSynchronized();
        try {
            Document document = file.getViewProvider().getDocument();
            PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(file.getProject());
            PsiToDocumentSynchronizer.DocumentChangeTransaction transaction = documentManager.getSynchronizer().getTransaction(document);
            PsiFileImpl fileImpl = (PsiFileImpl)file;
            if (transaction == null) {
                final PomModel model = PomManager.getModel(fileImpl.getProject());
                model.runTransaction(new PomTransactionBase(fileImpl, model.getModelAspect(TreeAspect.class)){

                    @Override
                    public PomModelEvent runInner() {
                        return new TreeAspectEvent(model, diffLog.performActualPsiChange(file));
                    }
                });
            } else {
                diffLog.performActualPsiChange(file);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }

    private static boolean assertBeforeCommit(@NotNull Document document, @NotNull PsiFile file, @NotNull TextBlock textBlock, @NotNull CharSequence chars, String oldPsiText, @NotNull FileElement myTreeElementBeingReparsedSoItWontBeCollected) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/DocumentCommitProcessor", "assertBeforeCommit"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/DocumentCommitProcessor", "assertBeforeCommit"));
        }
        if (textBlock == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/DocumentCommitProcessor", "assertBeforeCommit"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/DocumentCommitProcessor", "assertBeforeCommit"));
        }
        if (myTreeElementBeingReparsedSoItWontBeCollected == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/psi/impl/DocumentCommitProcessor", "assertBeforeCommit"));
        }
        int startOffset = textBlock.getStartOffset();
        int psiEndOffset = textBlock.getPsiEndOffset();
        if (oldPsiText != null) {
            String msg = "PSI/document inconsistency before reparse: file=" + file + " of class " + file.getClass();
            if (startOffset >= oldPsiText.length()) {
                msg = msg + "\nstartOffset=" + oldPsiText + " while text length is " + oldPsiText.length() + "; ";
                startOffset = oldPsiText.length();
            }
            String psiPrefix = oldPsiText.substring(0, startOffset);
            String docPrefix = ((Object)chars.subSequence(0, startOffset)).toString();
            String psiSuffix = psiEndOffset > oldPsiText.length() ? "<psiEndOffset too large>" : oldPsiText.substring(psiEndOffset);
            String docSuffix = ((Object)chars.subSequence(textBlock.getTextEndOffset(), chars.length())).toString();
            if (!psiPrefix.equals(docPrefix) || !psiSuffix.equals(docSuffix)) {
                if (!psiPrefix.equals(docPrefix)) {
                    msg = msg + "\n\npsiPrefix=" + psiPrefix + "\n\ndocPrefix=" + docPrefix;
                }
                if (!psiSuffix.equals(docSuffix)) {
                    msg = msg + "\n\npsiSuffix=" + psiSuffix + "\n\ndocSuffix=" + docSuffix;
                }
                LOG.error(msg);
                return false;
            }
        } else if (document.getTextLength() - textBlock.getTextEndOffset() != myTreeElementBeingReparsedSoItWontBeCollected.getTextLength() - psiEndOffset) {
            LOG.error("PSI/document inconsistency before reparse: file=" + file);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAfterCommit(Document document, final PsiFile file, String oldPsiText, FileElement myTreeElementBeingReparsedSoItWontBeCollected) {
        if (myTreeElementBeingReparsedSoItWontBeCollected.getTextLength() != document.getTextLength()) {
            String documentText = document.getText();
            if (ApplicationManager.getApplication().isInternal()) {
                String fileText = file.getText();
                LOG.error("commitDocument left PSI inconsistent; file len=" + myTreeElementBeingReparsedSoItWontBeCollected.getTextLength() + "; doc len=" + document.getTextLength() + "; doc.getText() == file.getText(): " + Comparing.equal(fileText, documentText) + ";\n file psi text=" + fileText + ";\n doc text=" + documentText + ";\n old psi file text=" + oldPsiText);
            } else {
                LOG.error("commitDocument left PSI inconsistent: " + file);
            }
            file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
            try {
                BlockSupport blockSupport = BlockSupport.getInstance(file.getProject());
                final DiffLog diffLog = blockSupport.reparseRange(file, new TextRange(0, documentText.length()), documentText, this.createProgressIndicator());
                CodeStyleManager.getInstance(file.getProject()).performActionWithFormatterDisabled(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = PsiLock.LOCK;
                        synchronized (object) {
                            DocumentCommitProcessor.doActualPsiChange(file, diffLog);
                        }
                    }
                });
                if (myTreeElementBeingReparsedSoItWontBeCollected.getTextLength() != document.getTextLength()) {
                    LOG.error("PSI is broken beyond repair in: " + file);
                }
            }
            finally {
                file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            }
        }
    }

    public void log(@NonNls String msg, CommitTask task, boolean synchronously, Object ... args) {
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator();
        if (emptyProgressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitProcessor", "createProgressIndicator"));
        }
        return emptyProgressIndicator;
    }

    protected static class CommitTask {
        public final Document document;
        public final Project project;
        public final ProgressIndicator indicator;
        public final Object reason;
        public boolean removed;

        public CommitTask(@NotNull Document document, @NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull Object reason) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/DocumentCommitProcessor$CommitTask", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/DocumentCommitProcessor$CommitTask", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/DocumentCommitProcessor$CommitTask", "<init>"));
            }
            if (reason == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/DocumentCommitProcessor$CommitTask", "<init>"));
            }
            this.document = document;
            this.project = project;
            this.indicator = indicator;
            this.reason = reason;
        }

        @NonNls
        public String toString() {
            return "Project: " + this.project.getName() + ", Doc: " + this.document + " (" + StringUtil.first(this.document.getText(), 12, true).replaceAll("\n", " ") + ")" + (this.indicator.isCanceled() ? " (Canceled)" : "") + (this.removed ? "Removed" : "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CommitTask)) {
                return false;
            }
            CommitTask task = (CommitTask)o;
            return this.document.equals(task.document) && this.project.equals(task.project);
        }

        public int hashCode() {
            int result = this.document.hashCode();
            result = 31 * result + this.project.hashCode();
            return result;
        }
    }
}

