/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconLayerProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.PsiIconUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ui.EmptyIcon;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementBase
extends UserDataHolderBase
implements Iconable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.ElementBase");
    public static final int FLAGS_LOCKED = 2048;
    private static final NullableFunction<ElementIconRequest, Icon> ICON_COMPUTE = new NullableFunction<ElementIconRequest, Icon>(){

        @Override
        public Icon fun(ElementIconRequest request) {
            PsiElement element = request.getElement();
            if (element == null || !element.isValid()) {
                return null;
            }
            if (element.getProject().isDisposed()) {
                return null;
            }
            return ElementBase.computeIconNow(element, request.getFlags());
        }
    };
    private static final Key<TIntObjectHashMap<Icon>> BASE_ICONS = Key.create("BASE_ICONS");
    private static final NotNullLazyValue<Icon> VISIBILITY_ICON_PLACEHOLDER = new NotNullLazyValue<Icon>(){

        @Override
        @NotNull
        protected Icon compute() {
            Icon icon = EmptyIcon.create(PlatformIcons.PUBLIC_ICON);
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ElementBase$2", "compute"));
            }
            return icon;
        }
    };
    public static final NotNullLazyValue<Icon> ICON_PLACEHOLDER = new NotNullLazyValue<Icon>(){

        @Override
        @NotNull
        protected Icon compute() {
            Icon icon = AllIcons.Nodes.NodePlaceholder;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ElementBase$3", "compute"));
            }
            return icon;
        }
    };
    private static final List<IconLayer> ourIconLayers = new ArrayList<IconLayer>();

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        if (!(this instanceof PsiElement)) {
            return null;
        }
        try {
            Icon icon = this.computeIcon(flags);
            Iconable.LastComputedIcon.put(this, icon, flags);
            return icon;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (IndexNotReadyException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Icon computeIcon(int flags) {
        PsiElement psiElement = (PsiElement)((Object)this);
        if (!psiElement.isValid()) {
            return null;
        }
        if (Registry.is("psi.deferIconLoading")) {
            Icon baseIcon = Iconable.LastComputedIcon.get(psiElement, flags);
            if (baseIcon == null) {
                TIntObjectHashMap<Icon> cache = this.getUserData(BASE_ICONS);
                if (cache == null) {
                    cache = this.putUserDataIfAbsent(BASE_ICONS, new TIntObjectHashMap());
                }
                TIntObjectHashMap<Icon> tIntObjectHashMap = cache;
                synchronized (tIntObjectHashMap) {
                    if (!cache.containsKey(flags)) {
                        cache.put(flags, this.computeBaseIcon(flags));
                    }
                    baseIcon = cache.get(flags);
                }
            }
            return IconDeferrer.getInstance().defer(baseIcon, new ElementIconRequest(psiElement, flags), ICON_COMPUTE);
        }
        return ElementBase.computeIconNow(psiElement, flags);
    }

    @Nullable
    private static Icon computeIconNow(PsiElement element, int flags) {
        Icon providersIcon = PsiIconUtil.getProvidersIcon(element, flags);
        if (providersIcon != null) {
            return providersIcon instanceof RowIcon ? (RowIcon)providersIcon : ElementBase.createLayeredIcon(element, providersIcon, flags);
        }
        return ((ElementBase)((Object)element)).getElementIcon(flags);
    }

    protected Icon computeBaseIcon(int flags) {
        return this.isVisibilitySupported() ? this.getAdjustedBaseIcon(this.getBaseIcon(), flags) : this.getBaseIcon();
    }

    protected Icon getBaseIcon() {
        PsiFile file;
        if (this instanceof PsiElement && (file = ((PsiElement)((Object)this)).getContainingFile()) != null && !ElementBase.isNativeFileType(file.getFileType())) {
            return file.getFileType().getIcon();
        }
        return ICON_PLACEHOLDER.getValue();
    }

    public static boolean isNativeFileType(FileType fileType) {
        return fileType instanceof INativeFileType && ((INativeFileType)fileType).useNativeIcon() || fileType instanceof UnknownFileType;
    }

    protected Icon getAdjustedBaseIcon(Icon icon, int flags) {
        Icon result = icon;
        if ((flags & 1) > 0) {
            RowIcon rowIcon = new RowIcon(2);
            rowIcon.setIcon(icon, 0);
            rowIcon.setIcon(VISIBILITY_ICON_PLACEHOLDER.getValue(), 1);
            result = rowIcon;
        }
        return result;
    }

    protected boolean isVisibilitySupported() {
        return false;
    }

    public static Icon overlayIcons(Icon ... icons) {
        LayeredIcon icon = new LayeredIcon(icons.length);
        int i = 0;
        for (Icon ic : icons) {
            icon.setIcon(ic, i++);
        }
        return icon;
    }

    public static RowIcon buildRowIcon(Icon baseIcon, Icon visibilityIcon) {
        RowIcon icon = new RowIcon(2);
        icon.setIcon(baseIcon, 0);
        icon.setIcon(visibilityIcon, 1);
        return icon;
    }

    public static Icon iconWithVisibilityIfNeeded(int flags, Icon baseIcon, Icon visibility) {
        return (flags & 1) != 0 ? ElementBase.buildRowIcon(baseIcon, visibility) : baseIcon;
    }

    @Nullable
    protected Icon getElementIcon(int flags) {
        int elementFlags;
        PsiElement element = (PsiElement)((Object)this);
        if (!element.isValid()) {
            return null;
        }
        boolean isLocked = (flags & 2) != 0 && !element.isWritable();
        int n = elementFlags = isLocked ? 2048 : 0;
        if (!(element instanceof ItemPresentation) || ((ItemPresentation)((Object)element)).getIcon(false) == null) {
            if (element instanceof PsiFile) {
                PsiFile file = (PsiFile)element;
                VirtualFile virtualFile = file.getVirtualFile();
                Icon fileTypeIcon = virtualFile == null ? file.getFileType().getIcon() : IconUtil.getIcon(virtualFile, flags & 0xFFFFFFFD, file.getProject());
                return ElementBase.createLayeredIcon(this, fileTypeIcon, elementFlags);
            }
            return null;
        }
        RowIcon baseIcon = ElementBase.createLayeredIcon(this, ((ItemPresentation)((Object)element)).getIcon(false), elementFlags);
        return baseIcon;
    }

    public static RowIcon createLayeredIcon(Iconable instance, Icon icon, int flags) {
        SmartList<Icon> layersFromProviders = new SmartList<Icon>();
        for (IconLayerProvider provider : Extensions.getExtensions(IconLayerProvider.EP_NAME)) {
            Icon layerIcon = provider.getLayerIcon(instance, (flags & 0x800) != 0);
            if (layerIcon == null) continue;
            layersFromProviders.add(layerIcon);
        }
        if (flags != 0 || !layersFromProviders.isEmpty()) {
            SmartList<Icon> iconLayers = new SmartList<Icon>();
            for (IconLayer l : ourIconLayers) {
                if ((flags & l.flagMask) == 0) continue;
                iconLayers.add(l.icon);
            }
            iconLayers.addAll(layersFromProviders);
            LayeredIcon layeredIcon = new LayeredIcon(1 + iconLayers.size());
            layeredIcon.setIcon(icon, 0);
            for (int i = 0; i < iconLayers.size(); ++i) {
                Icon icon1 = (Icon)iconLayers.get(i);
                layeredIcon.setIcon(icon1, i + 1);
            }
            icon = layeredIcon;
        }
        RowIcon baseIcon = new RowIcon(2);
        baseIcon.setIcon(icon, 0);
        return baseIcon;
    }

    public static int transformFlags(PsiElement element, int _flags) {
        boolean isLocked;
        int flags = _flags & 0xFFFFFFFD;
        boolean bl = isLocked = (_flags & 2) != 0 && !element.isWritable();
        if (isLocked) {
            flags |= 0x800;
        }
        return flags;
    }

    public static void registerIconLayer(int flagMask, Icon icon) {
        for (IconLayer iconLayer : ourIconLayers) {
            if (iconLayer.flagMask != flagMask) continue;
            return;
        }
        ourIconLayers.add(new IconLayer(flagMask, icon));
    }

    private static class IconLayer {
        int flagMask;
        Icon icon;

        IconLayer(int flagMask, Icon icon) {
            this.flagMask = flagMask;
            this.icon = icon;
        }
    }

    private static class ElementIconRequest {
        private final SmartPsiElementPointer<?> myPointer;
        private final int myFlags;

        public ElementIconRequest(PsiElement element, int flags) {
            this.myPointer = SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element);
            this.myFlags = flags;
        }

        @Nullable
        public PsiElement getElement() {
            if (this.myPointer.getProject().isDisposed()) {
                return null;
            }
            Object element = this.myPointer.getElement();
            SmartPointerManager.getInstance(this.myPointer.getProject()).removePointer(this.myPointer);
            return element;
        }

        public int getFlags() {
            return this.myFlags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementIconRequest)) {
                return false;
            }
            ElementIconRequest request = (ElementIconRequest)o;
            if (this.myFlags != request.myFlags) {
                return false;
            }
            return this.myPointer.equals(request.myPointer);
        }

        public int hashCode() {
            int result = this.myPointer.hashCode();
            result = 31 * result + this.myFlags;
            return result;
        }
    }
}

