/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class TextBlock {
    private static final Key<TextBlock> KEY_TEXT_BLOCK = Key.create("KEY_TEXT_BLOCK");
    private Document myDocument;
    private int myStartOffset = -1;
    private int myTextEndOffset = -1;
    private int myPsiEndOffset = -1;
    private boolean myIsLocked = false;

    public boolean isEmpty() {
        return this.myStartOffset == -1;
    }

    public void clear() {
        this.myStartOffset = -1;
        this.myDocument = null;
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getTextEndOffset() {
        return this.myTextEndOffset;
    }

    private void lock() {
        this.myIsLocked = true;
    }

    private void unlock() {
        this.myIsLocked = false;
    }

    public boolean isLocked() {
        return this.myIsLocked;
    }

    public int getPsiEndOffset() {
        return this.myPsiEndOffset;
    }

    public void documentChanged(DocumentEvent e) {
        this.myDocument = e.getDocument();
        assert (!this.myIsLocked);
        int offset = e.getOffset();
        if (this.isEmpty()) {
            this.myStartOffset = offset;
            this.myTextEndOffset = offset + e.getNewLength();
            this.myPsiEndOffset = offset + e.getOldLength();
        } else {
            int shift = offset + e.getOldLength() - this.myTextEndOffset;
            if (shift > 0) {
                this.myPsiEndOffset += shift;
                this.myTextEndOffset = offset + e.getNewLength();
            } else {
                this.myTextEndOffset += e.getNewLength() - e.getOldLength();
            }
            this.myStartOffset = Math.min(this.myStartOffset, offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAtomically(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/TextBlock", "performAtomically"));
        }
        assert (!this.isLocked());
        this.lock();
        try {
            runnable.run();
        }
        finally {
            this.unlock();
        }
    }

    @NotNull
    public static TextBlock get(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/TextBlock", "get"));
        }
        TextBlock textBlock = file.getUserData(KEY_TEXT_BLOCK);
        if (textBlock == null) {
            textBlock = ((UserDataHolderEx)((Object)file)).putUserDataIfAbsent(KEY_TEXT_BLOCK, new TextBlock());
        }
        TextBlock textBlock2 = textBlock;
        if (textBlock2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/TextBlock", "get"));
        }
        return textBlock2;
    }

    public String toString() {
        return "TextBlock{myStartOffset=" + this.myStartOffset + ", myTextEndOffset=" + this.myTextEndOffset + ", myPsiEndOffset=" + this.myPsiEndOffset + ", myIsLocked=" + this.myIsLocked + '}';
    }
}

