/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.util.ProperTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.smartPointers.FileElementInfo;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import org.jetbrains.annotations.NotNull;

class SmartPsiFileRangePointerImpl
extends SmartPsiElementPointerImpl<PsiFile>
implements SmartPsiFileRange {
    SmartPsiFileRangePointerImpl(@NotNull PsiFile containingFile, @NotNull ProperTextRange range) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "<init>"));
        }
        super(containingFile, SmartPsiFileRangePointerImpl.createElementInfo(containingFile, range), PsiFile.class);
    }

    @NotNull
    private static SmartPointerElementInfo createElementInfo(@NotNull PsiFile containingFile, @NotNull ProperTextRange range) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "createElementInfo"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "createElementInfo"));
        }
        if (range.equals(containingFile.getTextRange())) {
            FileElementInfo fileElementInfo = new FileElementInfo(containingFile);
            if (fileElementInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "createElementInfo"));
            }
            return fileElementInfo;
        }
        SelfElementInfo selfElementInfo = new SelfElementInfo(containingFile.getProject(), range, PsiElement.class, containingFile, containingFile.getLanguage());
        if (selfElementInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "createElementInfo"));
        }
        return selfElementInfo;
    }

    @Override
    public PsiFile getElement() {
        if (this.getRange() == null) {
            return null;
        }
        return this.getContainingFile();
    }
}

