/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ConstructorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.element.ModifierFilter;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.SourceJavaCodeReference;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.VariableResolverProcessor;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ICodeFragmentElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.SourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaCodeReferenceElementImpl
extends CompositePsiElement
implements PsiJavaCodeReferenceElement,
SourceJavaCodeReference {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl");
    private volatile String myCachedQName = null;
    private volatile String myCachedNormalizedText;
    private int myKindWhenDummy = 1;
    public static final int CLASS_NAME_KIND = 1;
    public static final int PACKAGE_NAME_KIND = 2;
    public static final int CLASS_OR_PACKAGE_NAME_KIND = 3;
    public static final int CLASS_FQ_NAME_KIND = 4;
    public static final int CLASS_FQ_OR_PACKAGE_NAME_KIND = 5;
    public static final int CLASS_IN_QUALIFIED_NEW_KIND = 6;
    private final int myHC = ourHC++;

    public PsiJavaCodeReferenceElementImpl() {
        super(JavaElementType.JAVA_CODE_REFERENCE);
    }

    public final int hashCode() {
        return this.myHC;
    }

    @Override
    public int getTextOffset() {
        ASTNode refName = this.getReferenceNameNode();
        return refName != null ? refName.getStartOffset() : super.getTextOffset();
    }

    public void setKindWhenDummy(int kind) {
        LOG.assertTrue(PsiJavaCodeReferenceElementImpl.isDummy(this.getTreeParent().getElementType()));
        this.myKindWhenDummy = kind;
    }

    private static boolean isDummy(IElementType type) {
        return type == TokenType.DUMMY_HOLDER || type == JavaElementType.DUMMY_ELEMENT;
    }

    public int getKind() {
        LOG.assertTrue(this.isValid());
        CompositeElement treeParent = this.getTreeParent();
        IElementType i = treeParent.getElementType();
        if (PsiJavaCodeReferenceElementImpl.isDummy(i)) {
            return this.myKindWhenDummy;
        }
        if (i == JavaElementType.TYPE) {
            return treeParent.getTreeParent().getPsi() instanceof PsiTypeCodeFragment ? 3 : 1;
        }
        if (i == JavaElementType.EXTENDS_LIST || i == JavaElementType.IMPLEMENTS_LIST || i == JavaElementType.EXTENDS_BOUND_LIST || i == JavaElementType.THROWS_LIST || i == JavaElementType.THIS_EXPRESSION || i == JavaElementType.SUPER_EXPRESSION || i == JavaDocElementType.DOC_METHOD_OR_FIELD_REF || i == JavaDocElementType.DOC_TAG_VALUE_ELEMENT || i == JavaElementType.REFERENCE_PARAMETER_LIST || i == JavaElementType.ANNOTATION) {
            if (this.isQualified()) {
                return 3;
            }
            return 1;
        }
        if (i == JavaElementType.NEW_EXPRESSION) {
            ASTNode qualifier = treeParent.findChildByRole(54);
            return qualifier != null ? 6 : 1;
        }
        if (i == JavaElementType.ANONYMOUS_CLASS) {
            if (treeParent.getChildRole(this) == 78) {
                LOG.assertTrue(treeParent.getTreeParent().getElementType() == JavaElementType.NEW_EXPRESSION);
                ASTNode qualifier = treeParent.getTreeParent().findChildByRole(54);
                return qualifier != null ? 6 : 1;
            }
            return 3;
        }
        if (i == JavaElementType.PACKAGE_STATEMENT) {
            return 2;
        }
        if (i == JavaElementType.IMPORT_STATEMENT) {
            boolean isOnDemand = ((PsiImportStatement)SourceTreeToPsiMap.treeToPsiNotNull(treeParent)).isOnDemand();
            return isOnDemand ? 5 : 4;
        }
        if (i == JavaElementType.IMPORT_STATIC_STATEMENT) {
            return 5;
        }
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            int parentKind = ((PsiJavaCodeReferenceElementImpl)treeParent).getKind();
            if (parentKind == 1) {
                return 3;
            }
            if (parentKind == 4) {
                return 5;
            }
            return parentKind;
        }
        if (i == JavaElementType.CLASS || i == JavaElementType.PARAMETER_LIST || i == TokenType.ERROR_ELEMENT) {
            return 3;
        }
        if (i == JavaElementType.IMPORT_STATIC_REFERENCE) {
            return 5;
        }
        if (i == JavaDocElementType.DOC_TAG || i == JavaDocElementType.DOC_INLINE_TAG || i == JavaDocElementType.DOC_REFERENCE_HOLDER || i == JavaDocElementType.DOC_TYPE_HOLDER) {
            PsiDocComment docComment = PsiTreeUtil.getParentOfType((PsiElement)this, PsiDocComment.class);
            if (docComment != null && docComment.getOwner() == null && docComment.getParent() instanceof PsiJavaFile) {
                return 5;
            }
            return 3;
        }
        if (PsiJavaCodeReferenceElementImpl.isCodeFragmentType(i)) {
            PsiJavaCodeReferenceCodeFragment fragment = (PsiJavaCodeReferenceCodeFragment)treeParent.getPsi();
            return fragment.isClassesAccepted() ? 5 : 2;
        }
        this.diagnoseUnknownParent();
        return 1;
    }

    private void diagnoseUnknownParent() {
        CompositeElement parent;
        IElementType i = parent.getElementType();
        String message = "Unknown parent for java code reference: '" + parent + "'; Type: " + i + ";\n";
        for (parent = this.getTreeParent(); parent != null && parent.getPsi() instanceof PsiExpression; parent = parent.getTreeParent()) {
            message = message + " Parent: '" + parent + "'; \n";
        }
        if (parent != null) {
            message = message + DebugUtil.treeToString(parent, false);
        }
        LOG.error(message);
    }

    private static boolean isCodeFragmentType(IElementType type) {
        return type == TokenType.CODE_FRAGMENT || type instanceof ICodeFragmentElementType;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "deleteChildInternal"));
        }
        if (this.getChildRole(child) == 54) {
            ASTNode dot = this.findChildByType(JavaTokenType.DOT, child);
            assert (dot != null) : this;
            this.deleteChildRange(child.getPsi(), dot.getPsi());
            List<PsiAnnotation> annotations = PsiTreeUtil.getChildrenOfTypeAsList(this, PsiAnnotation.class);
            this.setAnnotations(annotations);
            return;
        }
        super.deleteChildInternal(child);
    }

    @Override
    public final ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 53: {
                return TreeUtil.findChildBackward(this, JavaTokenType.IDENTIFIER);
            }
            case 246: {
                TreeElement lastChild = this.getLastChildNode();
                return lastChild.getElementType() == JavaElementType.REFERENCE_PARAMETER_LIST ? lastChild : null;
            }
            case 54: {
                return this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
            }
            case 55: {
                return this.findChildByType(JavaTokenType.DOT);
            }
        }
        return null;
    }

    @Override
    public final int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.REFERENCE_PARAMETER_LIST) {
            return 246;
        }
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return 53;
        }
        return 0;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        switch (this.getKind()) {
            case 1: 
            case 3: 
            case 6: {
                PsiElement target = this.resolve();
                if (target instanceof PsiClass) {
                    PsiType[] types;
                    PsiClass aClass = (PsiClass)target;
                    String name = aClass.getQualifiedName();
                    if (name == null) {
                        name = aClass.getName();
                    }
                    if ((types = this.getTypeParameters()).length == 0) {
                        PsiElement qualifier = this.getQualifier();
                        if (qualifier instanceof PsiJavaCodeReferenceElement) {
                            String string = StringUtil.getQualifiedName(((PsiJavaCodeReferenceElement)qualifier).getCanonicalText(), aClass.getName());
                            if (string == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getCanonicalText"));
                            }
                            return string;
                        }
                        String string = name;
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getCanonicalText"));
                        }
                        return string;
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.append(name);
                    buf.append('<');
                    for (int i = 0; i < types.length; ++i) {
                        if (i > 0) {
                            buf.append(',');
                        }
                        buf.append(types[i].getCanonicalText());
                    }
                    buf.append('>');
                    String string = buf.toString();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getCanonicalText"));
                    }
                    return string;
                }
                if (target instanceof PsiPackage) {
                    String string = ((PsiPackage)target).getQualifiedName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getCanonicalText"));
                    }
                    return string;
                }
                LOG.assertTrue(target == null, target);
                String string = this.getNormalizedText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getCanonicalText"));
                }
                return string;
            }
            case 2: 
            case 4: 
            case 5: {
                String string = this.getNormalizedText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getCanonicalText"));
                }
                return string;
            }
        }
        LOG.assertTrue(false);
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getCanonicalText"));
        }
        return null;
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    public final PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        JavaResolveResult javaResolveResult = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "advancedResolve"));
        }
        return javaResolveResult;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        boolean valid;
        FileElement fileElement = SharedImplUtil.findFileElement(this);
        if (fileElement == null) {
            LOG.error("fileElement == null!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "multiResolve"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiManagerEx manager = fileElement.getManager();
        if (manager == null) {
            LOG.error("getManager() == null!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "multiResolve"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiFile file = SharedImplUtil.getContainingFile(fileElement);
        boolean bl = valid = file != null && file.isValid();
        if (!valid) {
            LOG.error("invalid!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "multiResolve"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        Project project = manager.getProject();
        ResolveCache resolveCache = ResolveCache.getInstance(project);
        ResolveResult[] results = resolveCache.resolveWithCaching(this, OurGenericsResolver.INSTANCE, true, incompleteCode, file);
        JavaResolveResult[] javaResolveResultArray = results.length == 0 ? JavaResolveResult.EMPTY_ARRAY : (JavaResolveResult[])results;
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "multiResolve"));
        }
        return javaResolveResultArray;
    }

    private PsiSubstitutor updateSubstitutor(PsiSubstitutor subst, PsiClass psiClass) {
        PsiType[] parameters = this.getTypeParameters();
        if (psiClass != null) {
            subst = subst.putAll(psiClass, parameters);
        }
        return subst;
    }

    private JavaResolveResult[] resolve(int kind) {
        switch (kind) {
            case 4: {
                PsiFile file;
                String text = this.getNormalizedText();
                if (StringUtil.isEmptyOrSpaces(text)) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiClass aClass = JavaPsiFacade.getInstance(this.getProject()).findClass(text, this.getResolveScope());
                if (aClass == null) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                if (!this.isQualified() && text.equals(aClass.getQualifiedName()) && (file = this.getContainingFile()) instanceof PsiJavaFile && !((PsiJavaFile)file).getPackageName().isEmpty()) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                return new JavaResolveResult[]{new CandidateInfo((PsiElement)aClass, this.updateSubstitutor(PsiSubstitutor.EMPTY, aClass), this, false)};
            }
            case 6: {
                PsiElement parent = this.getParent();
                if (parent instanceof JavaDummyHolder) {
                    parent = parent.getContext();
                }
                if (parent instanceof PsiAnonymousClass) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof PsiNewExpression)) {
                    if (parent instanceof PsiJavaCodeReferenceElement) {
                        return JavaResolveResult.EMPTY_ARRAY;
                    }
                    LOG.error("Invalid java reference!");
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiExpression qualifier = ((PsiNewExpression)parent).getQualifier();
                LOG.assertTrue(qualifier != null);
                PsiType qualifierType = qualifier.getType();
                if (qualifierType == null) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                if (!(qualifierType instanceof PsiClassType)) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiClassType.ClassResolveResult result = PsiUtil.resolveGenericsClassInType(qualifierType);
                PsiElement resultElement = result.getElement();
                if (resultElement == null) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiElement classNameElement = this.getReferenceNameElement();
                if (!(classNameElement instanceof PsiIdentifier)) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                String className = classNameElement.getText();
                ClassResolverProcessor processor = new ClassResolverProcessor(className, this, this.getContainingFile());
                resultElement.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, result.getSubstitutor()), this, this);
                return processor.getResult();
            }
            case 1: {
                PsiElement classNameElement = this.getReferenceNameElement();
                if (!(classNameElement instanceof PsiIdentifier)) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                String className = classNameElement.getText();
                ClassResolverProcessor processor = new ClassResolverProcessor(className, this, this.getContainingFile());
                PsiScopesUtil.resolveAndWalk(processor, this, null);
                return processor.getResult();
            }
            case 2: {
                String packageName = this.getNormalizedText();
                Project project = this.getManager().getProject();
                PsiPackage aPackage = JavaPsiFacade.getInstance(project).findPackage(packageName);
                if (aPackage == null || !aPackage.isValid()) {
                    return JavaPsiFacade.getInstance(project).isPartOfPackagePrefix(packageName) ? CandidateInfo.RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE : JavaResolveResult.EMPTY_ARRAY;
                }
                return new JavaResolveResult[]{new CandidateInfo(aPackage, PsiSubstitutor.EMPTY)};
            }
            case 3: 
            case 5: {
                int classKind = kind == 3 ? 1 : 4;
                JavaResolveResult[] result = this.resolve(classKind);
                if (result.length == 1 && !result[0].isAccessible()) {
                    JavaResolveResult[] packageResult = this.resolve(2);
                    if (packageResult.length != 0) {
                        result = packageResult;
                    }
                } else if (result.length == 0) {
                    result = this.resolve(2);
                }
                return result;
            }
        }
        LOG.error(this);
        return JavaResolveResult.EMPTY_ARRAY;
    }

    @Override
    public final PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier = this.getReferenceNameElement();
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createIdentifier(newElementName);
        oldIdentifier.replace(identifier);
        return this;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "bindToElement"));
        }
        CheckUtil.checkWritable(this);
        if (this.isReferenceTo(element)) {
            return this;
        }
        switch (this.getKind()) {
            case 1: 
            case 4: {
                if (!(element instanceof PsiClass)) {
                    throw PsiJavaCodeReferenceElementImpl.cannotBindError(element);
                }
                return this.bindToClass((PsiClass)element);
            }
            case 2: {
                if (!(element instanceof PsiPackage)) {
                    throw PsiJavaCodeReferenceElementImpl.cannotBindError(element);
                }
                return this.bindToPackage((PsiPackage)element);
            }
            case 3: 
            case 5: {
                if (element instanceof PsiClass) {
                    return this.bindToClass((PsiClass)element);
                }
                if (element instanceof PsiPackage) {
                    return this.bindToPackage((PsiPackage)element);
                }
                throw PsiJavaCodeReferenceElementImpl.cannotBindError(element);
            }
            case 6: {
                if (element instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)element;
                    String name = aClass.getName();
                    if (name == null) {
                        throw new IncorrectOperationException(aClass.toString());
                    }
                    PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
                    PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(name, this.getParent());
                    this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
                    return ref;
                }
                throw PsiJavaCodeReferenceElementImpl.cannotBindError(element);
            }
        }
        LOG.assertTrue(false);
        return null;
    }

    private static IncorrectOperationException cannotBindError(PsiElement element) {
        return new IncorrectOperationException("Cannot bind to " + element);
    }

    private PsiElement bindToClass(PsiClass aClass) throws IncorrectOperationException {
        String qName = aClass.getQualifiedName();
        boolean preserveQualification = JavaCodeStyleSettingsFacade.getInstance(this.getProject()).useFQClassNames() && this.isFullyQualified();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(this.getProject());
        if (qName == null) {
            qName = aClass.getName();
            PsiClass psiClass = facade.getResolveHelper().resolveReferencedClass(qName, this);
            if (!this.getManager().areElementsEquivalent(psiClass, aClass)) {
                throw PsiJavaCodeReferenceElementImpl.cannotBindError(aClass);
            }
        } else if (facade.findClass(qName, this.getResolveScope()) == null && !preserveQualification) {
            return this;
        }
        List<PsiAnnotation> annotations = this.getAnnotations();
        String text = qName;
        PsiReferenceParameterList parameterList = this.getParameterList();
        if (parameterList != null) {
            text = text + parameterList.getText();
        }
        PsiJavaCodeReferenceElement ref = facade.getParserFacade().createReferenceFromText(text, this.getParent());
        this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
        ((PsiJavaCodeReferenceElementImpl)ref).setAnnotations(annotations);
        if (!preserveQualification) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(aClass.getProject());
            ref = (PsiJavaCodeReferenceElement)codeStyleManager.shortenClassReferences(ref, 8192);
        }
        return ref;
    }

    private List<PsiAnnotation> getAnnotations() {
        List<PsiAnnotation> typeAnnotations;
        PsiModifierList modifierList;
        List<PsiAnnotation> annotations = PsiTreeUtil.getChildrenOfTypeAsList(this, PsiAnnotation.class);
        if (!this.isQualified() && (modifierList = PsiImplUtil.findNeighbourModifierList(this)) != null && (typeAnnotations = PsiImplUtil.getTypeUseAnnotations(modifierList)) != null && typeAnnotations.size() > 0) {
            annotations.addAll(typeAnnotations);
        }
        return annotations;
    }

    private void setAnnotations(List<PsiAnnotation> annotations) {
        PsiModifierList modifierList;
        if (annotations.isEmpty()) {
            return;
        }
        PsiElement newParent = this;
        PsiElement anchor = SourceTreeToPsiMap.treeElementToPsi(this.findChildByType(JavaTokenType.DOT));
        if (anchor == null && (modifierList = PsiImplUtil.findNeighbourModifierList(this)) != null) {
            newParent = modifierList;
        }
        for (PsiAnnotation annotation : annotations) {
            if (annotation.getParent() == newParent) continue;
            newParent.addAfter(annotation, anchor);
            annotation.delete();
        }
    }

    private boolean isFullyQualified() {
        switch (this.getKind()) {
            case 3: {
                if (this.resolve() instanceof PsiPackage) {
                    return true;
                }
            }
            case 1: {
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
            default: {
                LOG.assertTrue(false);
                return true;
            }
        }
        ASTNode qualifier = this.findChildByRole(54);
        if (qualifier == null) {
            return false;
        }
        LOG.assertTrue(qualifier.getElementType() == JavaElementType.JAVA_CODE_REFERENCE);
        PsiElement refElement = ((PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeToPsiNotNull(qualifier)).resolve();
        if (refElement instanceof PsiPackage) {
            return true;
        }
        return ((PsiJavaCodeReferenceElementImpl)SourceTreeToPsiMap.treeToPsiNotNull(qualifier)).isFullyQualified();
    }

    private PsiElement bindToPackage(PsiPackage aPackage) throws IncorrectOperationException {
        String qName = aPackage.getQualifiedName();
        if (qName.isEmpty()) {
            throw new IncorrectOperationException("Cannot bind to default package: " + aPackage);
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
        PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(qName, this.getParent());
        this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
        return ref;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        switch (this.getKind()) {
            case 1: 
            case 6: {
                if (element instanceof PsiClass) break;
                return false;
            }
            case 4: {
                if (!(element instanceof PsiClass)) {
                    return false;
                }
                String qName = ((PsiClass)element).getQualifiedName();
                return qName != null && qName.equals(this.getCanonicalText());
            }
            case 2: {
                if (!(element instanceof PsiPackage)) {
                    return false;
                }
                String qName = ((PsiPackage)element).getQualifiedName();
                return qName.equals(this.getCanonicalText());
            }
            case 3: {
                if (element instanceof PsiPackage) {
                    String qName = ((PsiPackage)element).getQualifiedName();
                    return qName.equals(this.getCanonicalText());
                }
                if (element instanceof PsiClass) {
                    PsiIdentifier nameIdentifier = ((PsiClass)element).getNameIdentifier();
                    if (nameIdentifier == null) {
                        return false;
                    }
                    PsiElement nameElement = this.getReferenceNameElement();
                    return nameElement != null && nameElement.textMatches(nameIdentifier) && element.getManager().areElementsEquivalent(this.resolve(), element);
                }
                return false;
            }
            case 5: {
                if (element instanceof PsiClass) {
                    String qName = ((PsiClass)element).getQualifiedName();
                    return qName != null && qName.equals(this.getCanonicalText());
                }
                if (element instanceof PsiPackage) {
                    String qName = ((PsiPackage)element).getQualifiedName();
                    return qName.equals(this.getCanonicalText());
                }
                return false;
            }
            default: {
                LOG.assertTrue(false);
                return true;
            }
        }
        ASTNode referenceNameElement = this.getReferenceNameNode();
        if (referenceNameElement == null || referenceNameElement.getElementType() != JavaTokenType.IDENTIFIER) {
            return false;
        }
        String name = ((PsiClass)element).getName();
        return name != null && referenceNameElement.getText().equals(name) && element.getManager().areElementsEquivalent(this.resolve(), element);
    }

    private String getNormalizedText() {
        String whiteSpaceAndComments = this.myCachedNormalizedText;
        if (whiteSpaceAndComments == null) {
            this.myCachedNormalizedText = whiteSpaceAndComments = SourceUtil.getReferenceText(this);
        }
        return whiteSpaceAndComments;
    }

    @Override
    public String getClassNameText() {
        String cachedQName = this.myCachedQName;
        if (cachedQName == null) {
            this.myCachedQName = cachedQName = PsiNameHelper.getQualifiedClassName(this.getNormalizedText(), false);
        }
        return cachedQName;
    }

    @Override
    public void fullyQualify(PsiClass targetClass) {
        int kind = this.getKind();
        if (kind != 1 && kind != 3 && kind != 6) {
            LOG.error("Wrong kind " + kind);
            return;
        }
        JavaSourceUtil.fullyQualifyReference(this, targetClass);
    }

    @Override
    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    public PsiElement getQualifier() {
        return SourceTreeToPsiMap.treeElementToPsi(this.findChildByRole(54));
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedQName = null;
        this.myCachedNormalizedText = null;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        ElementFilter filter;
        switch (this.getKind()) {
            case 3: {
                filter = new OrFilter();
                ((OrFilter)filter).addFilter(ElementClassFilter.CLASS);
                ((OrFilter)filter).addFilter(ElementClassFilter.PACKAGE_FILTER);
                break;
            }
            case 1: {
                filter = ElementClassFilter.CLASS;
                break;
            }
            case 2: {
                filter = ElementClassFilter.PACKAGE_FILTER;
                break;
            }
            case 4: 
            case 5: {
                filter = new OrFilter();
                ((OrFilter)filter).addFilter(ElementClassFilter.PACKAGE_FILTER);
                if (!this.isQualified()) break;
                ((OrFilter)filter).addFilter(ElementClassFilter.CLASS);
                break;
            }
            case 6: {
                filter = ElementClassFilter.CLASS;
                break;
            }
            default: {
                throw new RuntimeException("Unknown reference type");
            }
        }
        Object[] objectArray = PsiImplUtil.getReferenceVariantsByFilter(this, filter);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getVariants"));
        }
        return objectArray;
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "processVariants"));
        }
        OrFilter filter = new OrFilter();
        if (this.isInCode() && !(this.getParent() instanceof PsiImportStatement)) {
            filter.addFilter(new AndFilter((ElementFilter)ElementClassFilter.METHOD, (ElementFilter)new NotFilter(new ConstructorFilter())));
            filter.addFilter(ElementClassFilter.VARIABLE);
        }
        switch (this.getKind()) {
            case 3: {
                filter.addFilter(ElementClassFilter.CLASS);
                filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
                break;
            }
            case 1: {
                filter.addFilter(ElementClassFilter.CLASS);
                if (!this.isQualified()) break;
                filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
                break;
            }
            case 2: {
                filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
                break;
            }
            case 4: 
            case 5: {
                filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
                if (!this.isQualified()) break;
                filter.addFilter(ElementClassFilter.CLASS);
                break;
            }
            case 6: {
                PsiElement parent = this.getParent();
                if (parent instanceof PsiNewExpression) {
                    PsiExpression qualifier = ((PsiNewExpression)parent).getQualifier();
                    assert (qualifier != null) : parent;
                    PsiType type = qualifier.getType();
                    PsiClass aClass = PsiUtil.resolveClassInType(type);
                    if (aClass != null) {
                        aClass.processDeclarations(new FilterScopeProcessor((ElementFilter)new AndFilter((ElementFilter)ElementClassFilter.CLASS, (ElementFilter)new ModifierFilter("static", false)), processor), ResolveState.initial(), null, this);
                    }
                }
                return;
            }
            default: {
                throw new RuntimeException("Unknown reference type");
            }
        }
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)filter, processor);
        PsiScopesUtil.resolveAndWalk(proc, this, null, true);
    }

    private boolean isInCode() {
        if (PsiJavaCodeReferenceElementImpl.isCodeFragmentType(this.getTreeParent().getElementType()) || this.getParent() instanceof PsiAnnotation) {
            return false;
        }
        if (this.isQualified()) {
            return true;
        }
        for (PsiElement superParent = this.getParent(); superParent != null; superParent = superParent.getParent()) {
            if (superParent instanceof PsiCodeBlock || superParent instanceof PsiLocalVariable) {
                return true;
            }
            if (!(superParent instanceof PsiClass)) continue;
            return false;
        }
        return false;
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return SourceTreeToPsiMap.treeElementToPsi(this.getReferenceNameNode());
    }

    @Nullable
    private ASTNode getReferenceNameNode() {
        return this.findChildByRole(53);
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return (PsiReferenceParameterList)this.findChildByRoleAsPsiElement(246);
    }

    @Override
    public String getQualifiedName() {
        switch (this.getKind()) {
            case 1: 
            case 3: 
            case 6: {
                PsiElement target = this.resolve();
                if (target instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)target;
                    String name = aClass.getQualifiedName();
                    if (name == null) {
                        name = aClass.getName();
                    }
                    return name;
                }
                if (target instanceof PsiPackage) {
                    return ((PsiPackage)target).getQualifiedName();
                }
                LOG.assertTrue(target == null);
                return this.getClassNameText();
            }
            case 2: 
            case 4: 
            case 5: {
                return this.getNormalizedText();
            }
        }
        LOG.assertTrue(false);
        return null;
    }

    @Override
    public String getReferenceName() {
        ASTNode childByRole = this.getReferenceNameNode();
        if (childByRole == null) {
            return null;
        }
        return childByRole.getText();
    }

    @Override
    public final TextRange getRangeInElement() {
        TreeElement nameChild = (TreeElement)this.getReferenceNameNode();
        if (nameChild == null) {
            return new TextRange(0, this.getTextLength());
        }
        int startOffset = nameChild.getStartOffsetInParent();
        return new TextRange(startOffset, startOffset + nameChild.getTextLength());
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        if (parameterList == null) {
            if (PsiType.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getTypeParameters"));
            }
            return PsiType.EMPTY_ARRAY;
        }
        PsiType[] psiTypeArray = parameterList.getTypeArguments();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getTypeParameters"));
        }
        return psiTypeArray;
    }

    @Override
    public final PsiElement getElement() {
        return this;
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public final String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    private static final class OurGenericsResolver
    implements ResolveCache.PolyVariantResolver<PsiJavaReference> {
        private static final OurGenericsResolver INSTANCE = new OurGenericsResolver();

        private OurGenericsResolver() {
        }

        @Override
        @NotNull
        public JavaResolveResult[] resolve(@NotNull PsiJavaReference ref, boolean incompleteCode) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl$OurGenericsResolver", "resolve"));
            }
            PsiJavaCodeReferenceElementImpl referenceElement = (PsiJavaCodeReferenceElementImpl)ref;
            int kind = referenceElement.getKind();
            JavaResolveResult[] result = referenceElement.resolve(kind);
            if (incompleteCode && result.length == 0 && kind != 4 && kind != 5) {
                VariableResolverProcessor processor = new VariableResolverProcessor(referenceElement);
                PsiScopesUtil.resolveAndWalk(processor, referenceElement, null, incompleteCode);
                result = processor.getResult();
                if (result.length == 0 && kind == 1) {
                    result = referenceElement.resolve(2);
                }
            }
            JavaResolveUtil.substituteResults((PsiJavaCodeReferenceElement)ref, result);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl$OurGenericsResolver", "resolve"));
            }
            return result;
        }
    }
}

