/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.SourceJavaCodeReference;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.CharTable;

public class JavaSourceUtil {
    private JavaSourceUtil() {
    }

    public static void fullyQualifyReference(CompositeElement reference, PsiClass targetClass) {
        if (((SourceJavaCodeReference)((Object)reference)).isQualified()) {
            PsiClass parentClass = targetClass.getContainingClass();
            if (parentClass == null) {
                return;
            }
            ASTNode qualifier = reference.findChildByRole(54);
            if (qualifier instanceof SourceJavaCodeReference) {
                ((SourceJavaCodeReference)((Object)qualifier)).fullyQualify(parentClass);
            }
        } else {
            String qName = targetClass.getQualifiedName();
            if (qName == null) {
                return;
            }
            int i = qName.lastIndexOf(46);
            if (i > 0) {
                String prefix = qName.substring(0, i);
                PsiManagerEx manager = reference.getManager();
                PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(manager.getProject()).getParserFacade();
                TreeElement qualifier = reference instanceof PsiReferenceExpression ? (TreeElement)parserFacade.createExpressionFromText(prefix, null).getNode() : (TreeElement)parserFacade.createReferenceFromText(prefix, null).getNode();
                if (qualifier != null) {
                    CharTable systemCharTab = SharedImplUtil.findCharTableByTree(qualifier);
                    LeafElement dot = Factory.createSingleLeafElement(JavaTokenType.DOT, ".", 0, 1, systemCharTab, manager);
                    qualifier.rawInsertAfterMe(dot);
                    reference.addInternal(qualifier, dot, null, Boolean.FALSE);
                }
            }
        }
    }
}

