/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;

public class PsiConditionalExpressionImpl
extends ExpressionPsiElement
implements PsiConditionalExpression {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiConditionalExpressionImpl");

    public PsiConditionalExpressionImpl() {
        super(JavaElementType.CONDITIONAL_EXPRESSION);
    }

    @Override
    @NotNull
    public PsiExpression getCondition() {
        PsiExpression psiExpression = (PsiExpression)this.findChildByRoleAsPsiElement(32);
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiConditionalExpressionImpl", "getCondition"));
        }
        return psiExpression;
    }

    @Override
    public PsiExpression getThenExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(112);
    }

    @Override
    public PsiExpression getElseExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(113);
    }

    @Override
    public PsiType getType() {
        PsiType type2;
        PsiExpression expr1 = this.getThenExpression();
        PsiExpression expr2 = this.getElseExpression();
        PsiType type1 = expr1 == null ? null : expr1.getType();
        PsiType psiType = type2 = expr2 == null ? null : expr2.getType();
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        if (type1.equals(type2)) {
            return type1;
        }
        int typeRank1 = TypeConversionUtil.getTypeRank(type1);
        int typeRank2 = TypeConversionUtil.getTypeRank(type2);
        if (type1 instanceof PsiClassType && type2.equals(PsiPrimitiveType.getUnboxedType(type1))) {
            return type2;
        }
        if (type2 instanceof PsiClassType && type1.equals(PsiPrimitiveType.getUnboxedType(type2))) {
            return type1;
        }
        if (TypeConversionUtil.isNumericType(typeRank1) && TypeConversionUtil.isNumericType(typeRank2)) {
            if (typeRank1 == 1 && typeRank2 == 2) {
                return type2;
            }
            if (typeRank1 == 2 && typeRank2 == 1) {
                return type1;
            }
            if (typeRank2 == 4 && (typeRank1 == 1 || typeRank1 == 2 || typeRank1 == 3) && TypeConversionUtil.areTypesAssignmentCompatible(type1, expr2)) {
                return type1;
            }
            if (typeRank1 == 4 && (typeRank2 == 1 || typeRank2 == 2 || typeRank2 == 3) && TypeConversionUtil.areTypesAssignmentCompatible(type2, expr1)) {
                return type2;
            }
            return TypeConversionUtil.binaryNumericPromotion(type1, type2);
        }
        if (TypeConversionUtil.isNullType(type1) && !(type2 instanceof PsiPrimitiveType)) {
            return type2;
        }
        if (TypeConversionUtil.isNullType(type2) && !(type1 instanceof PsiPrimitiveType)) {
            return type1;
        }
        if (TypeConversionUtil.isAssignable(type1, type2, false)) {
            return type1;
        }
        if (TypeConversionUtil.isAssignable(type2, type1, false)) {
            return type2;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher(this)) {
            return null;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull(type1) && (type1 = ((PsiPrimitiveType)type1).getBoxedType(this)) == null) {
            return null;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull(type2) && (type2 = ((PsiPrimitiveType)type2).getBoxedType(this)) == null) {
            return null;
        }
        PsiType leastUpperBound = GenericsUtil.getLeastUpperBound(type1, type2, this.getManager());
        return leastUpperBound != null ? PsiUtil.captureToplevelWildcards(leastUpperBound, this) : null;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 32: {
                return this.getFirstChildNode();
            }
            case 114: {
                return this.findChildByType(JavaTokenType.QUEST);
            }
            case 112: {
                ASTNode quest = this.findChildByRole(114);
                ASTNode child = quest.getTreeNext();
                while (true) {
                    if (child == null) {
                        return null;
                    }
                    if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) break;
                    child = child.getTreeNext();
                }
                return child;
            }
            case 87: {
                return this.findChildByType(JavaTokenType.COLON);
            }
            case 113: 
        }
        ASTNode colon = this.findChildByRole(87);
        if (colon == null) {
            return null;
        }
        return ElementType.EXPRESSION_BIT_SET.contains(this.getLastChildNode().getElementType()) ? this.getLastChildNode() : null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            int role = this.getChildRole(child, 32);
            if (role != 0) {
                return role;
            }
            role = this.getChildRole(child, 112);
            if (role != 0) {
                return role;
            }
            role = this.getChildRole(child, 113);
            return role;
        }
        if (child.getElementType() == JavaTokenType.QUEST) {
            return 114;
        }
        if (child.getElementType() == JavaTokenType.COLON) {
            return 87;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiConditionalExpressionImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitConditionalExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiConditionalExpression:" + this.getText();
    }
}

