/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class DelegatingGlobalSearchScope
extends GlobalSearchScope {
    protected final GlobalSearchScope myBaseScope;
    private final Object myEquality;

    public DelegatingGlobalSearchScope(@NotNull GlobalSearchScope baseScope) {
        if (baseScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/DelegatingGlobalSearchScope", "<init>"));
        }
        super(baseScope.getProject());
        this.myBaseScope = baseScope;
        this.myEquality = ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public DelegatingGlobalSearchScope(GlobalSearchScope baseScope, Object ... equality) {
        super(baseScope.getProject());
        this.myBaseScope = baseScope;
        this.myEquality = Arrays.asList(equality);
    }

    @Override
    public boolean contains(VirtualFile file) {
        return this.myBaseScope.contains(file);
    }

    @Override
    public int compare(VirtualFile file1, VirtualFile file2) {
        return this.myBaseScope.compare(file1, file2);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/DelegatingGlobalSearchScope", "isSearchInModuleContent"));
        }
        return this.myBaseScope.isSearchInModuleContent(aModule);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/DelegatingGlobalSearchScope", "isSearchInModuleContent"));
        }
        return this.myBaseScope.isSearchInModuleContent(aModule, testSources);
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.myBaseScope.isSearchInLibraries();
    }

    @Override
    public boolean isSearchOutsideRootModel() {
        return this.myBaseScope.isSearchOutsideRootModel();
    }

    @Override
    public String getDisplayName() {
        return this.myBaseScope.getDisplayName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegatingGlobalSearchScope that = (DelegatingGlobalSearchScope)o;
        if (!this.myBaseScope.equals(that.myBaseScope)) {
            return false;
        }
        return this.myEquality.equals(that.myEquality);
    }

    @Override
    public int hashCode() {
        int result = this.myBaseScope.hashCode();
        result = 31 * result + this.myEquality.hashCode();
        return result;
    }
}

