/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class CommonProcessors {
    private static final Processor FALSE = new Processor<Object>(){

        @Override
        public boolean process(Object t) {
            return false;
        }
    };
    private static final Processor TRUE = new Processor<Object>(){

        @Override
        public boolean process(Object t) {
            return true;
        }
    };

    public static <T> Processor<T> alwaysTrue() {
        return TRUE;
    }

    public static class FindFirstProcessor<T>
    extends FindProcessor<T> {
        @Override
        protected boolean accept(T t) {
            return true;
        }
    }

    public static abstract class FindProcessor<T>
    implements Processor<T> {
        private T myValue = null;

        @Nullable
        public T getFoundValue() {
            return this.myValue;
        }

        @Override
        public boolean process(T t) {
            if (this.accept(t)) {
                this.myValue = t;
                return false;
            }
            return true;
        }

        protected abstract boolean accept(T var1);
    }

    public static class CollectProcessor<T>
    implements Processor<T> {
        private final Collection<T> myCollection;

        public CollectProcessor(Collection<T> collection) {
            this.myCollection = collection;
        }

        public CollectProcessor() {
            this.myCollection = new ArrayList<T>();
        }

        @Override
        public boolean process(T t) {
            if (this.accept(t)) {
                this.myCollection.add(t);
            }
            return true;
        }

        protected boolean accept(T t) {
            return true;
        }

        public Collection<T> getResults() {
            return this.myCollection;
        }
    }
}

