/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.Collection;
import java.util.List;
import jet.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageUtil;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory0;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.diagnostics.Severity;
import org.jetbrains.jet.lang.diagnostics.SimpleDiagnostic;
import org.jetbrains.jet.lang.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetIdeTemplate;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.AbiVersionUtil;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;

public final class AnalyzerWithCompilerReport {
    @NotNull
    private static final DiagnosticFactory0<PsiErrorElement> SYNTAX_ERROR_FACTORY = DiagnosticFactory0.create(Severity.ERROR);
    @NotNull
    private static final DiagnosticFactory0<JetIdeTemplate> UNRESOLVED_IDE_TEMPLATE_ERROR_FACTORY = DiagnosticFactory0.create(Severity.ERROR);
    private boolean hasErrors = false;
    @NotNull
    private final MessageCollector messageCollectorWrapper;
    @Nullable
    private AnalyzeExhaust analyzeExhaust = null;

    @NotNull
    private static CompilerMessageSeverity convertSeverity(@NotNull Severity severity) {
        switch (severity) {
            case INFO: {
                return CompilerMessageSeverity.INFO;
            }
            case ERROR: {
                return CompilerMessageSeverity.ERROR;
            }
            case WARNING: {
                return CompilerMessageSeverity.WARNING;
            }
        }
        throw new IllegalStateException("Unknown severity: " + (Object)((Object)severity));
    }

    public AnalyzerWithCompilerReport(final @NotNull MessageCollector collector) {
        this.messageCollectorWrapper = new MessageCollector(){

            @Override
            public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
                if (CompilerMessageSeverity.ERRORS.contains((Object)severity)) {
                    AnalyzerWithCompilerReport.this.hasErrors = true;
                }
                collector.report(severity, message, location);
            }
        };
    }

    private static boolean reportDiagnostic(@NotNull Diagnostic diagnostic, @NotNull MessageCollector messageCollector) {
        if (!diagnostic.isValid()) {
            return false;
        }
        DiagnosticUtils.LineAndColumn lineAndColumn = DiagnosticUtils.getLineAndColumn(diagnostic);
        String render = diagnostic instanceof MyDiagnostic ? ((MyDiagnostic)diagnostic).message : DefaultErrorMessages.RENDERER.render(diagnostic);
        messageCollector.report(AnalyzerWithCompilerReport.convertSeverity(diagnostic.getSeverity()), render, MessageUtil.psiFileToMessageLocation(diagnostic.getPsiFile(), null, lineAndColumn.getLine(), lineAndColumn.getColumn()));
        return diagnostic.getSeverity() == Severity.ERROR;
    }

    private void reportIncompleteHierarchies() {
        assert (this.analyzeExhaust != null);
        Collection<ClassDescriptor> incompletes = this.analyzeExhaust.getBindingContext().getKeys(BindingContext.INCOMPLETE_HIERARCHY);
        if (!incompletes.isEmpty()) {
            StringBuilder message = new StringBuilder("The following classes have incomplete hierarchies:\n");
            for (ClassDescriptor incomplete : incompletes) {
                String fqName = DescriptorUtils.getFQName(incomplete).asString();
                message.append("    ").append(fqName).append("\n");
            }
            this.messageCollectorWrapper.report(CompilerMessageSeverity.ERROR, message.toString(), CompilerMessageLocation.NO_LOCATION);
        }
    }

    private void reportAlternativeSignatureErrors() {
        assert (this.analyzeExhaust != null);
        BindingContext bc = this.analyzeExhaust.getBindingContext();
        Collection<DeclarationDescriptor> descriptorsWithErrors = bc.getKeys(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS);
        if (!descriptorsWithErrors.isEmpty()) {
            StringBuilder message = new StringBuilder("The following Java entities have annotations with wrong Kotlin signatures:\n");
            for (DeclarationDescriptor descriptor : descriptorsWithErrors) {
                PsiElement declaration = BindingContextUtils.descriptorToDeclaration(bc, descriptor);
                assert (declaration instanceof PsiModifierListOwner);
                List<String> errors = bc.get(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS, descriptor);
                assert (errors != null && !errors.isEmpty());
                String externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)declaration);
                message.append(externalName).append(":\n");
                for (String error : errors) {
                    message.append("    ").append(error).append("\n");
                }
            }
            this.messageCollectorWrapper.report(CompilerMessageSeverity.ERROR, message.toString(), CompilerMessageLocation.NO_LOCATION);
        }
    }

    private void reportAbiVersionErrors() {
        assert (this.analyzeExhaust != null);
        BindingContext bindingContext = this.analyzeExhaust.getBindingContext();
        Collection<PsiClass> psiClasses = bindingContext.getKeys(AbiVersionUtil.ABI_VERSION_ERRORS);
        for (PsiClass psiClass : psiClasses) {
            Integer abiVersion = bindingContext.get(AbiVersionUtil.ABI_VERSION_ERRORS, psiClass);
            this.messageCollectorWrapper.report(CompilerMessageSeverity.ERROR, "Class '" + psiClass.getQualifiedName() + "' was compiled with an incompatible version of Kotlin. " + "Its ABI version is " + abiVersion + ", expected ABI version is " + 6, MessageUtil.psiElementToMessageLocation(psiClass));
        }
    }

    public static boolean reportDiagnostics(@NotNull BindingContext bindingContext, @NotNull MessageCollector messageCollector) {
        boolean hasErrors = false;
        for (Diagnostic diagnostic : DiagnosticUtils.sortedDiagnostics(bindingContext.getDiagnostics())) {
            hasErrors |= AnalyzerWithCompilerReport.reportDiagnostic(diagnostic, messageCollector);
        }
        return hasErrors;
    }

    private void reportSyntaxErrors(@NotNull Collection<JetFile> files) {
        for (JetFile file : files) {
            AnalyzerWithCompilerReport.reportSyntaxErrors(file, this.messageCollectorWrapper);
        }
    }

    public static SyntaxErrorReport reportSyntaxErrors(final @NotNull PsiElement file, final @NotNull MessageCollector messageCollector) {
        class ErrorReportingVisitor
        extends AnalyzingUtils.PsiErrorElementVisitor {
            boolean hasErrors = false;
            boolean onlyErrorAtEof = false;

            ErrorReportingVisitor() {
            }

            private <E extends PsiElement> void reportDiagnostic(E element, DiagnosticFactory0<E> factory, String message) {
                MyDiagnostic<E> diagnostic = new MyDiagnostic<E>(element, factory, message);
                AnalyzerWithCompilerReport.reportDiagnostic(diagnostic, messageCollector);
                if (element.getTextRange().getStartOffset() == file.getTextRange().getEndOffset()) {
                    this.onlyErrorAtEof = !this.hasErrors;
                }
                this.hasErrors = true;
            }

            @Override
            public void visitIdeTemplate(JetIdeTemplate expression) {
                String placeholderText = expression.getPlaceholderText();
                this.reportDiagnostic(expression, UNRESOLVED_IDE_TEMPLATE_ERROR_FACTORY, "Unresolved IDE template" + (StringUtil.isEmpty(placeholderText) ? "" : ": " + placeholderText));
            }

            @Override
            public void visitErrorElement(PsiErrorElement element) {
                String description = element.getErrorDescription();
                this.reportDiagnostic(element, SYNTAX_ERROR_FACTORY, StringUtil.isEmpty(description) ? "Syntax error" : description);
            }
        }
        ErrorReportingVisitor visitor = new ErrorReportingVisitor();
        file.accept(visitor);
        return new SyntaxErrorReport(visitor.hasErrors, visitor.onlyErrorAtEof);
    }

    @Nullable
    public AnalyzeExhaust getAnalyzeExhaust() {
        return this.analyzeExhaust;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public void analyzeAndReport(@NotNull Function0<AnalyzeExhaust> analyzer, @NotNull Collection<JetFile> files) {
        this.reportSyntaxErrors(files);
        this.analyzeExhaust = analyzer.invoke();
        AnalyzerWithCompilerReport.reportDiagnostics(this.analyzeExhaust.getBindingContext(), this.messageCollectorWrapper);
        this.reportIncompleteHierarchies();
        this.reportAlternativeSignatureErrors();
        this.reportAbiVersionErrors();
    }

    private static class MyDiagnostic<E extends PsiElement>
    extends SimpleDiagnostic<E> {
        private String message;

        public MyDiagnostic(@NotNull E psiElement, @NotNull DiagnosticFactory0<E> factory, String message) {
            super(psiElement, factory, Severity.ERROR);
            this.message = message;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    public static class SyntaxErrorReport {
        private final boolean hasErrors;
        private final boolean onlyErrorAtEof;

        public SyntaxErrorReport(boolean hasErrors, boolean onlyErrorAtEof) {
            this.hasErrors = hasErrors;
            this.onlyErrorAtEof = onlyErrorAtEof;
        }

        public boolean isHasErrors() {
            return this.hasErrors;
        }

        public boolean isOnlyErrorAtEof() {
            return this.onlyErrorAtEof;
        }
    }
}

