/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.messages;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageCollectorPlainTextToStream;

public class MessageCollectorToString
implements MessageCollector {
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private final MessageCollector actualCollector = new MessageCollectorPlainTextToStream(new PrintStream(this.outputStream), MessageCollectorPlainTextToStream.NON_VERBOSE);
    private static final Charset UTF8 = Charset.forName("utf-8");

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
        this.actualCollector.report(severity, message, location);
    }

    @NotNull
    public String getString() {
        return UTF8.decode(ByteBuffer.wrap(this.outputStream.toByteArray())).toString();
    }
}

